/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.utils;

import com.venafi.vcert.sdk.certificate.CertificateRequest;
import com.venafi.vcert.sdk.connectors.cloud.CloudConnector;
import com.venafi.vcert.sdk.connectors.tpp.AbstractTppConnector;
import com.venafi.vcert.sdk.connectors.tpp.CustomFieldRequest;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;

public class VCertUtils {
    public static void addExpirationDateAttribute(CertificateRequest request, AbstractTppConnector.CertificateRequestsPayload payload) {
        if (request.validityHours() > 0) {
            Instant now = Instant.now();
            LocalDateTime utcTime = LocalDateTime.ofInstant(now, ZoneOffset.UTC);
            int validityDays = VCertUtils.getValidityDays(request.validityHours());
            utcTime = utcTime.plusDays(validityDays);
            String expirationDate = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(utcTime);
            String issuerHint = "";
            String expirationDateAttribute = "";
            if (request.issuerHint() != null) {
                issuerHint = String.valueOf(request.issuerHint().charAt(0));
                issuerHint = issuerHint.toUpperCase();
            }
            switch (issuerHint) {
                case "M": {
                    expirationDateAttribute = "Microsoft CA:Specific End Date";
                    break;
                }
                case "D": {
                    expirationDateAttribute = "DigiCert CA:Specific End Date";
                    break;
                }
                case "E": {
                    expirationDateAttribute = "EntrustNET CA:Specific End Date";
                    break;
                }
                default: {
                    expirationDateAttribute = "Specific End Date";
                }
            }
            payload.caSpecificAttributes().add(new AbstractTppConnector.NameValuePair<String, String>(expirationDateAttribute, expirationDate));
        }
    }

    public static int getValidityDays(int validityHours) {
        int validityDays = validityHours / 24;
        if (validityHours % 24 > 0) {
            ++validityDays;
        }
        return validityDays;
    }

    public static void addCustomFieldsToRequest(CertificateRequest request, AbstractTppConnector.CertificateRequestsPayload payload) {
        if (request.customFields() != null && request.customFields().size() > 0) {
            if (payload.customFields() == null) {
                payload.customFields(new ArrayList<CustomFieldRequest>());
            }
            request.customFields().forEach(cf -> {
                String currentFieldName = cf.name();
                CustomFieldRequest customFieldRequest = payload.customFields().stream().filter(e -> e.name().equals(currentFieldName)).findFirst().orElse(null);
                if (customFieldRequest == null) {
                    CustomFieldRequest newCustomFieldRequest = new CustomFieldRequest();
                    newCustomFieldRequest.name(currentFieldName);
                    ArrayList<String> values = new ArrayList<String>();
                    values.add(cf.value());
                    newCustomFieldRequest.values(values);
                    payload.customFields().add(newCustomFieldRequest);
                } else {
                    customFieldRequest.values().add(cf.value());
                }
            });
        }
    }

    public static String getIpAddress() throws UnknownHostException {
        return Inet4Address.getLocalHost().getHostAddress();
    }

    public static void addApiClientInformation(CloudConnector.CertificateRequestsPayload payload) {
        CloudConnector.ApiClientInformation clientInfo = new CloudConnector.ApiClientInformation();
        clientInfo.type("Venafi VCert-Java");
        try {
            clientInfo.identifier(VCertUtils.getIpAddress());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        payload.apiClientInformation(clientInfo);
    }
}

