/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk;

import com.venafi.vcert.sdk.VCertException;
import com.venafi.vcert.sdk.endpoint.Authentication;
import com.venafi.vcert.sdk.endpoint.ConnectorType;
import feign.Client;
import java.io.IOException;
import java.net.Proxy;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.ini4j.Profile;
import org.ini4j.Wini;

public class Config {
    public static final String DEFAULT_SECTION = "?";
    public static final List<String> VALID_TPP_KEYS = Arrays.asList("tpp_url", "tpp_user", "tpp_password", "tpp_zone", "trust_bundle", "app_info");
    public static final List<String> VALID_CLOUD_KEYS = Arrays.asList("cloud_url", "cloud_apikey", "cloud_zone", "trust_bundle", "cloud_project", "app_info");
    private ConnectorType connectorType;
    private String baseUrl;
    private String project;
    private String zone;
    private Authentication credentials;
    private String connectionTrust;
    private boolean logVerbose;
    private String configFile;
    private String configSection;
    private String appInfo;
    private Proxy proxy;
    private String proxyUser;
    private String proxyPassword;
    private Client client;

    public static Config loadConfigFromFile(Path path) throws VCertException {
        ConfigBuilder builder = Config.builder();
        Authentication.AuthenticationBuilder authBuilder = Authentication.builder();
        try {
            Wini ini = new Wini(path.toFile());
            Profile.Section defaultSection = (Profile.Section)ini.get((Object)DEFAULT_SECTION);
            Config.validateConfigFile(defaultSection);
            if (defaultSection.containsKey((Object)"tpp_url")) {
                builder.connectorType(ConnectorType.TPP);
                builder.baseUrl((String)defaultSection.get((Object)"tpp_url"));
                authBuilder.user((String)defaultSection.get((Object)"tpp_user"));
                authBuilder.password((String)defaultSection.get((Object)"tpp_password"));
                if (defaultSection.containsKey((Object)"tpp_zone")) {
                    builder.zone((String)defaultSection.get((Object)"tpp_zone"));
                }
            } else if (defaultSection.containsKey((Object)"cloud_apikey")) {
                authBuilder.apiKey((String)defaultSection.get((Object)"cloud_apikey"));
                if (defaultSection.containsKey((Object)"cloud_url")) {
                    builder.baseUrl((String)defaultSection.get((Object)"cloud_url"));
                }
                if (defaultSection.containsKey((Object)"cloud_zone")) {
                    builder.zone((String)defaultSection.get((Object)"cloud_zone"));
                }
                if (defaultSection.containsKey((Object)"cloud_project")) {
                    builder.project((String)defaultSection.get((Object)"cloud_project"));
                }
            }
            if (defaultSection.containsKey((Object)"app_info")) {
                builder.appInfo((String)defaultSection.get((Object)"app_info"));
            }
            builder.credentials(authBuilder.build());
            return builder.build();
        }
        catch (IOException e) {
            throw new VCertException(String.format("Access error to the configuration file: %s", path.toString()));
        }
    }

    private static void validateConfigFile(Profile.Section defaultSection) throws VCertException {
        if (Objects.isNull(defaultSection)) {
            throw new VCertException("The configuration file is empty");
        }
        if (defaultSection.containsKey((Object)"tpp_url")) {
            for (String key : defaultSection.keySet()) {
                if (VALID_TPP_KEYS.contains(key)) continue;
                throw new VCertException(String.format("illegal key %s in section %s", key, defaultSection.getName()));
            }
            if (!defaultSection.containsKey((Object)"tpp_user")) {
                throw new VCertException(String.format("configuration issue section %s: missing TPP user", defaultSection.getName()));
            }
            if (!defaultSection.containsKey((Object)"tpp_password")) {
                throw new VCertException(String.format("configuration issue section %s: missing TPP password", defaultSection.getName()));
            }
        } else if (defaultSection.containsKey((Object)"cloud_apikey")) {
            for (String key : defaultSection.keySet()) {
                if (VALID_CLOUD_KEYS.contains(key)) continue;
                throw new VCertException(String.format("illegal key %s in section %s", key, defaultSection.getName()));
            }
        } else {
            throw new VCertException(String.format("Section %s requires 'tpp_url' or 'cloud_apikey'", defaultSection.getName()));
        }
    }

    @Generated
    Config(ConnectorType connectorType, String baseUrl, String project, String zone, Authentication credentials, String connectionTrust, boolean logVerbose, String configFile, String configSection, String appInfo, Proxy proxy, String proxyUser, String proxyPassword, Client client) {
        this.connectorType = connectorType;
        this.baseUrl = baseUrl;
        this.project = project;
        this.zone = zone;
        this.credentials = credentials;
        this.connectionTrust = connectionTrust;
        this.logVerbose = logVerbose;
        this.configFile = configFile;
        this.configSection = configSection;
        this.appInfo = appInfo;
        this.proxy = proxy;
        this.proxyUser = proxyUser;
        this.proxyPassword = proxyPassword;
        this.client = client;
    }

    @Generated
    public static ConfigBuilder builder() {
        return new ConfigBuilder();
    }

    @Generated
    public ConnectorType connectorType() {
        return this.connectorType;
    }

    @Generated
    public String baseUrl() {
        return this.baseUrl;
    }

    @Generated
    public String project() {
        return this.project;
    }

    @Generated
    public String zone() {
        return this.zone;
    }

    @Generated
    public Authentication credentials() {
        return this.credentials;
    }

    @Generated
    public String connectionTrust() {
        return this.connectionTrust;
    }

    @Generated
    public boolean logVerbose() {
        return this.logVerbose;
    }

    @Generated
    public String configFile() {
        return this.configFile;
    }

    @Generated
    public String configSection() {
        return this.configSection;
    }

    @Generated
    public String appInfo() {
        return this.appInfo;
    }

    @Generated
    public Proxy proxy() {
        return this.proxy;
    }

    @Generated
    public String proxyUser() {
        return this.proxyUser;
    }

    @Generated
    public String proxyPassword() {
        return this.proxyPassword;
    }

    @Generated
    public Client client() {
        return this.client;
    }

    @Generated
    public Config connectorType(ConnectorType connectorType) {
        this.connectorType = connectorType;
        return this;
    }

    @Generated
    public Config baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    @Generated
    public Config project(String project) {
        this.project = project;
        return this;
    }

    @Generated
    public Config zone(String zone) {
        this.zone = zone;
        return this;
    }

    @Generated
    public Config credentials(Authentication credentials) {
        this.credentials = credentials;
        return this;
    }

    @Generated
    public Config connectionTrust(String connectionTrust) {
        this.connectionTrust = connectionTrust;
        return this;
    }

    @Generated
    public Config logVerbose(boolean logVerbose) {
        this.logVerbose = logVerbose;
        return this;
    }

    @Generated
    public Config configFile(String configFile) {
        this.configFile = configFile;
        return this;
    }

    @Generated
    public Config configSection(String configSection) {
        this.configSection = configSection;
        return this;
    }

    @Generated
    public Config appInfo(String appInfo) {
        this.appInfo = appInfo;
        return this;
    }

    @Generated
    public Config proxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    @Generated
    public Config proxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
        return this;
    }

    @Generated
    public Config proxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
        return this;
    }

    @Generated
    public Config client(Client client) {
        this.client = client;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Config)) {
            return false;
        }
        Config other = (Config)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.logVerbose() != other.logVerbose()) {
            return false;
        }
        ConnectorType this$connectorType = this.connectorType();
        ConnectorType other$connectorType = other.connectorType();
        if (this$connectorType == null ? other$connectorType != null : !((Object)((Object)this$connectorType)).equals((Object)other$connectorType)) {
            return false;
        }
        String this$baseUrl = this.baseUrl();
        String other$baseUrl = other.baseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        String this$project = this.project();
        String other$project = other.project();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        String this$zone = this.zone();
        String other$zone = other.zone();
        if (this$zone == null ? other$zone != null : !this$zone.equals(other$zone)) {
            return false;
        }
        Authentication this$credentials = this.credentials();
        Authentication other$credentials = other.credentials();
        if (this$credentials == null ? other$credentials != null : !((Object)this$credentials).equals(other$credentials)) {
            return false;
        }
        String this$connectionTrust = this.connectionTrust();
        String other$connectionTrust = other.connectionTrust();
        if (this$connectionTrust == null ? other$connectionTrust != null : !this$connectionTrust.equals(other$connectionTrust)) {
            return false;
        }
        String this$configFile = this.configFile();
        String other$configFile = other.configFile();
        if (this$configFile == null ? other$configFile != null : !this$configFile.equals(other$configFile)) {
            return false;
        }
        String this$configSection = this.configSection();
        String other$configSection = other.configSection();
        if (this$configSection == null ? other$configSection != null : !this$configSection.equals(other$configSection)) {
            return false;
        }
        String this$appInfo = this.appInfo();
        String other$appInfo = other.appInfo();
        if (this$appInfo == null ? other$appInfo != null : !this$appInfo.equals(other$appInfo)) {
            return false;
        }
        Proxy this$proxy = this.proxy();
        Proxy other$proxy = other.proxy();
        if (this$proxy == null ? other$proxy != null : !((Object)this$proxy).equals(other$proxy)) {
            return false;
        }
        String this$proxyUser = this.proxyUser();
        String other$proxyUser = other.proxyUser();
        if (this$proxyUser == null ? other$proxyUser != null : !this$proxyUser.equals(other$proxyUser)) {
            return false;
        }
        String this$proxyPassword = this.proxyPassword();
        String other$proxyPassword = other.proxyPassword();
        if (this$proxyPassword == null ? other$proxyPassword != null : !this$proxyPassword.equals(other$proxyPassword)) {
            return false;
        }
        Client this$client = this.client();
        Client other$client = other.client();
        return !(this$client == null ? other$client != null : !this$client.equals(other$client));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Config;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.logVerbose() ? 79 : 97);
        ConnectorType $connectorType = this.connectorType();
        result = result * 59 + ($connectorType == null ? 43 : ((Object)((Object)$connectorType)).hashCode());
        String $baseUrl = this.baseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        String $project = this.project();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        String $zone = this.zone();
        result = result * 59 + ($zone == null ? 43 : $zone.hashCode());
        Authentication $credentials = this.credentials();
        result = result * 59 + ($credentials == null ? 43 : ((Object)$credentials).hashCode());
        String $connectionTrust = this.connectionTrust();
        result = result * 59 + ($connectionTrust == null ? 43 : $connectionTrust.hashCode());
        String $configFile = this.configFile();
        result = result * 59 + ($configFile == null ? 43 : $configFile.hashCode());
        String $configSection = this.configSection();
        result = result * 59 + ($configSection == null ? 43 : $configSection.hashCode());
        String $appInfo = this.appInfo();
        result = result * 59 + ($appInfo == null ? 43 : $appInfo.hashCode());
        Proxy $proxy = this.proxy();
        result = result * 59 + ($proxy == null ? 43 : ((Object)$proxy).hashCode());
        String $proxyUser = this.proxyUser();
        result = result * 59 + ($proxyUser == null ? 43 : $proxyUser.hashCode());
        String $proxyPassword = this.proxyPassword();
        result = result * 59 + ($proxyPassword == null ? 43 : $proxyPassword.hashCode());
        Client $client = this.client();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Config(connectorType=" + this.connectorType() + ", baseUrl=" + this.baseUrl() + ", project=" + this.project() + ", zone=" + this.zone() + ", credentials=" + this.credentials() + ", connectionTrust=" + this.connectionTrust() + ", logVerbose=" + this.logVerbose() + ", configFile=" + this.configFile() + ", configSection=" + this.configSection() + ", appInfo=" + this.appInfo() + ", proxy=" + this.proxy() + ", proxyUser=" + this.proxyUser() + ", proxyPassword=" + this.proxyPassword() + ", client=" + this.client() + ")";
    }

    @Generated
    public static class ConfigBuilder {
        @Generated
        private ConnectorType connectorType;
        @Generated
        private String baseUrl;
        @Generated
        private String project;
        @Generated
        private String zone;
        @Generated
        private Authentication credentials;
        @Generated
        private String connectionTrust;
        @Generated
        private boolean logVerbose;
        @Generated
        private String configFile;
        @Generated
        private String configSection;
        @Generated
        private String appInfo;
        @Generated
        private Proxy proxy;
        @Generated
        private String proxyUser;
        @Generated
        private String proxyPassword;
        @Generated
        private Client client;

        @Generated
        ConfigBuilder() {
        }

        @Generated
        public ConfigBuilder connectorType(ConnectorType connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Generated
        public ConfigBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        @Generated
        public ConfigBuilder project(String project) {
            this.project = project;
            return this;
        }

        @Generated
        public ConfigBuilder zone(String zone) {
            this.zone = zone;
            return this;
        }

        @Generated
        public ConfigBuilder credentials(Authentication credentials) {
            this.credentials = credentials;
            return this;
        }

        @Generated
        public ConfigBuilder connectionTrust(String connectionTrust) {
            this.connectionTrust = connectionTrust;
            return this;
        }

        @Generated
        public ConfigBuilder logVerbose(boolean logVerbose) {
            this.logVerbose = logVerbose;
            return this;
        }

        @Generated
        public ConfigBuilder configFile(String configFile) {
            this.configFile = configFile;
            return this;
        }

        @Generated
        public ConfigBuilder configSection(String configSection) {
            this.configSection = configSection;
            return this;
        }

        @Generated
        public ConfigBuilder appInfo(String appInfo) {
            this.appInfo = appInfo;
            return this;
        }

        @Generated
        public ConfigBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        @Generated
        public ConfigBuilder proxyUser(String proxyUser) {
            this.proxyUser = proxyUser;
            return this;
        }

        @Generated
        public ConfigBuilder proxyPassword(String proxyPassword) {
            this.proxyPassword = proxyPassword;
            return this;
        }

        @Generated
        public ConfigBuilder client(Client client) {
            this.client = client;
            return this;
        }

        @Generated
        public Config build() {
            return new Config(this.connectorType, this.baseUrl, this.project, this.zone, this.credentials, this.connectionTrust, this.logVerbose, this.configFile, this.configSection, this.appInfo, this.proxy, this.proxyUser, this.proxyPassword, this.client);
        }

        @Generated
        public String toString() {
            return "Config.ConfigBuilder(connectorType=" + this.connectorType + ", baseUrl=" + this.baseUrl + ", project=" + this.project + ", zone=" + this.zone + ", credentials=" + this.credentials + ", connectionTrust=" + this.connectionTrust + ", logVerbose=" + this.logVerbose + ", configFile=" + this.configFile + ", configSection=" + this.configSection + ", appInfo=" + this.appInfo + ", proxy=" + this.proxy + ", proxyUser=" + this.proxyUser + ", proxyPassword=" + this.proxyPassword + ", client=" + this.client + ")";
        }
    }
}

