/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk;

import com.google.common.annotations.VisibleForTesting;
import com.venafi.vcert.sdk.Config;
import com.venafi.vcert.sdk.VCertException;
import com.venafi.vcert.sdk.certificate.CertificateRequest;
import com.venafi.vcert.sdk.certificate.ImportRequest;
import com.venafi.vcert.sdk.certificate.ImportResponse;
import com.venafi.vcert.sdk.certificate.PEMCollection;
import com.venafi.vcert.sdk.certificate.RenewalRequest;
import com.venafi.vcert.sdk.certificate.RevocationRequest;
import com.venafi.vcert.sdk.certificate.SshCaTemplateRequest;
import com.venafi.vcert.sdk.certificate.SshCertRetrieveDetails;
import com.venafi.vcert.sdk.certificate.SshCertificateRequest;
import com.venafi.vcert.sdk.certificate.SshConfig;
import com.venafi.vcert.sdk.connectors.Connector;
import com.venafi.vcert.sdk.connectors.Policy;
import com.venafi.vcert.sdk.connectors.ZoneConfiguration;
import com.venafi.vcert.sdk.connectors.cloud.Cloud;
import com.venafi.vcert.sdk.connectors.cloud.CloudConnector;
import com.venafi.vcert.sdk.connectors.tpp.Tpp;
import com.venafi.vcert.sdk.connectors.tpp.TppConnector;
import com.venafi.vcert.sdk.endpoint.Authentication;
import com.venafi.vcert.sdk.endpoint.ConnectorType;
import com.venafi.vcert.sdk.policy.domain.PolicySpecification;
import feign.FeignException;
import java.security.Provider;
import java.security.Security;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class VCertClient
implements Connector {
    protected Connector connector;

    public VCertClient(Config config) throws VCertException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.connector = this.createConnector(config);
        if (config.credentials() != null) {
            this.connector.authenticate(config.credentials());
        }
        this.connector.setVendorAndProductName(StringUtils.isBlank((CharSequence)config.appInfo()) ? "Venafi VCert-Java" : config.appInfo());
    }

    protected Connector createConnector(Config config) throws VCertException {
        Connector connector;
        switch (config.connectorType()) {
            case TPP: {
                if (StringUtils.isBlank((CharSequence)config.baseUrl())) {
                    throw new VCertException("TPP client requires a base url");
                }
                connector = new TppConnector(Tpp.connect(config));
                break;
            }
            case CLOUD: {
                connector = new CloudConnector(Cloud.connect(config));
                break;
            }
            default: {
                throw new VCertException("ConnectorType is not defined");
            }
        }
        return connector;
    }

    @VisibleForTesting
    VCertClient(Connector connector) {
        this.connector = connector;
    }

    @Override
    public Authentication getCredentials() {
        return this.connector.getCredentials();
    }

    @Override
    public ConnectorType getType() {
        return this.connector.getType();
    }

    @Override
    public void setBaseUrl(String url) throws VCertException {
        this.connector.setBaseUrl(url);
    }

    @Override
    public void setZone(String zone) {
        this.connector.setZone(zone);
    }

    @Override
    public void setVendorAndProductName(String vendorAndProductName) {
        this.connector.setVendorAndProductName(vendorAndProductName);
    }

    @Override
    public String getVendorAndProductName() {
        return this.connector.getVendorAndProductName();
    }

    @Override
    public void ping() throws VCertException {
        try {
            this.connector.ping();
        }
        catch (FeignException e) {
            throw VCertException.fromFeignException(e);
        }
    }

    @Override
    public void authenticate(Authentication credentials) throws VCertException {
        try {
            this.connector.authenticate(credentials);
        }
        catch (FeignException e) {
            throw VCertException.fromFeignException(e);
        }
    }

    @Override
    public boolean isEmptyCredentials(Authentication credentials) {
        return this.connector.isEmptyCredentials(credentials);
    }

    @Override
    public void authorize(Authentication credentials) throws VCertException {
        try {
            this.connector.authorize(credentials);
        }
        catch (FeignException e) {
            throw VCertException.fromFeignException(e);
        }
    }

    @Override
    public ZoneConfiguration readZoneConfiguration(String zone) throws VCertException {
        try {
            return this.connector.readZoneConfiguration(zone);
        }
        catch (FeignException e) {
            throw VCertException.fromFeignException(e);
        }
    }

    @Override
    public CertificateRequest generateRequest(ZoneConfiguration config, CertificateRequest request) throws VCertException {
        try {
            return this.connector.generateRequest(config, request);
        }
        catch (FeignException e) {
            throw VCertException.fromFeignException(e);
        }
    }

    @Override
    public String requestCertificate(CertificateRequest request, String zone) throws VCertException {
        try {
            return this.connector.requestCertificate(request, zone);
        }
        catch (FeignException e) {
            throw VCertException.fromFeignException(e);
        }
    }

    @Override
    public String requestCertificate(CertificateRequest request, ZoneConfiguration zoneConfiguration) throws VCertException {
        try {
            return this.connector.requestCertificate(request, zoneConfiguration);
        }
        catch (FeignException e) {
            throw VCertException.fromFeignException(e);
        }
    }

    @Override
    public PEMCollection retrieveCertificate(CertificateRequest request) throws VCertException {
        try {
            return this.connector.retrieveCertificate(request);
        }
        catch (FeignException e) {
            throw VCertException.fromFeignException(e);
        }
    }

    @Override
    public void revokeCertificate(RevocationRequest request) throws VCertException {
        try {
            this.connector.revokeCertificate(request);
        }
        catch (FeignException e) {
            throw VCertException.fromFeignException(e);
        }
    }

    @Override
    public String renewCertificate(RenewalRequest request) throws VCertException {
        try {
            return this.connector.renewCertificate(request);
        }
        catch (FeignException e) {
            throw VCertException.fromFeignException(e);
        }
    }

    @Override
    public ImportResponse importCertificate(ImportRequest request) throws VCertException {
        try {
            return this.connector.importCertificate(request);
        }
        catch (FeignException e) {
            throw VCertException.fromFeignException(e);
        }
    }

    @Override
    public Policy readPolicyConfiguration(String zone) throws VCertException {
        try {
            return this.connector.readPolicyConfiguration(zone);
        }
        catch (FeignException e) {
            throw VCertException.fromFeignException(e);
        }
    }

    @Override
    public void setPolicy(String policyName, PolicySpecification policySpecification) throws VCertException {
        try {
            this.connector.setPolicy(policyName, policySpecification);
        }
        catch (FeignException e) {
            throw VCertException.fromFeignException(e);
        }
    }

    @Override
    public PolicySpecification getPolicy(String policyName) throws VCertException {
        try {
            return this.connector.getPolicy(policyName);
        }
        catch (FeignException e) {
            throw VCertException.fromFeignException(e);
        }
    }

    @Override
    public String requestSshCertificate(SshCertificateRequest sshCertificateRequest) throws VCertException {
        try {
            return this.connector.requestSshCertificate(sshCertificateRequest);
        }
        catch (FeignException e) {
            throw VCertException.fromFeignException(e);
        }
    }

    @Override
    public SshCertRetrieveDetails retrieveSshCertificate(SshCertificateRequest sshCertificateRequest) throws VCertException {
        try {
            return this.connector.retrieveSshCertificate(sshCertificateRequest);
        }
        catch (FeignException e) {
            throw VCertException.fromFeignException(e);
        }
    }

    @Override
    public SshConfig retrieveSshConfig(SshCaTemplateRequest sshCaTemplateRequest) throws VCertException {
        try {
            return this.connector.retrieveSshConfig(sshCaTemplateRequest);
        }
        catch (FeignException e) {
            throw VCertException.fromFeignException(e);
        }
    }
}

