/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.connectors;

import com.venafi.vcert.sdk.VCertException;
import com.venafi.vcert.sdk.certificate.CertificateRequest;
import com.venafi.vcert.sdk.certificate.ImportRequest;
import com.venafi.vcert.sdk.certificate.ImportResponse;
import com.venafi.vcert.sdk.certificate.PEMCollection;
import com.venafi.vcert.sdk.certificate.RenewalRequest;
import com.venafi.vcert.sdk.certificate.RevocationRequest;
import com.venafi.vcert.sdk.connectors.ConnectorException;
import com.venafi.vcert.sdk.connectors.IPMConnector;
import com.venafi.vcert.sdk.connectors.ISSHConnector;
import com.venafi.vcert.sdk.connectors.ZoneConfiguration;
import com.venafi.vcert.sdk.endpoint.Authentication;
import com.venafi.vcert.sdk.endpoint.ConnectorType;

public interface Connector
extends ISSHConnector,
IPMConnector {
    public Authentication getCredentials();

    public ConnectorType getType();

    public void setBaseUrl(String var1) throws VCertException;

    public void setZone(String var1);

    public void setVendorAndProductName(String var1);

    public String getVendorAndProductName();

    public void ping() throws VCertException;

    default public void authenticate(Authentication credentials) throws VCertException {
        if (this.isEmptyCredentials(credentials)) {
            throw new ConnectorException.MissingCredentialsException();
        }
        this.authorize(credentials);
    }

    public boolean isEmptyCredentials(Authentication var1);

    public void authorize(Authentication var1) throws VCertException;

    public ZoneConfiguration readZoneConfiguration(String var1) throws VCertException;

    public CertificateRequest generateRequest(ZoneConfiguration var1, CertificateRequest var2) throws VCertException;

    public String requestCertificate(CertificateRequest var1, ZoneConfiguration var2) throws VCertException;

    public String requestCertificate(CertificateRequest var1, String var2) throws VCertException;

    public PEMCollection retrieveCertificate(CertificateRequest var1) throws VCertException;

    public void revokeCertificate(RevocationRequest var1) throws VCertException;

    public String renewCertificate(RenewalRequest var1) throws VCertException;

    public ImportResponse importCertificate(ImportRequest var1) throws VCertException;
}

