/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.connectors.cloud;

import com.venafi.vcert.sdk.VCertException;
import com.venafi.vcert.sdk.certificate.CertificateRequest;
import com.venafi.vcert.sdk.certificate.ChainOption;
import com.venafi.vcert.sdk.certificate.DataFormat;
import com.venafi.vcert.sdk.certificate.PEMCollection;
import com.venafi.vcert.sdk.connectors.ConnectorException;
import com.venafi.vcert.sdk.connectors.cloud.Cloud;
import com.venafi.vcert.sdk.connectors.cloud.CloudConnector;
import com.venafi.vcert.sdk.connectors.cloud.domain.Application;
import com.venafi.vcert.sdk.connectors.cloud.domain.CertificateIssuingTemplate;
import com.venafi.vcert.sdk.connectors.cloud.domain.CloudZone;
import com.venafi.vcert.sdk.connectors.cloud.domain.Team;
import com.venafi.vcert.sdk.connectors.cloud.domain.Teams;
import com.venafi.vcert.sdk.connectors.cloud.domain.User;
import com.venafi.vcert.sdk.connectors.cloud.domain.UserDetails;
import com.venafi.vcert.sdk.connectors.cloud.domain.UserResponse;
import com.venafi.vcert.sdk.connectors.cloud.endpoint.CAAccount;
import com.venafi.vcert.sdk.connectors.cloud.endpoint.CAAccountsList;
import com.venafi.vcert.sdk.connectors.cloud.endpoint.CITsList;
import com.venafi.vcert.sdk.policy.api.domain.CloudPolicy;
import com.venafi.vcert.sdk.policy.domain.PolicySpecification;
import feign.FeignException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.openssl.PEMParser;

public class CloudConnectorUtils {
    public static void setCit(String policyName, CertificateIssuingTemplate cit, CloudPolicy.CAInfo caInfo, String[] usersList, String apiKey, Cloud cloud) throws VCertException {
        CertificateIssuingTemplate citFromServer;
        CloudZone cloudZone = new CloudZone(policyName);
        cit.name(cloudZone.citAlias());
        CAAccountInfo caAccountInfo = CloudConnectorUtils.getCAAccountInfo(caInfo, apiKey, cloud);
        String caProductOptionId = caAccountInfo.productId;
        if (caProductOptionId == null) {
            throw new VCertException("Specified CA doesn't exist");
        }
        cit.certificateAuthorityProductOptionId(caProductOptionId);
        if (caInfo.caType().equals("DIGICERT")) {
            if (caAccountInfo.organizationId != null) {
                cit.product().organizationId(caAccountInfo.organizationId);
            } else {
                throw new VCertException("It was not possible to determine the Organization Id from the DIGICERT Product.");
            }
        }
        if ((citFromServer = CloudConnectorUtils.getCIT(cit.name(), apiKey, cloud)) != null) {
            cloud.updateCIT(cit, citFromServer.id(), apiKey);
            cit.id(citFromServer.id());
        } else {
            cit.id(CloudConnectorUtils.createCIT(cit, apiKey, cloud));
        }
        CloudConnectorUtils.setCitToApp(policyName, cit, usersList, apiKey, cloud);
    }

    public static CAAccountInfo getCAAccountInfo(CloudPolicy.CAInfo caInfo, String apiKey, Cloud cloud) throws VCertException {
        String caProductOptionId = null;
        Integer organizationId = null;
        CAAccountsList caAccountsList = cloud.getCAAccounts(caInfo.caType(), apiKey);
        block0: for (CAAccount caAccount : caAccountsList.accounts()) {
            if (!caAccount.account().key().equals(caInfo.caAccountKey())) continue;
            for (CAAccount.ProductOption productOption : caAccount.productOptions()) {
                if (!productOption.productName().equals(caInfo.vendorProductName())) continue;
                caProductOptionId = productOption.id();
                if (!caInfo.caType().equals("DIGICERT") || productOption.productDetails() == null || productOption.productDetails().productTemplate() == null) continue block0;
                organizationId = productOption.productDetails().productTemplate().organizationId();
                continue block0;
            }
        }
        return new CAAccountInfo(caProductOptionId, organizationId);
    }

    public static CertificateIssuingTemplate getCIT(String citName, String apiKey, Cloud cloud) throws VCertException {
        CertificateIssuingTemplate cit = null;
        CITsList citsList = cloud.getCITs(apiKey);
        for (CertificateIssuingTemplate certificateIssuingTemplate : citsList.certificateIssuingTemplates()) {
            if (!certificateIssuingTemplate.name.equals(citName)) continue;
            cit = certificateIssuingTemplate;
            break;
        }
        return cit;
    }

    public static String createCIT(CertificateIssuingTemplate cit, String apiKey, Cloud cloud) throws VCertException {
        CITsList response = cloud.createCIT(cit, apiKey);
        return response.certificateIssuingTemplates().get(0).id();
    }

    public static void setCitToApp(String policyName, CertificateIssuingTemplate cit, String[] usersList, String apiKey, Cloud cloud) throws VCertException {
        Application application;
        CloudZone zone;
        block4: {
            zone = new CloudZone(policyName);
            application = null;
            try {
                application = cloud.applicationByName(zone.appName(), apiKey);
            }
            catch (FeignException exception) {
                if (exception.status() == 404) break block4;
                throw exception;
            }
        }
        if (application == null) {
            CloudConnectorUtils.createAppForCit(cit, zone.appName(), usersList, apiKey, cloud);
        } else {
            CloudConnectorUtils.addCitToApp(cit, application, usersList, apiKey, cloud);
        }
    }

    private static void createAppForCit(CertificateIssuingTemplate cit, String appName, String[] usersList, String apiKey, Cloud cloud) throws VCertException {
        Application application = new Application();
        List<Application.OwnerIdsAndType> ownersList = CloudConnectorUtils.resolveUsersToCloudOwners(usersList, apiKey, cloud);
        HashMap<String, String> citAliasIdMap = new HashMap<String, String>();
        citAliasIdMap.put(cit.name(), cit.id());
        application.name(appName);
        application.ownerIdsAndTypes(ownersList);
        application.certificateIssuingTemplateAliasIdMap(citAliasIdMap);
        cloud.createApplication(application, apiKey);
    }

    private static void addCitToApp(CertificateIssuingTemplate cit, Application application, String[] usersList, String apiKey, Cloud cloud) throws VCertException {
        Map<String, String> citAliasIdMap = null;
        if (application.certificateIssuingTemplateAliasIdMap() != null) {
            citAliasIdMap = application.certificateIssuingTemplateAliasIdMap();
        } else {
            citAliasIdMap = new HashMap<String, String>();
            application.certificateIssuingTemplateAliasIdMap(citAliasIdMap);
        }
        if (!citAliasIdMap.containsKey(cit.name())) {
            citAliasIdMap.put(cit.name(), cit.id());
            String appId = application.id();
            application.id(null);
            application.companyId(null);
            application.fqDns(null);
            application.internalFqDns(null);
            List<Application.OwnerIdsAndType> ownersList = CloudConnectorUtils.resolveUsersToCloudOwners(usersList, apiKey, cloud);
            application.ownerIdsAndTypes(ownersList);
            cloud.updateApplication(application, appId, apiKey);
        }
    }

    private static List<Application.OwnerIdsAndType> resolveUsersToCloudOwners(String[] usersList, String apiKey, Cloud cloud) {
        ArrayList<Application.OwnerIdsAndType> ownersList = new ArrayList<Application.OwnerIdsAndType>();
        if (usersList == null) {
            UserDetails userDetails = cloud.authorize(apiKey);
            Application.OwnerIdsAndType owner = CloudConnectorUtils.createOwner("USER", userDetails.user().id());
            ownersList.add(owner);
        } else {
            Teams tResponse = null;
            block0: for (String username : usersList) {
                UserResponse response = cloud.retrieveUser(username, apiKey);
                if (response != null) {
                    Application.OwnerIdsAndType owner = CloudConnectorUtils.createOwner("USER", response.users().get(0).id());
                    ownersList.add(owner);
                    continue;
                }
                if (tResponse == null) {
                    tResponse = cloud.retrieveTeams(apiKey);
                }
                if (tResponse == null) continue;
                for (Team t : tResponse.teams()) {
                    if (!t.name().equals(username)) continue;
                    Application.OwnerIdsAndType owner = CloudConnectorUtils.createOwner("TEAM", t.id());
                    ownersList.add(owner);
                    continue block0;
                }
            }
        }
        return ownersList;
    }

    public static Application.OwnerIdsAndType createOwner(String type, String id) {
        Application.OwnerIdsAndType owner = new Application.OwnerIdsAndType();
        owner.ownerType(type);
        owner.ownerId(id);
        return owner;
    }

    public static CloudPolicy getCloudPolicy(String policyName, String apiKey, Cloud cloud) throws VCertException {
        CloudPolicy cloudPolicy = new CloudPolicy();
        String[] usersList = CloudConnectorUtils.resolveCloudOwnersNames(policyName, apiKey, cloud);
        cloudPolicy.owners(usersList);
        CertificateIssuingTemplate cit = CloudConnectorUtils.getPolicy(policyName, apiKey, cloud);
        cloudPolicy.certificateIssuingTemplate(cit);
        cloudPolicy.caInfo(CloudConnectorUtils.getCAInfo(cit, apiKey, cloud));
        return cloudPolicy;
    }

    private static String[] resolveCloudOwnersNames(String policyName, String apiKey, Cloud cloud) throws VCertException {
        CloudZone zone = new CloudZone(policyName);
        Application app = cloud.applicationByName(zone.appName(), apiKey);
        if (app == null) {
            throw new ConnectorException.VaaSApplicationNotFoundException(zone.appName());
        }
        ArrayList<String> usersList = new ArrayList<String>();
        Teams tResponse = null;
        block0: for (Application.OwnerIdsAndType owner : app.ownerIdsAndTypes()) {
            if (owner.ownerType().equals("USER")) {
                User user = cloud.retrieveUserById(owner.ownerId(), apiKey);
                usersList.add(user.username());
                continue;
            }
            if (!owner.ownerType().equals("TEAM")) continue;
            if (tResponse == null) {
                tResponse = cloud.retrieveTeams(apiKey);
            }
            if (tResponse == null) continue;
            for (Team t : tResponse.teams()) {
                if (!t.id().equals(owner.ownerId())) continue;
                usersList.add(t.name());
                continue block0;
            }
        }
        return usersList.toArray(new String[0]);
    }

    private static CertificateIssuingTemplate getPolicy(String policyName, String apiKey, Cloud cloud) throws VCertException {
        CloudZone zone = new CloudZone(policyName);
        return cloud.certificateIssuingTemplateByAppNameAndCitAlias(zone.appName(), zone.citAlias(), apiKey);
    }

    private static CloudPolicy.CAInfo getCAInfo(CertificateIssuingTemplate cit, String apiKey, Cloud cloud) throws VCertException {
        CAAccount caAccount = cloud.getCAAccount(cit.certificateAuthority, cit.certificateAuthorityAccountId(), apiKey);
        return new CloudPolicy.CAInfo(cit.certificateAuthority, caAccount.account().key(), CloudConnectorUtils.getProductName(caAccount, cit));
    }

    private static String getProductName(CAAccount caAccount, CertificateIssuingTemplate cit) {
        return caAccount.productOptions().stream().filter(p -> p.id().equals(cit.certificateAuthorityProductOptionId)).findFirst().orElse(new CAAccount.ProductOption()).productName();
    }

    public static CloudConnector.CsrAttributes buildCsrAttributes(CertificateRequest request, PolicySpecification policySpecification) throws VCertException {
        List reqOrganizations;
        String reqCN;
        CloudConnector.CsrAttributes csrAttributes = new CloudConnector.CsrAttributes();
        String string = reqCN = request.subject() != null && StringUtils.isNotBlank((CharSequence)request.subject().commonName()) ? request.subject().commonName() : null;
        if (reqCN != null) {
            String[] policyDomains = Optional.ofNullable(policySpecification).map(ps -> ps.policy()).map(p -> p.domains()).orElse(null);
            if (policyDomains != null && !CloudConnectorUtils.matchRegexes(reqCN, policyDomains)) {
                throw new ConnectorException.PolicyMatchException("CN", reqCN, "domains", policyDomains);
            }
            csrAttributes.commonName(reqCN);
        }
        if ((reqOrganizations = (List)Optional.ofNullable(request).map(req -> req.subject()).map(s -> s.organization()).orElse(null)) != null && reqOrganizations.size() > 0) {
            String[] reqOrgsArray = reqOrganizations.toArray(new String[0]);
            String[] policyOrgs = Optional.ofNullable(policySpecification).map(ps -> ps.policy()).map(p -> p.subject()).map(s -> s.orgs()).orElse(null);
            if (policyOrgs != null && !CloudConnectorUtils.matchRegexes(reqOrgsArray, policyOrgs)) {
                throw new ConnectorException.PolicyMatchException("organization", reqOrgsArray, "organization", policyOrgs);
            }
            csrAttributes.organization(reqOrgsArray[0]);
        } else {
            String defaultOrg = Optional.ofNullable(policySpecification).map(ps -> ps.defaults()).map(d -> d.subject()).map(s -> s.org()).orElse(null);
            if (StringUtils.isNotBlank((CharSequence)defaultOrg)) {
                csrAttributes.organization(defaultOrg);
            }
        }
        List reqOrgUnits = Optional.ofNullable(request).map(req -> req.subject()).map(s -> s.organizationalUnit()).orElse(null);
        if (reqOrgUnits != null && reqOrgUnits.size() > 0) {
            String[] reqOrgUnitsArray = reqOrgUnits.toArray(new String[0]);
            String[] policyOrgUnits = Optional.ofNullable(policySpecification).map(ps -> ps.policy()).map(p -> p.subject()).map(s -> s.orgUnits()).orElse(null);
            if (policyOrgUnits != null && !CloudConnectorUtils.matchRegexes(reqOrgUnitsArray, policyOrgUnits)) {
                throw new ConnectorException.PolicyMatchException("org unit", reqOrgUnitsArray, "org unit", policyOrgUnits);
            }
            csrAttributes.organizationalUnits(reqOrgUnitsArray);
        } else {
            String[] defaultOrgUnits = Optional.ofNullable(policySpecification).map(ps -> ps.defaults()).map(d -> d.subject()).map(s -> s.orgUnits()).orElse(null);
            if (defaultOrgUnits != null && defaultOrgUnits.length > 0) {
                csrAttributes.organizationalUnits(defaultOrgUnits);
            }
        }
        List reqLocalities = Optional.ofNullable(request).map(req -> req.subject()).map(s -> s.locality()).orElse(null);
        if (reqLocalities != null && reqLocalities.size() > 0) {
            String[] reqLocalitiesArray = reqLocalities.toArray(new String[0]);
            String[] policyLocalities = Optional.ofNullable(policySpecification).map(ps -> ps.policy()).map(p -> p.subject()).map(s -> s.localities()).orElse(null);
            if (policyLocalities != null && !CloudConnectorUtils.matchRegexes(reqLocalitiesArray, policyLocalities)) {
                throw new ConnectorException.PolicyMatchException("locality", reqLocalitiesArray, "localities", policyLocalities);
            }
            csrAttributes.locality(reqLocalitiesArray[0]);
        } else {
            String defaultLocality = Optional.ofNullable(policySpecification).map(ps -> ps.defaults()).map(d -> d.subject()).map(s -> s.locality()).orElse(null);
            if (StringUtils.isNotBlank((CharSequence)defaultLocality)) {
                csrAttributes.locality(defaultLocality);
            }
        }
        List reqProvince = Optional.ofNullable(request).map(req -> req.subject()).map(s -> s.province()).orElse(null);
        if (reqProvince != null && reqProvince.size() > 0) {
            String[] reqProvinceArray = reqProvince.toArray(new String[0]);
            String[] policyStates = Optional.ofNullable(policySpecification).map(ps -> ps.policy()).map(p -> p.subject()).map(s -> s.states()).orElse(null);
            if (policyStates != null && !CloudConnectorUtils.matchRegexes(reqProvinceArray, policyStates)) {
                throw new ConnectorException.PolicyMatchException("state", reqProvinceArray, "states", policyStates);
            }
            csrAttributes.state(reqProvinceArray[0]);
        } else {
            String defaultState = Optional.ofNullable(policySpecification).map(ps -> ps.defaults()).map(d -> d.subject()).map(s -> s.state()).orElse(null);
            if (StringUtils.isNotBlank((CharSequence)defaultState)) {
                csrAttributes.state(defaultState);
            }
        }
        List reqCountries = Optional.ofNullable(request).map(req -> req.subject()).map(s -> s.country()).orElse(null);
        if (reqCountries != null && reqCountries.size() > 0) {
            String[] reqCountriesArray = reqCountries.toArray(new String[0]);
            String[] policyCountries = Optional.ofNullable(policySpecification).map(ps -> ps.policy()).map(p -> p.subject()).map(s -> s.countries()).orElse(null);
            if (policyCountries != null && !CloudConnectorUtils.matchRegexes(reqCountriesArray, policyCountries)) {
                throw new ConnectorException.PolicyMatchException("state", reqCountriesArray, "states", policyCountries);
            }
            csrAttributes.country(reqCountriesArray[0]);
        } else {
            String defaultCountry = Optional.ofNullable(policySpecification).map(ps -> ps.defaults()).map(d -> d.subject()).map(s -> s.country()).orElse(null);
            if (StringUtils.isNotBlank((CharSequence)defaultCountry)) {
                csrAttributes.country(defaultCountry);
            }
        }
        if (request.dnsNames() != null && request.dnsNames().size() > 0) {
            CloudConnector.SubjectAlternativeNamesByType subjectAlternativeNamesByType = new CloudConnector.SubjectAlternativeNamesByType().dnsNames(request.dnsNames().toArray(new String[0]));
            csrAttributes.subjectAlternativeNamesByType(subjectAlternativeNamesByType);
        }
        return csrAttributes;
    }

    public static boolean matchRegexes(String subject, String[] regexes) {
        return CloudConnectorUtils.matchRegexes(new String[]{subject}, regexes);
    }

    public static boolean matchRegexes(String[] subjects, String[] regexes) {
        boolean allSubjectsMatched = true;
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String regex : regexes) {
            patterns.add(Pattern.compile(regex));
        }
        for (String subject : subjects) {
            boolean subjectMatched = false;
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(subject).matches()) continue;
                subjectMatched = true;
                break;
            }
            if (subjectMatched) continue;
            allSubjectsMatched = false;
            break;
        }
        return allSubjectsMatched;
    }

    public static String getVaaSChainOption(ChainOption chainOption) {
        switch (chainOption) {
            case ChainOptionRootFirst: {
                return "ROOT_FIRST";
            }
        }
        return "EE_FIRST";
    }

    public static PEMCollection getPEMCollectionFromKeyStoreAsStream(InputStream keyStoreAsInputStream, String certId, ChainOption chainOption, String keyPassword, DataFormat dataFormat) throws VCertException {
        String certificateAsPem = null;
        String pemFileSuffix = null;
        pemFileSuffix = chainOption == ChainOption.ChainOptionRootFirst ? "_root-first.pem" : "_root-last.pem";
        PrivateKey privateKey = null;
        try (ZipInputStream zis = new ZipInputStream(keyStoreAsInputStream);){
            ZipEntry zipEntry;
            int MAX_ENTRIES = 10;
            int MAX_UNZIPED_FILES_SIZE = 1000000;
            int entriesCount = 0;
            int unzipedAcumulatedSize = 0;
            while ((zipEntry = zis.getNextEntry()) != null) {
                if (++entriesCount > 10) {
                    throw new ConnectorException.KeyStoreZipEntriesExceeded(certId, 10);
                }
                String zipEntryContent = CloudConnectorUtils.readZipEntry(zipEntry, zis, certId);
                String fileName = zipEntry.getName();
                if (fileName.endsWith(".key")) {
                    PEMParser pemParser = new PEMParser((Reader)new StringReader(zipEntryContent));
                    privateKey = PEMCollection.decryptPKCS8PrivateKey(pemParser, keyPassword);
                } else if (fileName.endsWith(pemFileSuffix)) {
                    certificateAsPem = zipEntryContent;
                }
                if ((unzipedAcumulatedSize += zipEntryContent.getBytes().length) <= 1000000) continue;
                throw new ConnectorException.KeyStoreUnzipedFilesBytesSizeExceeded(certId, 1000000);
            }
        }
        catch (Exception e) {
            throw new VCertException(e);
        }
        return PEMCollection.fromStringPEMCollection(certificateAsPem, chainOption, privateKey, keyPassword, dataFormat);
    }

    private static String readZipEntry(ZipEntry zipEntry, ZipInputStream zis, String certId) throws VCertException, IOException {
        long totalSizeEntry = 0L;
        int MAX_RATIO = 3;
        StringBuilder s = new StringBuilder();
        byte[] buffer = new byte[1024];
        int nBytes = 0;
        while ((nBytes = zis.read(buffer, 0, 1024)) >= 0) {
            s.append(new String(buffer, 0, nBytes));
            long compressionRatio = (totalSizeEntry += (long)nBytes) / zipEntry.getCompressedSize();
            if (compressionRatio <= 3L) continue;
            throw new ConnectorException.KeyStoreZipCompressionRatioExceeded(certId, zipEntry.getName(), 3);
        }
        return s.toString();
    }

    public static class CAAccountInfo {
        private String productId;
        private Integer organizationId;

        @Generated
        public String productId() {
            return this.productId;
        }

        @Generated
        public Integer organizationId() {
            return this.organizationId;
        }

        @Generated
        public CAAccountInfo productId(String productId) {
            this.productId = productId;
            return this;
        }

        @Generated
        public CAAccountInfo organizationId(Integer organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CAAccountInfo)) {
                return false;
            }
            CAAccountInfo other = (CAAccountInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$organizationId = this.organizationId();
            Integer other$organizationId = other.organizationId();
            if (this$organizationId == null ? other$organizationId != null : !((Object)this$organizationId).equals(other$organizationId)) {
                return false;
            }
            String this$productId = this.productId();
            String other$productId = other.productId();
            return !(this$productId == null ? other$productId != null : !this$productId.equals(other$productId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CAAccountInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $organizationId = this.organizationId();
            result = result * 59 + ($organizationId == null ? 43 : ((Object)$organizationId).hashCode());
            String $productId = this.productId();
            result = result * 59 + ($productId == null ? 43 : $productId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CloudConnectorUtils.CAAccountInfo(productId=" + this.productId() + ", organizationId=" + this.organizationId() + ")";
        }

        @Generated
        public CAAccountInfo(String productId, Integer organizationId) {
            this.productId = productId;
            this.organizationId = organizationId;
        }
    }
}

