/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.connectors.tpp;

import com.google.common.io.CharStreams;
import com.venafi.vcert.sdk.VCertException;
import com.venafi.vcert.sdk.certificate.ImportRequest;
import com.venafi.vcert.sdk.certificate.ImportResponse;
import com.venafi.vcert.sdk.connectors.tpp.AbstractTppConnector;
import com.venafi.vcert.sdk.connectors.tpp.Tpp;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.BrowseIdentitiesRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.BrowseIdentitiesResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ClearPolicyAttributeRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.CreateDNRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.CreateDNResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.DNIsValidRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.DNIsValidResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.GetPolicyAttributeRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.GetPolicyAttributeResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.GetPolicyRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.GetPolicyResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.SetPolicyAttributeRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.SetPolicyAttributeResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ValidateIdentityRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ValidateIdentityResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCaTemplateRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCaTemplateResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCertRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCertRequestResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCertRetrieveRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCertRetrieveResponse;
import feign.Response;
import java.util.Map;

public abstract class TppAPI {
    protected Tpp tpp;

    public TppAPI(Tpp tpp) {
        this.tpp = tpp;
    }

    abstract String getAuthKey() throws VCertException;

    Response ping() throws VCertException {
        return this.tpp.ping(this.getAuthKey());
    }

    AbstractTppConnector.ReadZoneConfigurationResponse readZoneConfiguration(AbstractTppConnector.ReadZoneConfigurationRequest request) throws VCertException {
        return this.tpp.readZoneConfiguration(request, this.getAuthKey());
    }

    Tpp.CertificateRequestResponse requestCertificate(AbstractTppConnector.CertificateRequestsPayload payload) throws VCertException {
        return this.tpp.requestCertificate(payload, this.getAuthKey());
    }

    Tpp.CertificateRetrieveResponse certificateRetrieve(AbstractTppConnector.CertificateRetrieveRequest request) throws VCertException {
        return this.tpp.certificateRetrieve(request, this.getAuthKey());
    }

    Tpp.CertificateSearchResponse searchCertificates(Map<String, String> searchRequest) throws VCertException {
        return this.tpp.searchCertificates(searchRequest, this.getAuthKey());
    }

    Tpp.CertificateRevokeResponse revokeCertificate(AbstractTppConnector.CertificateRevokeRequest request) throws VCertException {
        return this.tpp.revokeCertificate(request, this.getAuthKey());
    }

    Tpp.CertificateRenewalResponse renewCertificate(AbstractTppConnector.CertificateRenewalRequest request) throws VCertException {
        return this.tpp.renewCertificate(request, this.getAuthKey());
    }

    ImportResponse importCertificate(ImportRequest request) throws VCertException {
        return this.tpp.importCertificate(request, this.getAuthKey());
    }

    public DNIsValidResponse dnIsValid(DNIsValidRequest request) throws VCertException {
        return this.tpp.dnIsValid(request, this.getAuthKey());
    }

    CreateDNResponse createDN(CreateDNRequest request) throws VCertException {
        return this.tpp.createDN(request, this.getAuthKey());
    }

    SetPolicyAttributeResponse setPolicyAttribute(SetPolicyAttributeRequest request) throws VCertException {
        return this.tpp.setPolicyAttribute(request, this.getAuthKey());
    }

    GetPolicyAttributeResponse getPolicyAttribute(GetPolicyAttributeRequest request) throws VCertException {
        return this.tpp.getPolicyAttribute(request, this.getAuthKey());
    }

    GetPolicyResponse getPolicy(GetPolicyRequest request) throws VCertException {
        return this.tpp.getPolicy(request, this.getAuthKey());
    }

    Response clearPolicyAttribute(ClearPolicyAttributeRequest request) throws VCertException {
        return this.tpp.clearPolicyAttribute(request, this.getAuthKey());
    }

    BrowseIdentitiesResponse browseIdentities(BrowseIdentitiesRequest request) throws VCertException {
        return this.tpp.browseIdentities(request, this.getAuthKey());
    }

    ValidateIdentityResponse validateIdentity(ValidateIdentityRequest request) throws VCertException {
        return this.tpp.validateIdentity(request, this.getAuthKey());
    }

    TppSshCertRequestResponse requestSshCertificate(TppSshCertRequest request) throws VCertException {
        return this.tpp.requestSshCertificate(request, this.getAuthKey());
    }

    TppSshCertRetrieveResponse retrieveSshCertificate(TppSshCertRetrieveRequest request) throws VCertException {
        return this.tpp.retrieveSshCertificate(request, this.getAuthKey());
    }

    String retrieveSshCAPublicKeyData(Map<String, String> params) throws VCertException {
        String publicKeyData;
        try {
            publicKeyData = CharStreams.toString((Readable)this.tpp.retrieveSshCAPublicKeyData(params).body().asReader());
        }
        catch (Exception e) {
            throw new VCertException(e);
        }
        return publicKeyData;
    }

    TppSshCaTemplateResponse retrieveSshCATemplate(TppSshCaTemplateRequest request) throws VCertException {
        return this.tpp.retrieveSshCATemplate(request, this.getAuthKey());
    }
}

