/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.connectors.tpp;

import com.venafi.vcert.sdk.VCertException;
import com.venafi.vcert.sdk.connectors.ConnectorException;
import com.venafi.vcert.sdk.connectors.TokenConnector;
import com.venafi.vcert.sdk.connectors.tpp.AbstractTppConnector;
import com.venafi.vcert.sdk.connectors.tpp.AuthorizeTokenResponse;
import com.venafi.vcert.sdk.connectors.tpp.RefreshTokenResponse;
import com.venafi.vcert.sdk.connectors.tpp.TokenInfo;
import com.venafi.vcert.sdk.connectors.tpp.Tpp;
import com.venafi.vcert.sdk.connectors.tpp.TppAPI;
import com.venafi.vcert.sdk.connectors.tpp.TppConnector;
import com.venafi.vcert.sdk.endpoint.Authentication;
import com.venafi.vcert.sdk.endpoint.ConnectorType;
import feign.FeignException;
import feign.Response;
import org.apache.commons.lang3.StringUtils;

public class TppTokenConnector
extends TppConnector
implements TokenConnector {
    private TokenInfo tokenInfo;

    public TppTokenConnector(Tpp tpp) {
        super(tpp);
    }

    @Override
    public ConnectorType getType() {
        return ConnectorType.TPP_TOKEN;
    }

    private String getAuthHeaderValue() throws VCertException {
        return this.getAuthHeaderValue(this.credentials);
    }

    private String getAuthHeaderValue(Authentication credentials) throws VCertException {
        if (this.isEmptyAccessToken(credentials)) {
            throw new ConnectorException.MissingAccessTokenException();
        }
        return String.format("Bearer %s", credentials.accessToken());
    }

    @Override
    public boolean isEmptyCredentials(Authentication credentials) {
        if (credentials == null) {
            return true;
        }
        return this.isEmptyTokens(credentials) && super.isEmptyCredentials(credentials);
    }

    @Override
    public void authorize(Authentication credentials) throws VCertException {
        if (credentials != null) {
            if (!this.isEmptyTokens(credentials)) {
                this.verifyAccessToken(credentials);
            } else {
                this.authorizeToken(credentials);
            }
        } else {
            throw new ConnectorException.MissingCredentialsException();
        }
    }

    private boolean isEmptyTokens(Authentication credentials) {
        return this.isEmptyAccessToken(credentials) && this.isEmptyRefreshToken(credentials);
    }

    private boolean isEmptyAccessToken(Authentication credentials) {
        return credentials == null || StringUtils.isBlank((CharSequence)credentials.accessToken());
    }

    private boolean isEmptyRefreshToken(Authentication credentials) {
        return credentials == null || StringUtils.isBlank((CharSequence)credentials.refreshToken());
    }

    private void verifyAccessToken(Authentication credentials) throws VCertException {
        if (!StringUtils.isBlank((CharSequence)credentials.accessToken())) {
            try {
                this.tpp.verifyToken(this.getAuthHeaderValue(credentials));
            }
            catch (FeignException.BadRequest | FeignException.Unauthorized e) {
                throw VCertException.fromFeignException((FeignException)e);
            }
        }
        this.credentials = credentials;
        this.tokenInfo = null;
    }

    private void authorizeToken(Authentication auth) throws VCertException {
        try {
            AbstractTppConnector.AuthorizeTokenRequest authRequest = new AbstractTppConnector.AuthorizeTokenRequest(auth.user(), auth.password(), auth.clientId(), auth.scope(), auth.state(), auth.redirectUri());
            AuthorizeTokenResponse response = this.tpp.authorizeToken(authRequest);
            this.tokenInfo = new TokenInfo(response.accessToken(), response.refreshToken(), response.expire(), response.tokenType(), response.scope(), response.identity(), response.refreshUntil(), true, null);
            this.setTokenCredentials(auth);
        }
        catch (FeignException.BadRequest | FeignException.Unauthorized e) {
            throw VCertException.fromFeignException((FeignException)e);
        }
    }

    private void setTokenCredentials(Authentication auth) {
        this.credentials = auth.accessToken(this.tokenInfo.accessToken()).refreshToken(this.tokenInfo.refreshToken());
    }

    @Override
    public TokenInfo getTokenInfo() throws VCertException {
        return this.tokenInfo;
    }

    @Override
    public TokenInfo getAccessToken(Authentication auth) throws VCertException {
        if (auth != null) {
            Authentication authTemp = Authentication.builder().user(auth.user()).password(auth.password()).clientId(auth.clientId()).scope(auth.scope()).state(auth.state()).redirectUri(auth.redirectUri()).build();
            this.authenticate(authTemp);
            this.setTokenCredentials(auth);
            return this.getTokenInfo();
        }
        throw new ConnectorException.MissingCredentialsException();
    }

    @Override
    public TokenInfo getAccessToken() throws VCertException {
        return this.getAccessToken(this.credentials);
    }

    @Override
    public TokenInfo refreshAccessToken(String clientId) throws VCertException {
        if (StringUtils.isBlank((CharSequence)this.credentials.refreshToken())) {
            throw new ConnectorException.MissingRefreshTokenException();
        }
        try {
            AbstractTppConnector.RefreshTokenRequest request = new AbstractTppConnector.RefreshTokenRequest(this.credentials.refreshToken(), clientId);
            RefreshTokenResponse response = this.tpp.refreshToken(request);
            this.tokenInfo = new TokenInfo(response.accessToken(), response.refreshToken(), response.expire(), response.tokenType(), response.scope(), "", response.refreshUntil(), true, null);
            this.credentials.accessToken(this.tokenInfo.accessToken());
            this.credentials.refreshToken(this.tokenInfo.refreshToken());
            return this.tokenInfo;
        }
        catch (FeignException.BadRequest e) {
            throw VCertException.fromFeignException((FeignException)((Object)e));
        }
    }

    @Override
    public int revokeAccessToken() throws VCertException {
        String requestHeader = this.getAuthHeaderValue();
        Response response = this.tpp.revokeToken(requestHeader);
        if (response.status() == 200) {
            return response.status();
        }
        throw new ConnectorException.FailedToRevokeTokenException(response.reason());
    }

    @Override
    protected TppAPI getTppAPI() {
        if (this.tppAPI == null) {
            this.tppAPI = new TppAPI(this.tpp){

                @Override
                public String getAuthKey() throws VCertException {
                    return TppTokenConnector.this.getAuthHeaderValue();
                }
            };
        }
        return this.tppAPI;
    }
}

