/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.policy.converter.cloud;

import com.venafi.vcert.sdk.VCertException;
import com.venafi.vcert.sdk.features.SupportedKeyPairs;
import com.venafi.vcert.sdk.features.SupportedRSAKeySizes;
import com.venafi.vcert.sdk.policy.converter.IPolicySpecificationValidator;
import com.venafi.vcert.sdk.policy.domain.Defaults;
import com.venafi.vcert.sdk.policy.domain.DefaultsKeyPair;
import com.venafi.vcert.sdk.policy.domain.DefaultsSubject;
import com.venafi.vcert.sdk.policy.domain.KeyPair;
import com.venafi.vcert.sdk.policy.domain.Policy;
import com.venafi.vcert.sdk.policy.domain.PolicySpecification;
import com.venafi.vcert.sdk.policy.domain.Subject;
import com.venafi.vcert.sdk.policy.domain.SubjectAltNames;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class CloudPolicySpecificationValidator
implements IPolicySpecificationValidator {
    public static final String CERTIFICATE_AUTHORITY_EXCEPTION_MESSAGE = "Certificate Authority is invalid, please provide a valid value with this structure: ca_type\\ca_account_key\\vendor_product_name";
    public static final String MAX_VALID_DAYS_EXCEPTION_MESSAGE = "The Max Valid days value should be an positive integer or zero( it will be converted to the default which is 365)";
    public static final String ATTRIBUTE_HAS_MORE_THAN_ONE_VALUE_EXCEPTION_MESSAGE = "The specified policy attribute %s has more than one value";
    public static final String ATTRIBUTE_HAS_MORE_THAN_ONE_VALUE_CONTAINING_ALLOW_ALL_STRING_EXCEPTION_MESSAGE = "The specified policy attribute %s contains the \".*\" but contains another values.";
    public static final String ATTRIBUTE_HAS_NOT_A_TWO_CHAR_STRING_VALUE_EXCEPTION_MESSAGE = "The specified policy attribute %s has a value which is not a two-char string value.";
    public static final String ATTRIBUTE_DOESNT_MATCH_WITH_ACCEPTED_VALUES_EXCEPTION_MESSAGE = "The specified value for policy attribute %s doesn't match with the supported ones";
    public static final String DEFAULT_ATTRIBUTE_DOESNT_MATCH_WITH_ACCEPTED_VALUES_EXCEPTION_MESSAGE = "The specified value for default attribute %s doesn't match with the supported ones";
    public static final String DEFAULT_ATTRIBUTE_DOESNT_MATCH_EXCEPTION_MESSAGE = "The specified value for default attribute %1$s doesn't match with the value of policy attribute %2$s";
    public static final String SUBJECT_ALT_NAME_ATTRIBUTE_DOESNT_SUPPORTED_EXCEPTION_MESSAGE = "The specified attribute %1$s can't be true due only DNS is supported.";
    public static final CloudPolicySpecificationValidator INSTANCE = new CloudPolicySpecificationValidator();

    private CloudPolicySpecificationValidator() {
    }

    @Override
    public void validate(PolicySpecification policySpecification) throws Exception {
        Policy policy = policySpecification.policy();
        Defaults defaults = policySpecification.defaults();
        if (policy != null) {
            this.validateMaxValidDays(policy);
            this.validateCertificateAuthority(policy);
            this.validatePolicySubject(policy.subject());
            this.validateKeyPair(policy.keyPair());
            this.validateSubjectAltNames(policy.subjectAltNames());
        }
        if (defaults != null) {
            this.validateDefaultSubject(defaults.subject(), policy != null ? policy.subject() : null);
            this.validateDefaultKeyPair(defaults.keyPair(), policy != null ? policy.keyPair() : null);
        }
    }

    private void validateCertificateAuthority(Policy policy) throws VCertException {
        if (policy.certificateAuthority() != null && StringUtils.split((String)policy.certificateAuthority(), (String)"\\").length < 3) {
            throw new VCertException(CERTIFICATE_AUTHORITY_EXCEPTION_MESSAGE);
        }
    }

    private void validateMaxValidDays(Policy policy) throws VCertException {
        if (policy.maxValidDays() != null && policy.maxValidDays() < 0) {
            throw new VCertException(MAX_VALID_DAYS_EXCEPTION_MESSAGE);
        }
    }

    private void validatePolicySubject(Subject subject) throws VCertException {
        if (subject != null) {
            if (subject.orgs() != null && subject.orgs().length > 1 && Arrays.stream(subject.orgs()).anyMatch(".*"::equals)) {
                throw new VCertException(String.format(ATTRIBUTE_HAS_MORE_THAN_ONE_VALUE_CONTAINING_ALLOW_ALL_STRING_EXCEPTION_MESSAGE, "orgs"));
            }
            if (subject.orgUnits() != null && subject.orgUnits().length > 1 && Arrays.stream(subject.orgUnits()).anyMatch(".*"::equals)) {
                throw new VCertException(String.format(ATTRIBUTE_HAS_MORE_THAN_ONE_VALUE_CONTAINING_ALLOW_ALL_STRING_EXCEPTION_MESSAGE, "orgUnits"));
            }
            if (subject.localities() != null && subject.localities().length > 1 && Arrays.stream(subject.localities()).anyMatch(".*"::equals)) {
                throw new VCertException(String.format(ATTRIBUTE_HAS_MORE_THAN_ONE_VALUE_CONTAINING_ALLOW_ALL_STRING_EXCEPTION_MESSAGE, "localities"));
            }
            if (subject.states() != null && subject.states().length > 1 && Arrays.stream(subject.states()).anyMatch(".*"::equals)) {
                throw new VCertException(String.format(ATTRIBUTE_HAS_MORE_THAN_ONE_VALUE_CONTAINING_ALLOW_ALL_STRING_EXCEPTION_MESSAGE, "states"));
            }
            if (subject.countries() != null && subject.countries().length > 1 && Arrays.stream(subject.countries()).anyMatch(".*"::equals)) {
                throw new VCertException(String.format(ATTRIBUTE_HAS_MORE_THAN_ONE_VALUE_CONTAINING_ALLOW_ALL_STRING_EXCEPTION_MESSAGE, "countries"));
            }
            if (subject.countries() != null && subject.countries().length > 0) {
                for (String country : subject.countries()) {
                    if (country.length() == 2) continue;
                    throw new VCertException(String.format(ATTRIBUTE_HAS_NOT_A_TWO_CHAR_STRING_VALUE_EXCEPTION_MESSAGE, "countries"));
                }
            }
        }
    }

    private void validateKeyPair(KeyPair keyPair) throws VCertException {
        if (keyPair != null) {
            int keyTypesLength;
            if (keyPair.keyTypes() != null && (keyTypesLength = keyPair.keyTypes().length) > 0 && !SupportedKeyPairs.VAAS.containsKeyTypes(keyPair.keyTypes())) {
                throw new VCertException(String.format(ATTRIBUTE_DOESNT_MATCH_WITH_ACCEPTED_VALUES_EXCEPTION_MESSAGE, "keyTypes"));
            }
            if (keyPair.rsaKeySizes() != null && !SupportedRSAKeySizes.VAAS.containsRsaKeySizes(keyPair.rsaKeySizes())) {
                throw new VCertException(String.format(ATTRIBUTE_DOESNT_MATCH_WITH_ACCEPTED_VALUES_EXCEPTION_MESSAGE, "rsaKeySizes"));
            }
        }
    }

    private void validateSubjectAltNames(SubjectAltNames subjectAltNames) throws VCertException {
        if (subjectAltNames.ipAllowed() != null && subjectAltNames.ipAllowed().booleanValue()) {
            throw new VCertException(String.format(SUBJECT_ALT_NAME_ATTRIBUTE_DOESNT_SUPPORTED_EXCEPTION_MESSAGE, "ipAllowed"));
        }
        if (subjectAltNames.emailAllowed() != null && subjectAltNames.emailAllowed().booleanValue()) {
            throw new VCertException(String.format(SUBJECT_ALT_NAME_ATTRIBUTE_DOESNT_SUPPORTED_EXCEPTION_MESSAGE, "emailAllowed"));
        }
        if (subjectAltNames.uriAllowed() != null && subjectAltNames.uriAllowed().booleanValue()) {
            throw new VCertException(String.format(SUBJECT_ALT_NAME_ATTRIBUTE_DOESNT_SUPPORTED_EXCEPTION_MESSAGE, "uriAllowed"));
        }
        if (subjectAltNames.upnAllowed() != null && subjectAltNames.upnAllowed().booleanValue()) {
            throw new VCertException(String.format(SUBJECT_ALT_NAME_ATTRIBUTE_DOESNT_SUPPORTED_EXCEPTION_MESSAGE, "upnAllowed"));
        }
    }

    private void validateDefaultSubject(DefaultsSubject defaultsSubject, Subject policySubject) throws VCertException {
        if (defaultsSubject != null) {
            if (policySubject != null) {
                if (policySubject.orgs() != null && defaultsSubject.org() != null && !defaultsSubject.org().equals("") && !Arrays.stream(policySubject.orgs()).anyMatch(".*"::equals)) {
                    if (!Arrays.stream(policySubject.orgs()).anyMatch(defaultsSubject.org()::equals)) {
                        throw new VCertException(String.format(DEFAULT_ATTRIBUTE_DOESNT_MATCH_EXCEPTION_MESSAGE, "org", "orgs"));
                    }
                }
                if (policySubject.orgUnits() != null && defaultsSubject.orgUnits() != null && !Arrays.stream(policySubject.orgUnits()).anyMatch(".*"::equals) && !Arrays.asList(policySubject.orgUnits()).containsAll(Arrays.asList(defaultsSubject.orgUnits()))) {
                    throw new VCertException(String.format(DEFAULT_ATTRIBUTE_DOESNT_MATCH_EXCEPTION_MESSAGE, "orgUnits", "orgUnits"));
                }
                if (policySubject.localities() != null && defaultsSubject.locality() != null && !defaultsSubject.locality().equals("") && !Arrays.stream(policySubject.localities()).anyMatch(".*"::equals)) {
                    if (!Arrays.stream(policySubject.localities()).anyMatch(defaultsSubject.locality()::equals)) {
                        throw new VCertException(String.format(DEFAULT_ATTRIBUTE_DOESNT_MATCH_EXCEPTION_MESSAGE, "locality", "localities"));
                    }
                }
                if (policySubject.states() != null && defaultsSubject.state() != null && !defaultsSubject.state().equals("") && !Arrays.stream(policySubject.states()).anyMatch(".*"::equals)) {
                    if (!Arrays.stream(policySubject.states()).anyMatch(defaultsSubject.state()::equals)) {
                        throw new VCertException(String.format(DEFAULT_ATTRIBUTE_DOESNT_MATCH_EXCEPTION_MESSAGE, "state", "states"));
                    }
                }
                if (policySubject.countries() != null && defaultsSubject.country() != null && !defaultsSubject.country().equals("") && !Arrays.stream(policySubject.countries()).anyMatch(".*"::equals)) {
                    if (!Arrays.stream(policySubject.countries()).anyMatch(defaultsSubject.country()::equals)) {
                        throw new VCertException(String.format(DEFAULT_ATTRIBUTE_DOESNT_MATCH_EXCEPTION_MESSAGE, "country", "countries"));
                    }
                }
            }
            if (defaultsSubject.country() != null && defaultsSubject.country().length() != 2) {
                throw new VCertException(String.format(ATTRIBUTE_HAS_NOT_A_TWO_CHAR_STRING_VALUE_EXCEPTION_MESSAGE, "country"));
            }
        }
    }

    private void validateDefaultKeyPair(DefaultsKeyPair defaultsKeyPair, KeyPair policyKeyPair) throws VCertException {
        if (defaultsKeyPair != null) {
            Integer defaultRsaKeySize;
            String defaultKeyType = defaultsKeyPair.keyType();
            if (defaultKeyType != null && !defaultKeyType.equals("")) {
                String[] policyKeyTypes;
                if (!SupportedKeyPairs.VAAS.containsKeyType(defaultKeyType)) {
                    throw new VCertException(String.format(DEFAULT_ATTRIBUTE_DOESNT_MATCH_WITH_ACCEPTED_VALUES_EXCEPTION_MESSAGE, "keyType"));
                }
                if (policyKeyPair != null && (policyKeyTypes = policyKeyPair.keyTypes()) != null && policyKeyTypes.length == 1 && !policyKeyTypes[0].equals("") && !policyKeyTypes[0].equals(defaultKeyType)) {
                    throw new VCertException(String.format(DEFAULT_ATTRIBUTE_DOESNT_MATCH_EXCEPTION_MESSAGE, "keyType", "keyTypes"));
                }
            }
            if ((defaultRsaKeySize = defaultsKeyPair.rsaKeySize()) != null) {
                if (!SupportedRSAKeySizes.VAAS.containsRsaKeySize(defaultRsaKeySize)) {
                    throw new VCertException(String.format(DEFAULT_ATTRIBUTE_DOESNT_MATCH_WITH_ACCEPTED_VALUES_EXCEPTION_MESSAGE, "rsaKeySize"));
                }
                if (policyKeyPair != null) {
                    if (!Arrays.stream(policyKeyPair.rsaKeySizes()).anyMatch(defaultRsaKeySize::equals)) {
                        throw new VCertException(String.format(DEFAULT_ATTRIBUTE_DOESNT_MATCH_EXCEPTION_MESSAGE, "rsaKeySize", "rsaKeySizes"));
                    }
                }
            }
        }
    }
}

