/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.policy.converter.tpp;

import com.venafi.vcert.sdk.policy.api.domain.AttributeLockable;
import com.venafi.vcert.sdk.policy.api.domain.TPPPolicy;
import com.venafi.vcert.sdk.policy.converter.FromPolicyConverter;
import com.venafi.vcert.sdk.policy.converter.tpp.AltName;
import com.venafi.vcert.sdk.policy.converter.tpp.ManagementTypes;
import com.venafi.vcert.sdk.policy.domain.Defaults;
import com.venafi.vcert.sdk.policy.domain.DefaultsKeyPair;
import com.venafi.vcert.sdk.policy.domain.DefaultsSubject;
import com.venafi.vcert.sdk.policy.domain.KeyPair;
import com.venafi.vcert.sdk.policy.domain.Policy;
import com.venafi.vcert.sdk.policy.domain.PolicySpecification;
import com.venafi.vcert.sdk.policy.domain.Subject;
import com.venafi.vcert.sdk.policy.domain.SubjectAltNames;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class PolicyToTppPolicyConverter
implements FromPolicyConverter<TPPPolicy> {
    public static PolicyToTppPolicyConverter INSTANCE = new PolicyToTppPolicyConverter();

    private PolicyToTppPolicyConverter() {
    }

    @Override
    public TPPPolicy convertFromPolicy(PolicySpecification policySpecification) throws Exception {
        TPPPolicy tppPolicy = new TPPPolicy();
        if (policySpecification != null) {
            this.copyStringProperty(policySpecification, tppPolicy, PolicySpecification::name, TPPPolicy::policyName);
            this.copyArrayStringProperty(policySpecification, tppPolicy, PolicySpecification::users, TPPPolicy::contact);
            this.copyArrayStringProperty(policySpecification, tppPolicy, PolicySpecification::approvers, TPPPolicy::approver);
            this.copyArrayStringProperty(policySpecification.policy(), tppPolicy, Policy::domains, TPPPolicy::domainSuffixWhiteList);
            this.copyProhibitWildcard(tppPolicy, policySpecification);
            this.copyStringProperty(policySpecification.policy(), tppPolicy, Policy::certificateAuthority, TPPPolicy::certificateAuthority);
            this.setManagementType(tppPolicy, policySpecification);
            this.copySubjectAttributes(policySpecification, tppPolicy);
            this.copyKeyPairAttributes(policySpecification, tppPolicy);
            this.setProhibitedSANTypes(tppPolicy, policySpecification);
        }
        return tppPolicy;
    }

    private <S, T> void copyStringProperty(S source, T target, Function<S, String> getter, BiConsumer<T, String> setter) {
        String stringValue;
        if (source != null && (stringValue = getter.apply(source)) != null && !stringValue.equals("")) {
            setter.accept(target, stringValue);
        }
    }

    private <S, T, V> void copyArrayStringProperty(S source, T target, Function<S, V[]> getter, BiConsumer<T, V[]> setter) {
        V[] arrayValue;
        if (source != null && (arrayValue = getter.apply(source)) != null && arrayValue.length > 0) {
            setter.accept(target, arrayValue);
        }
    }

    private <S, D, T> void copyAttributeLockableString(S source, D defaultSource, T target, Function<S, String> sourceGetter, Function<D, String> defaultGetter, BiConsumer<T, AttributeLockable> setter) {
        String value;
        if (source != null) {
            String value2 = sourceGetter.apply(source);
            if (value2 != null && !value2.equals("")) {
                setter.accept(target, new AttributeLockable<String>(new String[]{value2}, true));
            }
        } else if (defaultSource != null && (value = defaultGetter.apply(defaultSource)) != null && !value.equals("")) {
            setter.accept(target, new AttributeLockable<String>(new String[]{value}, false));
        }
    }

    private <S, D, T> void copyAttributeLockableStringMultiValue(S source, D defaultSource, T target, Function<S, String[]> sourceGetter, Function<D, String> defaultGetter, BiConsumer<T, AttributeLockable> setter) {
        String value;
        if (source != null && sourceGetter.apply(source) != null) {
            String[] arrayValues = this.filterEmptyStrings(sourceGetter.apply(source));
            if (arrayValues != null && arrayValues.length == 1) {
                setter.accept(target, new AttributeLockable<String>(new String[]{arrayValues[0]}, true));
            }
        } else if (defaultSource != null && (value = defaultGetter.apply(defaultSource)) != null && !value.equals("")) {
            setter.accept(target, new AttributeLockable<String>(new String[]{value}, false));
        }
    }

    private void setManagementType(TPPPolicy tppPolicy, PolicySpecification policySpecification) {
        Policy policy = policySpecification.policy();
        Defaults defaults = policySpecification.defaults();
        if (policy != null && policy.autoInstalled() != null) {
            tppPolicy.managementType(ManagementTypes.from((Boolean)policy.autoInstalled()).value, true);
        }
    }

    private void copyProhibitWildcard(TPPPolicy tppPolicy, PolicySpecification policySpecification) {
        Policy policy = policySpecification.policy();
        if (policy != null && policy.wildcardAllowed() != null) {
            tppPolicy.prohibitWildcard(policy.wildcardAllowed() == false ? 1 : 0);
        }
    }

    private void copySubjectAttributes(PolicySpecification policySpecification, TPPPolicy tppPolicy) {
        Subject policySubject = policySpecification.policy() != null && policySpecification.policy().subject() != null ? policySpecification.policy().subject() : null;
        DefaultsSubject defaultsSubject = policySpecification.defaults() != null && policySpecification.defaults().subject() != null ? policySpecification.defaults().subject() : null;
        this.copyAttributeLockableStringMultiValue(policySubject, defaultsSubject, tppPolicy, Subject::orgs, DefaultsSubject::org, TPPPolicy::organization);
        this.copyOrganizationalUnit(tppPolicy, policySpecification);
        this.copyAttributeLockableStringMultiValue(policySubject, defaultsSubject, tppPolicy, Subject::localities, DefaultsSubject::locality, TPPPolicy::city);
        this.copyAttributeLockableStringMultiValue(policySubject, defaultsSubject, tppPolicy, Subject::states, DefaultsSubject::state, TPPPolicy::state);
        this.copyAttributeLockableStringMultiValue(policySubject, defaultsSubject, tppPolicy, Subject::countries, DefaultsSubject::country, TPPPolicy::country);
    }

    private void copyOrganizationalUnit(TPPPolicy tppPolicy, PolicySpecification policySpecification) {
        String[] defaultsOrgUnits;
        String[] subjectOrgUnits = policySpecification.policy() != null && policySpecification.policy().subject() != null && policySpecification.policy().subject().orgUnits() != null ? this.filterEmptyStrings(policySpecification.policy().subject().orgUnits()) : null;
        String[] stringArray = defaultsOrgUnits = policySpecification.defaults() != null && policySpecification.defaults().subject() != null && policySpecification.defaults().subject().orgUnits() != null ? this.filterEmptyStrings(policySpecification.defaults().subject().orgUnits()) : null;
        if (subjectOrgUnits != null && subjectOrgUnits.length > 0) {
            tppPolicy.organizationalUnit(subjectOrgUnits, true);
        } else if (defaultsOrgUnits != null && defaultsOrgUnits.length > 0) {
            tppPolicy.organizationalUnit(defaultsOrgUnits, false);
        }
    }

    private void copyKeyPairAttributes(PolicySpecification policySpecification, TPPPolicy tppPolicy) {
        KeyPair policyKeyPair = policySpecification.policy() != null && policySpecification.policy().keyPair() != null ? policySpecification.policy().keyPair() : null;
        DefaultsKeyPair defaultsKeyPair = policySpecification.defaults() != null && policySpecification.defaults().keyPair() != null ? policySpecification.defaults().keyPair() : null;
        this.copyAttributeLockableStringMultiValue(policyKeyPair, defaultsKeyPair, tppPolicy, KeyPair::keyTypes, DefaultsKeyPair::keyType, TPPPolicy::keyAlgorithm);
        this.setKeyBitStrength(tppPolicy, policySpecification);
        this.copyAttributeLockableStringMultiValue(policyKeyPair, defaultsKeyPair, tppPolicy, KeyPair::ellipticCurves, DefaultsKeyPair::ellipticCurve, TPPPolicy::ellipticCurve);
        this.setManualCsr(tppPolicy, policySpecification);
        this.setAllowPrivateKeyReuse(tppPolicy, policySpecification);
        this.setWantRenewal(tppPolicy, policySpecification);
        this.setProhibitedSANTypes(tppPolicy, policySpecification);
    }

    private void setKeyBitStrength(TPPPolicy tppPolicy, PolicySpecification policySpecification) {
        Policy policy = policySpecification.policy();
        Defaults defaults = policySpecification.defaults();
        if (policy != null && policy.keyPair() != null) {
            Integer[] rsaKeySizes = policy.keyPair().rsaKeySizes();
            if (rsaKeySizes != null && rsaKeySizes.length == 1) {
                tppPolicy.keyBitStrength(rsaKeySizes[0].toString(), true);
            }
        } else if (defaults != null && defaults.keyPair() != null && defaults.keyPair().rsaKeySize() != null) {
            tppPolicy.keyBitStrength(defaults.keyPair().rsaKeySize().toString(), false);
        }
    }

    private void setManualCsr(TPPPolicy tppPolicy, PolicySpecification policySpecification) {
        Policy policy = policySpecification.policy();
        Defaults defaults = policySpecification.defaults();
        if (policy != null && policy.keyPair() != null && policy.keyPair().serviceGenerated() != null) {
            tppPolicy.manualCsr(policy.keyPair().serviceGenerated() != false ? "0" : "1", true);
        } else if (defaults != null && defaults.keyPair() != null && defaults.keyPair().serviceGenerated() != null) {
            tppPolicy.manualCsr(defaults.keyPair().serviceGenerated() != false ? "0" : "1", false);
        }
    }

    private void setAllowPrivateKeyReuse(TPPPolicy tppPolicy, PolicySpecification policySpecification) {
        Policy policy = policySpecification.policy();
        if (policy != null && policy.keyPair() != null && policy.keyPair().reuseAllowed() != null) {
            tppPolicy.allowPrivateKeyReuse(policy.keyPair().reuseAllowed() != false ? "1" : "0", true);
        }
    }

    private void setWantRenewal(TPPPolicy tppPolicy, PolicySpecification policySpecification) {
        Policy policy = policySpecification.policy();
        if (policy != null && policy.keyPair() != null && policy.keyPair().reuseAllowed() != null) {
            tppPolicy.wantRenewal(policy.keyPair().reuseAllowed() != false ? "1" : "0", true);
        }
    }

    private void setProhibitedSANTypes(TPPPolicy tppPolicy, PolicySpecification policySpecification) {
        SubjectAltNames subjectAltNames;
        Policy policy = policySpecification.policy();
        if (policy != null && (subjectAltNames = policy.subjectAltNames()) != null) {
            ArrayList<String> prohibitedSANTypes = new ArrayList<String>();
            if (subjectAltNames.dnsAllowed() != null && !subjectAltNames.dnsAllowed().booleanValue()) {
                prohibitedSANTypes.add(AltName.DNS.value);
            }
            if (subjectAltNames.ipAllowed() != null && !subjectAltNames.ipAllowed().booleanValue()) {
                prohibitedSANTypes.add(AltName.IP.value);
            }
            if (subjectAltNames.emailAllowed() != null && !subjectAltNames.emailAllowed().booleanValue()) {
                prohibitedSANTypes.add(AltName.EMAIL.value);
            }
            if (subjectAltNames.uriAllowed() != null && !subjectAltNames.uriAllowed().booleanValue()) {
                prohibitedSANTypes.add(AltName.URI.value);
            }
            if (subjectAltNames.upnAllowed() != null && !subjectAltNames.upnAllowed().booleanValue()) {
                prohibitedSANTypes.add(AltName.UPN.value);
            }
            if (prohibitedSANTypes.size() > 0) {
                tppPolicy.prohibitedSANTypes(prohibitedSANTypes.toArray(new String[0]));
            }
        }
    }

    private String[] filterEmptyStrings(String[] strArray) {
        Predicate<String> empty = String::isEmpty;
        Predicate<String> notEmpty = empty.negate();
        Function<String[], String[]> filter = arr -> (String[])Arrays.asList(arr).stream().filter(notEmpty).toArray(String[]::new);
        return filter.apply(strArray);
    }
}

