/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk;

import com.google.common.annotations.VisibleForTesting;
import com.venafi.vcert.sdk.Config;
import com.venafi.vcert.sdk.VCertClient;
import com.venafi.vcert.sdk.VCertException;
import com.venafi.vcert.sdk.connectors.Connector;
import com.venafi.vcert.sdk.connectors.TokenConnector;
import com.venafi.vcert.sdk.connectors.tpp.TokenInfo;
import com.venafi.vcert.sdk.connectors.tpp.Tpp;
import com.venafi.vcert.sdk.connectors.tpp.TppTokenConnector;
import com.venafi.vcert.sdk.endpoint.Authentication;
import feign.FeignException;

public class VCertTknClient
extends VCertClient
implements TokenConnector {
    public VCertTknClient(Config config) throws VCertException {
        super(config);
    }

    @Override
    protected Connector createConnector(Config config) throws VCertException {
        TppTokenConnector connector;
        switch (config.connectorType()) {
            case TPP_TOKEN: {
                connector = new TppTokenConnector(Tpp.connect(config));
                break;
            }
            default: {
                throw new VCertException("ConnectorType is not defined");
            }
        }
        return connector;
    }

    @VisibleForTesting
    VCertTknClient(TokenConnector connector) {
        super(connector);
    }

    @Override
    public TokenInfo getTokenInfo() throws VCertException {
        return ((TokenConnector)this.connector).getTokenInfo();
    }

    @Override
    public TokenInfo getAccessToken(Authentication auth) throws VCertException {
        try {
            return ((TokenConnector)this.connector).getAccessToken(auth);
        }
        catch (FeignException e) {
            throw VCertException.fromFeignException(e);
        }
    }

    @Override
    public TokenInfo getAccessToken() throws VCertException {
        try {
            return ((TokenConnector)this.connector).getAccessToken();
        }
        catch (FeignException e) {
            throw VCertException.fromFeignException(e);
        }
    }

    @Override
    public TokenInfo refreshAccessToken(String applicationId) throws VCertException {
        return ((TokenConnector)this.connector).refreshAccessToken(applicationId);
    }

    @Override
    public int revokeAccessToken() throws VCertException {
        return ((TokenConnector)this.connector).revokeAccessToken();
    }
}

