/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.connectors.tpp;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.annotations.SerializedName;
import com.venafi.vcert.sdk.VCertException;
import com.venafi.vcert.sdk.certificate.SshCaTemplateRequest;
import com.venafi.vcert.sdk.certificate.SshCertRetrieveDetails;
import com.venafi.vcert.sdk.certificate.SshCertificateRequest;
import com.venafi.vcert.sdk.certificate.SshConfig;
import com.venafi.vcert.sdk.connectors.ConnectorException;
import com.venafi.vcert.sdk.connectors.ServerPolicy;
import com.venafi.vcert.sdk.connectors.tpp.CustomFieldRequest;
import com.venafi.vcert.sdk.connectors.tpp.Tpp;
import com.venafi.vcert.sdk.connectors.tpp.TppAPI;
import com.venafi.vcert.sdk.connectors.tpp.TppConnectorUtils;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.BrowseIdentitiesRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.BrowseIdentitiesResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.IdentityEntry;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCaTemplateRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCertRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCertRequestResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCertRetrieveRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCertRetrieveResponse;
import com.venafi.vcert.sdk.policy.api.domain.TPPPolicy;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractTppConnector {
    protected static final String HEADER_VALUE_AUTHORIZATION = "Bearer %s";
    protected static final String FAILED_TO_AUTHENTICATE_MESSAGE = "failed to authenticate: ";
    protected static final String MISSING_CREDENTIALS_MESSAGE = "failed to authenticate: missing credentials";
    protected static final String MISSING_REFRESH_TOKEN_MESSAGE = "failed to authenticate: missing refresh token";
    protected static final String MISSING_ACCESS_TOKEN_MESSAGE = "failed to authenticate: missing access token";
    protected static final String TPP_ATTRIBUTE_MANAGEMENT_TYPE = "Management Type";
    protected static final String TPP_ATTRIBUTE_MANUAL_CSR = "Manual Csr";
    protected static final String LEGACY_DATA_FORMAT = "base64";
    protected static final String PKCS8_DATA_FORMAT = "base64 (PKCS #8)";
    protected static final Map<String, Integer> revocationReasons = new HashMap<String, Integer>();
    protected final Tpp tpp;
    protected String zone;
    protected String vendorAndProductName;
    protected TppAPI tppAPI;

    public AbstractTppConnector(Tpp tpp) {
        this.tpp = tpp;
        this.tppAPI = this.getTppAPI();
    }

    protected abstract TppAPI getTppAPI();

    @VisibleForTesting
    String getPolicyDN(String zone) {
        Object result = zone;
        result = ((String)result).startsWith("\\") ? result : "\\" + (String)result;
        result = ((String)result).startsWith("\\VED\\Policy") ? result : "\\VED\\Policy" + (String)result;
        return result;
    }

    public void setPolicy(String policyName, TPPPolicy tppPolicy) throws VCertException {
        if (!((String)policyName).startsWith("\\VED\\Policy\\")) {
            policyName = "\\VED\\Policy\\" + (String)policyName;
        }
        tppPolicy.policyName((String)policyName);
        if (!TppConnectorUtils.dnExist((String)policyName, this.tppAPI)) {
            String parentName = tppPolicy.getParentName();
            if (!parentName.equals("\\VED\\Policy\\") && !TppConnectorUtils.dnExist(parentName, this.tppAPI)) {
                throw new VCertException(String.format("The policy's parent %s doesn't exist", parentName));
            }
            TppConnectorUtils.createPolicy((String)policyName, this.tppAPI);
        } else {
            TppConnectorUtils.resetAttributes((String)policyName, this.tppAPI);
        }
        TppConnectorUtils.setPolicyAttributes(tppPolicy, this.tppAPI);
    }

    public TPPPolicy getTPPPolicy(String policyName) throws VCertException {
        TPPPolicy tppPolicy = new TPPPolicy();
        if (!((String)policyName).startsWith("\\VED\\Policy\\")) {
            policyName = "\\VED\\Policy\\" + (String)policyName;
        }
        tppPolicy.policyName((String)policyName);
        TppConnectorUtils.populatePolicy(tppPolicy, this.tppAPI);
        return tppPolicy;
    }

    protected String[] resolveTPPContacts(String[] contacts) throws VCertException {
        ArrayList<String> identitiesIdList = new ArrayList<String>();
        if (contacts != null) {
            for (String contact : contacts) {
                IdentityEntry identity = this.getTPPIdentity(contact);
                identitiesIdList.add(identity.prefixedUniversal());
            }
        }
        return identitiesIdList.toArray(new String[0]);
    }

    public IdentityEntry getTPPIdentity(String username) throws VCertException {
        if (username == null) {
            throw new ConnectorException.MissingTppIdentityException();
        }
        BrowseIdentitiesResponse response = this.getTppAPI().browseIdentities(new BrowseIdentitiesRequest(username, 2, 11));
        if (response.identities().length == 0) {
            throw new ConnectorException.TPPUsernameNotFoundException(username);
        }
        if (response.identities().length > 1) {
            throw new ConnectorException.IdentityExtraneousInformationException(response.identities());
        }
        IdentityEntry identity = response.identities()[0];
        return identity;
    }

    protected TppSshCertRequestResponse requestTppSshCertificate(SshCertificateRequest sshCertificateRequest) throws VCertException {
        TppSshCertRequestResponse requestResponse;
        TppSshCertRequest tppSshCertRequest = TppConnectorUtils.convertToTppSshCertReq(sshCertificateRequest);
        try {
            requestResponse = this.tppAPI.requestSshCertificate(tppSshCertRequest);
        }
        catch (Exception e) {
            throw new VCertException(e);
        }
        if (!requestResponse.response().success()) {
            throw new ConnectorException.RequestCertificateException(requestResponse.response().errorCode(), requestResponse.response().errorMessage());
        }
        return requestResponse;
    }

    protected SshCertRetrieveDetails retrieveTppSshCertificate(SshCertificateRequest sshCertificateRequest) throws VCertException {
        TppSshCertRetrieveResponse tppSshCertRetrieveResponse = null;
        TppSshCertRetrieveRequest tppSshCertRetrieveRequest = TppConnectorUtils.convertToTppSshCertRetReq(sshCertificateRequest);
        Instant startTime = Instant.now();
        while (!StringUtils.isNotBlank((CharSequence)(tppSshCertRetrieveResponse = this.tppAPI.retrieveSshCertificate(tppSshCertRetrieveRequest)).certificateData())) {
            if (tppSshCertRetrieveResponse.response().success() && tppSshCertRetrieveResponse.processingDetails().status().equals("Rejected")) {
                throw new ConnectorException.CertificateRejectedException(sshCertificateRequest.pickupID(), tppSshCertRetrieveResponse.processingDetails().statusDescription());
            }
            if (Duration.ZERO.equals(sshCertificateRequest.timeout())) {
                throw new ConnectorException.CertificatePendingException(sshCertificateRequest.pickupID(), tppSshCertRetrieveResponse.processingDetails().statusDescription());
            }
            if (Instant.now().isAfter(startTime.plus(sshCertificateRequest.timeout()))) {
                throw new ConnectorException.RetrieveCertificateTimeoutException(sshCertificateRequest.pickupID());
            }
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ConnectorException.AttemptToRetryException(e);
            }
        }
        return TppConnectorUtils.convertToSshCertRetrieveDetails(tppSshCertRetrieveResponse);
    }

    protected SshConfig retrieveTppSshConfig(SshCaTemplateRequest sshCaTemplateRequest) throws VCertException {
        SshConfig sshConfig = new SshConfig();
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)sshCaTemplateRequest.template())) {
            params.put("DN", TppConnectorUtils.getSshCADN(sshCaTemplateRequest.template()));
        } else if (StringUtils.isNotBlank((CharSequence)sshCaTemplateRequest.guid())) {
            params.put("Guid", sshCaTemplateRequest.guid());
        } else {
            throw new ConnectorException.CAOrGUIDNotProvidedException();
        }
        sshConfig.caPublicKey(this.tppAPI.retrieveSshCAPublicKeyData(params));
        sshConfig.principals(this.retrieveTppSshPrincipals(sshCaTemplateRequest));
        return sshConfig;
    }

    private String[] retrieveTppSshPrincipals(SshCaTemplateRequest sshCaTemplateRequest) throws VCertException {
        try {
            this.tppAPI.getAuthKey();
        }
        catch (VCertException e) {
            return null;
        }
        TppSshCaTemplateRequest request = new TppSshCaTemplateRequest();
        if (StringUtils.isNotBlank((CharSequence)sshCaTemplateRequest.template())) {
            request.dn(TppConnectorUtils.getSshCADN(sshCaTemplateRequest.template()));
        } else if (StringUtils.isNotBlank((CharSequence)sshCaTemplateRequest.guid())) {
            request.guid(sshCaTemplateRequest.guid());
        } else {
            throw new ConnectorException.CAOrGUIDNotProvidedException();
        }
        return this.tppAPI.retrieveSshCATemplate(request).accessControl().defaultPrincipals();
    }

    @Generated
    public String zone() {
        return this.zone;
    }

    static {
        revocationReasons.put("", 0);
        revocationReasons.put("none", 0);
        revocationReasons.put("key-compromise", 1);
        revocationReasons.put("ca-compromise", 2);
        revocationReasons.put("affiliation-changed", 3);
        revocationReasons.put("superseded", 4);
        revocationReasons.put("cessation-of-operation", 5);
    }

    public class CertificateRenewalRequest {
        private String certificateDN;
        private String PKCS10;

        @Generated
        public CertificateRenewalRequest() {
        }

        @Generated
        public String certificateDN() {
            return this.certificateDN;
        }

        @Generated
        public String PKCS10() {
            return this.PKCS10;
        }

        @Generated
        public CertificateRenewalRequest certificateDN(String certificateDN) {
            this.certificateDN = certificateDN;
            return this;
        }

        @Generated
        public CertificateRenewalRequest PKCS10(String PKCS10) {
            this.PKCS10 = PKCS10;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CertificateRenewalRequest)) {
                return false;
            }
            CertificateRenewalRequest other = (CertificateRenewalRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$certificateDN = this.certificateDN();
            String other$certificateDN = other.certificateDN();
            if (this$certificateDN == null ? other$certificateDN != null : !this$certificateDN.equals(other$certificateDN)) {
                return false;
            }
            String this$PKCS10 = this.PKCS10();
            String other$PKCS10 = other.PKCS10();
            return !(this$PKCS10 == null ? other$PKCS10 != null : !this$PKCS10.equals(other$PKCS10));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CertificateRenewalRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $certificateDN = this.certificateDN();
            result = result * 59 + ($certificateDN == null ? 43 : $certificateDN.hashCode());
            String $PKCS10 = this.PKCS10();
            result = result * 59 + ($PKCS10 == null ? 43 : $PKCS10.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AbstractTppConnector.CertificateRenewalRequest(certificateDN=" + this.certificateDN() + ", PKCS10=" + this.PKCS10() + ")";
        }
    }

    public class CertificateRevokeRequest {
        private String certificateDN;
        private String thumbprint;
        private Integer reason;
        private String comments;
        private boolean disable;

        @Generated
        public CertificateRevokeRequest() {
        }

        @Generated
        public String certificateDN() {
            return this.certificateDN;
        }

        @Generated
        public String thumbprint() {
            return this.thumbprint;
        }

        @Generated
        public Integer reason() {
            return this.reason;
        }

        @Generated
        public String comments() {
            return this.comments;
        }

        @Generated
        public boolean disable() {
            return this.disable;
        }

        @Generated
        public CertificateRevokeRequest certificateDN(String certificateDN) {
            this.certificateDN = certificateDN;
            return this;
        }

        @Generated
        public CertificateRevokeRequest thumbprint(String thumbprint) {
            this.thumbprint = thumbprint;
            return this;
        }

        @Generated
        public CertificateRevokeRequest reason(Integer reason) {
            this.reason = reason;
            return this;
        }

        @Generated
        public CertificateRevokeRequest comments(String comments) {
            this.comments = comments;
            return this;
        }

        @Generated
        public CertificateRevokeRequest disable(boolean disable) {
            this.disable = disable;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CertificateRevokeRequest)) {
                return false;
            }
            CertificateRevokeRequest other = (CertificateRevokeRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.disable() != other.disable()) {
                return false;
            }
            Integer this$reason = this.reason();
            Integer other$reason = other.reason();
            if (this$reason == null ? other$reason != null : !((Object)this$reason).equals(other$reason)) {
                return false;
            }
            String this$certificateDN = this.certificateDN();
            String other$certificateDN = other.certificateDN();
            if (this$certificateDN == null ? other$certificateDN != null : !this$certificateDN.equals(other$certificateDN)) {
                return false;
            }
            String this$thumbprint = this.thumbprint();
            String other$thumbprint = other.thumbprint();
            if (this$thumbprint == null ? other$thumbprint != null : !this$thumbprint.equals(other$thumbprint)) {
                return false;
            }
            String this$comments = this.comments();
            String other$comments = other.comments();
            return !(this$comments == null ? other$comments != null : !this$comments.equals(other$comments));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CertificateRevokeRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.disable() ? 79 : 97);
            Integer $reason = this.reason();
            result = result * 59 + ($reason == null ? 43 : ((Object)$reason).hashCode());
            String $certificateDN = this.certificateDN();
            result = result * 59 + ($certificateDN == null ? 43 : $certificateDN.hashCode());
            String $thumbprint = this.thumbprint();
            result = result * 59 + ($thumbprint == null ? 43 : $thumbprint.hashCode());
            String $comments = this.comments();
            result = result * 59 + ($comments == null ? 43 : $comments.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AbstractTppConnector.CertificateRevokeRequest(certificateDN=" + this.certificateDN() + ", thumbprint=" + this.thumbprint() + ", reason=" + this.reason() + ", comments=" + this.comments() + ", disable=" + this.disable() + ")";
        }
    }

    public class CertificateRetrieveRequest {
        private String certificateDN;
        private String format;
        private String password;
        private boolean includePrivateKey;
        private boolean includeChain;
        private String friendlyName;
        private boolean rootFirstOrder;

        @Generated
        public CertificateRetrieveRequest() {
        }

        @Generated
        public String certificateDN() {
            return this.certificateDN;
        }

        @Generated
        public String format() {
            return this.format;
        }

        @Generated
        public String password() {
            return this.password;
        }

        @Generated
        public boolean includePrivateKey() {
            return this.includePrivateKey;
        }

        @Generated
        public boolean includeChain() {
            return this.includeChain;
        }

        @Generated
        public String friendlyName() {
            return this.friendlyName;
        }

        @Generated
        public boolean rootFirstOrder() {
            return this.rootFirstOrder;
        }

        @Generated
        public CertificateRetrieveRequest certificateDN(String certificateDN) {
            this.certificateDN = certificateDN;
            return this;
        }

        @Generated
        public CertificateRetrieveRequest format(String format) {
            this.format = format;
            return this;
        }

        @Generated
        public CertificateRetrieveRequest password(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public CertificateRetrieveRequest includePrivateKey(boolean includePrivateKey) {
            this.includePrivateKey = includePrivateKey;
            return this;
        }

        @Generated
        public CertificateRetrieveRequest includeChain(boolean includeChain) {
            this.includeChain = includeChain;
            return this;
        }

        @Generated
        public CertificateRetrieveRequest friendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
            return this;
        }

        @Generated
        public CertificateRetrieveRequest rootFirstOrder(boolean rootFirstOrder) {
            this.rootFirstOrder = rootFirstOrder;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CertificateRetrieveRequest)) {
                return false;
            }
            CertificateRetrieveRequest other = (CertificateRetrieveRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.includePrivateKey() != other.includePrivateKey()) {
                return false;
            }
            if (this.includeChain() != other.includeChain()) {
                return false;
            }
            if (this.rootFirstOrder() != other.rootFirstOrder()) {
                return false;
            }
            String this$certificateDN = this.certificateDN();
            String other$certificateDN = other.certificateDN();
            if (this$certificateDN == null ? other$certificateDN != null : !this$certificateDN.equals(other$certificateDN)) {
                return false;
            }
            String this$format = this.format();
            String other$format = other.format();
            if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
                return false;
            }
            String this$password = this.password();
            String other$password = other.password();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$friendlyName = this.friendlyName();
            String other$friendlyName = other.friendlyName();
            return !(this$friendlyName == null ? other$friendlyName != null : !this$friendlyName.equals(other$friendlyName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CertificateRetrieveRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.includePrivateKey() ? 79 : 97);
            result = result * 59 + (this.includeChain() ? 79 : 97);
            result = result * 59 + (this.rootFirstOrder() ? 79 : 97);
            String $certificateDN = this.certificateDN();
            result = result * 59 + ($certificateDN == null ? 43 : $certificateDN.hashCode());
            String $format = this.format();
            result = result * 59 + ($format == null ? 43 : $format.hashCode());
            String $password = this.password();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $friendlyName = this.friendlyName();
            result = result * 59 + ($friendlyName == null ? 43 : $friendlyName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AbstractTppConnector.CertificateRetrieveRequest(certificateDN=" + this.certificateDN() + ", format=" + this.format() + ", password=" + this.password() + ", includePrivateKey=" + this.includePrivateKey() + ", includeChain=" + this.includeChain() + ", friendlyName=" + this.friendlyName() + ", rootFirstOrder=" + this.rootFirstOrder() + ")";
        }
    }

    public static class NameValuePair<K, V> {
        private K name;
        private V value;

        @Generated
        public K name() {
            return this.name;
        }

        @Generated
        public V value() {
            return this.value;
        }

        @Generated
        public NameValuePair<K, V> name(K name) {
            this.name = name;
            return this;
        }

        @Generated
        public NameValuePair<K, V> value(V value) {
            this.value = value;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NameValuePair)) {
                return false;
            }
            NameValuePair other = (NameValuePair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            K this$name = this.name();
            K other$name = other.name();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            V this$value = this.value();
            V other$value = other.value();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NameValuePair;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            K $name = this.name();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            V $value = this.value();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AbstractTppConnector.NameValuePair(name=" + this.name() + ", value=" + this.value() + ")";
        }

        @Generated
        public NameValuePair(K name, V value) {
            this.name = name;
            this.value = value;
        }
    }

    protected static class SANItem {
        private int type;
        private String name;

        @Generated
        public SANItem() {
        }

        @Generated
        public int type() {
            return this.type;
        }

        @Generated
        public String name() {
            return this.name;
        }

        @Generated
        public SANItem type(int type) {
            this.type = type;
            return this;
        }

        @Generated
        public SANItem name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SANItem)) {
                return false;
            }
            SANItem other = (SANItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.type() != other.type()) {
                return false;
            }
            String this$name = this.name();
            String other$name = other.name();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SANItem;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.type();
            String $name = this.name();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AbstractTppConnector.SANItem(type=" + this.type() + ", name=" + this.name() + ")";
        }
    }

    public static class CertificateRequestsPayload {
        @SerializedName(value="PolicyDN")
        private String policyDN;
        @SerializedName(value="CADN")
        private String cadn;
        private String objectName;
        private String subject;
        private String organizationalUnit;
        private String organization;
        private String city;
        private String state;
        private String country;
        @SerializedName(value="SubjectAltNames")
        private Collection<SANItem> subjectAltNames;
        private String contact;
        @SerializedName(value="CASpecificAttributes")
        private Collection<NameValuePair<String, String>> caSpecificAttributes;
        @SerializedName(value="PKCS10")
        private String pkcs10;
        private String keyAlgorithm;
        private int keyBitSize;
        private String ellipticCurve;
        private boolean disableAutomaticRenewal;
        private String origin;
        @SerializedName(value="CustomFields")
        private ArrayList<CustomFieldRequest> customFields;

        @Generated
        public CertificateRequestsPayload() {
        }

        @Generated
        public String policyDN() {
            return this.policyDN;
        }

        @Generated
        public String cadn() {
            return this.cadn;
        }

        @Generated
        public String objectName() {
            return this.objectName;
        }

        @Generated
        public String subject() {
            return this.subject;
        }

        @Generated
        public String organizationalUnit() {
            return this.organizationalUnit;
        }

        @Generated
        public String organization() {
            return this.organization;
        }

        @Generated
        public String city() {
            return this.city;
        }

        @Generated
        public String state() {
            return this.state;
        }

        @Generated
        public String country() {
            return this.country;
        }

        @Generated
        public Collection<SANItem> subjectAltNames() {
            return this.subjectAltNames;
        }

        @Generated
        public String contact() {
            return this.contact;
        }

        @Generated
        public Collection<NameValuePair<String, String>> caSpecificAttributes() {
            return this.caSpecificAttributes;
        }

        @Generated
        public String pkcs10() {
            return this.pkcs10;
        }

        @Generated
        public String keyAlgorithm() {
            return this.keyAlgorithm;
        }

        @Generated
        public int keyBitSize() {
            return this.keyBitSize;
        }

        @Generated
        public String ellipticCurve() {
            return this.ellipticCurve;
        }

        @Generated
        public boolean disableAutomaticRenewal() {
            return this.disableAutomaticRenewal;
        }

        @Generated
        public String origin() {
            return this.origin;
        }

        @Generated
        public ArrayList<CustomFieldRequest> customFields() {
            return this.customFields;
        }

        @Generated
        public CertificateRequestsPayload policyDN(String policyDN) {
            this.policyDN = policyDN;
            return this;
        }

        @Generated
        public CertificateRequestsPayload cadn(String cadn) {
            this.cadn = cadn;
            return this;
        }

        @Generated
        public CertificateRequestsPayload objectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        @Generated
        public CertificateRequestsPayload subject(String subject) {
            this.subject = subject;
            return this;
        }

        @Generated
        public CertificateRequestsPayload organizationalUnit(String organizationalUnit) {
            this.organizationalUnit = organizationalUnit;
            return this;
        }

        @Generated
        public CertificateRequestsPayload organization(String organization) {
            this.organization = organization;
            return this;
        }

        @Generated
        public CertificateRequestsPayload city(String city) {
            this.city = city;
            return this;
        }

        @Generated
        public CertificateRequestsPayload state(String state) {
            this.state = state;
            return this;
        }

        @Generated
        public CertificateRequestsPayload country(String country) {
            this.country = country;
            return this;
        }

        @Generated
        public CertificateRequestsPayload subjectAltNames(Collection<SANItem> subjectAltNames) {
            this.subjectAltNames = subjectAltNames;
            return this;
        }

        @Generated
        public CertificateRequestsPayload contact(String contact) {
            this.contact = contact;
            return this;
        }

        @Generated
        public CertificateRequestsPayload caSpecificAttributes(Collection<NameValuePair<String, String>> caSpecificAttributes) {
            this.caSpecificAttributes = caSpecificAttributes;
            return this;
        }

        @Generated
        public CertificateRequestsPayload pkcs10(String pkcs10) {
            this.pkcs10 = pkcs10;
            return this;
        }

        @Generated
        public CertificateRequestsPayload keyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            return this;
        }

        @Generated
        public CertificateRequestsPayload keyBitSize(int keyBitSize) {
            this.keyBitSize = keyBitSize;
            return this;
        }

        @Generated
        public CertificateRequestsPayload ellipticCurve(String ellipticCurve) {
            this.ellipticCurve = ellipticCurve;
            return this;
        }

        @Generated
        public CertificateRequestsPayload disableAutomaticRenewal(boolean disableAutomaticRenewal) {
            this.disableAutomaticRenewal = disableAutomaticRenewal;
            return this;
        }

        @Generated
        public CertificateRequestsPayload origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Generated
        public CertificateRequestsPayload customFields(ArrayList<CustomFieldRequest> customFields) {
            this.customFields = customFields;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CertificateRequestsPayload)) {
                return false;
            }
            CertificateRequestsPayload other = (CertificateRequestsPayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.keyBitSize() != other.keyBitSize()) {
                return false;
            }
            if (this.disableAutomaticRenewal() != other.disableAutomaticRenewal()) {
                return false;
            }
            String this$policyDN = this.policyDN();
            String other$policyDN = other.policyDN();
            if (this$policyDN == null ? other$policyDN != null : !this$policyDN.equals(other$policyDN)) {
                return false;
            }
            String this$cadn = this.cadn();
            String other$cadn = other.cadn();
            if (this$cadn == null ? other$cadn != null : !this$cadn.equals(other$cadn)) {
                return false;
            }
            String this$objectName = this.objectName();
            String other$objectName = other.objectName();
            if (this$objectName == null ? other$objectName != null : !this$objectName.equals(other$objectName)) {
                return false;
            }
            String this$subject = this.subject();
            String other$subject = other.subject();
            if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
                return false;
            }
            String this$organizationalUnit = this.organizationalUnit();
            String other$organizationalUnit = other.organizationalUnit();
            if (this$organizationalUnit == null ? other$organizationalUnit != null : !this$organizationalUnit.equals(other$organizationalUnit)) {
                return false;
            }
            String this$organization = this.organization();
            String other$organization = other.organization();
            if (this$organization == null ? other$organization != null : !this$organization.equals(other$organization)) {
                return false;
            }
            String this$city = this.city();
            String other$city = other.city();
            if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                return false;
            }
            String this$state = this.state();
            String other$state = other.state();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            String this$country = this.country();
            String other$country = other.country();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            Collection<SANItem> this$subjectAltNames = this.subjectAltNames();
            Collection<SANItem> other$subjectAltNames = other.subjectAltNames();
            if (this$subjectAltNames == null ? other$subjectAltNames != null : !((Object)this$subjectAltNames).equals(other$subjectAltNames)) {
                return false;
            }
            String this$contact = this.contact();
            String other$contact = other.contact();
            if (this$contact == null ? other$contact != null : !this$contact.equals(other$contact)) {
                return false;
            }
            Collection<NameValuePair<String, String>> this$caSpecificAttributes = this.caSpecificAttributes();
            Collection<NameValuePair<String, String>> other$caSpecificAttributes = other.caSpecificAttributes();
            if (this$caSpecificAttributes == null ? other$caSpecificAttributes != null : !((Object)this$caSpecificAttributes).equals(other$caSpecificAttributes)) {
                return false;
            }
            String this$pkcs10 = this.pkcs10();
            String other$pkcs10 = other.pkcs10();
            if (this$pkcs10 == null ? other$pkcs10 != null : !this$pkcs10.equals(other$pkcs10)) {
                return false;
            }
            String this$keyAlgorithm = this.keyAlgorithm();
            String other$keyAlgorithm = other.keyAlgorithm();
            if (this$keyAlgorithm == null ? other$keyAlgorithm != null : !this$keyAlgorithm.equals(other$keyAlgorithm)) {
                return false;
            }
            String this$ellipticCurve = this.ellipticCurve();
            String other$ellipticCurve = other.ellipticCurve();
            if (this$ellipticCurve == null ? other$ellipticCurve != null : !this$ellipticCurve.equals(other$ellipticCurve)) {
                return false;
            }
            String this$origin = this.origin();
            String other$origin = other.origin();
            if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
                return false;
            }
            ArrayList<CustomFieldRequest> this$customFields = this.customFields();
            ArrayList<CustomFieldRequest> other$customFields = other.customFields();
            return !(this$customFields == null ? other$customFields != null : !((Object)this$customFields).equals(other$customFields));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CertificateRequestsPayload;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.keyBitSize();
            result = result * 59 + (this.disableAutomaticRenewal() ? 79 : 97);
            String $policyDN = this.policyDN();
            result = result * 59 + ($policyDN == null ? 43 : $policyDN.hashCode());
            String $cadn = this.cadn();
            result = result * 59 + ($cadn == null ? 43 : $cadn.hashCode());
            String $objectName = this.objectName();
            result = result * 59 + ($objectName == null ? 43 : $objectName.hashCode());
            String $subject = this.subject();
            result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
            String $organizationalUnit = this.organizationalUnit();
            result = result * 59 + ($organizationalUnit == null ? 43 : $organizationalUnit.hashCode());
            String $organization = this.organization();
            result = result * 59 + ($organization == null ? 43 : $organization.hashCode());
            String $city = this.city();
            result = result * 59 + ($city == null ? 43 : $city.hashCode());
            String $state = this.state();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            String $country = this.country();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            Collection<SANItem> $subjectAltNames = this.subjectAltNames();
            result = result * 59 + ($subjectAltNames == null ? 43 : ((Object)$subjectAltNames).hashCode());
            String $contact = this.contact();
            result = result * 59 + ($contact == null ? 43 : $contact.hashCode());
            Collection<NameValuePair<String, String>> $caSpecificAttributes = this.caSpecificAttributes();
            result = result * 59 + ($caSpecificAttributes == null ? 43 : ((Object)$caSpecificAttributes).hashCode());
            String $pkcs10 = this.pkcs10();
            result = result * 59 + ($pkcs10 == null ? 43 : $pkcs10.hashCode());
            String $keyAlgorithm = this.keyAlgorithm();
            result = result * 59 + ($keyAlgorithm == null ? 43 : $keyAlgorithm.hashCode());
            String $ellipticCurve = this.ellipticCurve();
            result = result * 59 + ($ellipticCurve == null ? 43 : $ellipticCurve.hashCode());
            String $origin = this.origin();
            result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
            ArrayList<CustomFieldRequest> $customFields = this.customFields();
            result = result * 59 + ($customFields == null ? 43 : ((Object)$customFields).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AbstractTppConnector.CertificateRequestsPayload(policyDN=" + this.policyDN() + ", cadn=" + this.cadn() + ", objectName=" + this.objectName() + ", subject=" + this.subject() + ", organizationalUnit=" + this.organizationalUnit() + ", organization=" + this.organization() + ", city=" + this.city() + ", state=" + this.state() + ", country=" + this.country() + ", subjectAltNames=" + this.subjectAltNames() + ", contact=" + this.contact() + ", caSpecificAttributes=" + this.caSpecificAttributes() + ", pkcs10=" + this.pkcs10() + ", keyAlgorithm=" + this.keyAlgorithm() + ", keyBitSize=" + this.keyBitSize() + ", ellipticCurve=" + this.ellipticCurve() + ", disableAutomaticRenewal=" + this.disableAutomaticRenewal() + ", origin=" + this.origin() + ", customFields=" + this.customFields() + ")";
        }
    }

    public static class ReadZoneConfigurationResponse {
        Object error;
        ServerPolicy policy;

        @Generated
        public ReadZoneConfigurationResponse() {
        }

        @Generated
        public Object error() {
            return this.error;
        }

        @Generated
        public ServerPolicy policy() {
            return this.policy;
        }

        @Generated
        public ReadZoneConfigurationResponse error(Object error) {
            this.error = error;
            return this;
        }

        @Generated
        public ReadZoneConfigurationResponse policy(ServerPolicy policy) {
            this.policy = policy;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadZoneConfigurationResponse)) {
                return false;
            }
            ReadZoneConfigurationResponse other = (ReadZoneConfigurationResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$error = this.error();
            Object other$error = other.error();
            if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
                return false;
            }
            ServerPolicy this$policy = this.policy();
            ServerPolicy other$policy = other.policy();
            return !(this$policy == null ? other$policy != null : !((Object)this$policy).equals(other$policy));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ReadZoneConfigurationResponse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $error = this.error();
            result = result * 59 + ($error == null ? 43 : $error.hashCode());
            ServerPolicy $policy = this.policy();
            result = result * 59 + ($policy == null ? 43 : ((Object)$policy).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AbstractTppConnector.ReadZoneConfigurationResponse(error=" + this.error() + ", policy=" + this.policy() + ")";
        }
    }

    public static class ReadZoneConfigurationRequest {
        String policyDN;

        @Generated
        public String policyDN() {
            return this.policyDN;
        }

        @Generated
        public ReadZoneConfigurationRequest policyDN(String policyDN) {
            this.policyDN = policyDN;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadZoneConfigurationRequest)) {
                return false;
            }
            ReadZoneConfigurationRequest other = (ReadZoneConfigurationRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$policyDN = this.policyDN();
            String other$policyDN = other.policyDN();
            return !(this$policyDN == null ? other$policyDN != null : !this$policyDN.equals(other$policyDN));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ReadZoneConfigurationRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $policyDN = this.policyDN();
            result = result * 59 + ($policyDN == null ? 43 : $policyDN.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AbstractTppConnector.ReadZoneConfigurationRequest(policyDN=" + this.policyDN() + ")";
        }

        @Generated
        public ReadZoneConfigurationRequest(String policyDN) {
            this.policyDN = policyDN;
        }
    }

    static class RefreshTokenRequest {
        @SerializedName(value="refresh_token")
        private String refreshToken;
        @SerializedName(value="client_id")
        private String clientId;

        @Generated
        public String refreshToken() {
            return this.refreshToken;
        }

        @Generated
        public String clientId() {
            return this.clientId;
        }

        @Generated
        public RefreshTokenRequest refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        @Generated
        public RefreshTokenRequest clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RefreshTokenRequest)) {
                return false;
            }
            RefreshTokenRequest other = (RefreshTokenRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$refreshToken = this.refreshToken();
            String other$refreshToken = other.refreshToken();
            if (this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken)) {
                return false;
            }
            String this$clientId = this.clientId();
            String other$clientId = other.clientId();
            return !(this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RefreshTokenRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $refreshToken = this.refreshToken();
            result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
            String $clientId = this.clientId();
            result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AbstractTppConnector.RefreshTokenRequest(refreshToken=" + this.refreshToken() + ", clientId=" + this.clientId() + ")";
        }

        @Generated
        public RefreshTokenRequest(String refreshToken, String clientId) {
            this.refreshToken = refreshToken;
            this.clientId = clientId;
        }
    }

    static class AuthorizeTokenRequest {
        @SerializedName(value="username")
        private String username;
        @SerializedName(value="password")
        private String password;
        @SerializedName(value="client_id")
        private String clientId;
        @SerializedName(value="scope")
        private String scope;
        @SerializedName(value="state")
        private String state;
        @SerializedName(value="redirect_uri")
        private String redirectUri;

        @Generated
        public String username() {
            return this.username;
        }

        @Generated
        public String password() {
            return this.password;
        }

        @Generated
        public String clientId() {
            return this.clientId;
        }

        @Generated
        public String scope() {
            return this.scope;
        }

        @Generated
        public String state() {
            return this.state;
        }

        @Generated
        public String redirectUri() {
            return this.redirectUri;
        }

        @Generated
        public AuthorizeTokenRequest username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public AuthorizeTokenRequest password(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public AuthorizeTokenRequest clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Generated
        public AuthorizeTokenRequest scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Generated
        public AuthorizeTokenRequest state(String state) {
            this.state = state;
            return this;
        }

        @Generated
        public AuthorizeTokenRequest redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuthorizeTokenRequest)) {
                return false;
            }
            AuthorizeTokenRequest other = (AuthorizeTokenRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$username = this.username();
            String other$username = other.username();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.password();
            String other$password = other.password();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$clientId = this.clientId();
            String other$clientId = other.clientId();
            if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
                return false;
            }
            String this$scope = this.scope();
            String other$scope = other.scope();
            if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
                return false;
            }
            String this$state = this.state();
            String other$state = other.state();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            String this$redirectUri = this.redirectUri();
            String other$redirectUri = other.redirectUri();
            return !(this$redirectUri == null ? other$redirectUri != null : !this$redirectUri.equals(other$redirectUri));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AuthorizeTokenRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.username();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.password();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $clientId = this.clientId();
            result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
            String $scope = this.scope();
            result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
            String $state = this.state();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            String $redirectUri = this.redirectUri();
            result = result * 59 + ($redirectUri == null ? 43 : $redirectUri.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AbstractTppConnector.AuthorizeTokenRequest(username=" + this.username() + ", password=" + this.password() + ", clientId=" + this.clientId() + ", scope=" + this.scope() + ", state=" + this.state() + ", redirectUri=" + this.redirectUri() + ")";
        }

        @Generated
        public AuthorizeTokenRequest(String username, String password, String clientId, String scope, String state, String redirectUri) {
            this.username = username;
            this.password = password;
            this.clientId = clientId;
            this.scope = scope;
            this.state = state;
            this.redirectUri = redirectUri;
        }
    }

    public static class AuthorizeRequest {
        private String username;
        private String password;

        @Generated
        public String username() {
            return this.username;
        }

        @Generated
        public String password() {
            return this.password;
        }

        @Generated
        public AuthorizeRequest username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public AuthorizeRequest password(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuthorizeRequest)) {
                return false;
            }
            AuthorizeRequest other = (AuthorizeRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$username = this.username();
            String other$username = other.username();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.password();
            String other$password = other.password();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AuthorizeRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.username();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.password();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AbstractTppConnector.AuthorizeRequest(username=" + this.username() + ", password=" + this.password() + ")";
        }

        @Generated
        public AuthorizeRequest(String username, String password) {
            this.username = username;
            this.password = password;
        }
    }
}

