/*
 * Decompiled with CFR 0.152.
 */
package com.venafi.vcert.sdk.connectors.tpp;

import com.venafi.vcert.sdk.Config;
import com.venafi.vcert.sdk.certificate.ImportRequest;
import com.venafi.vcert.sdk.certificate.ImportResponse;
import com.venafi.vcert.sdk.connectors.tpp.AbstractTppConnector;
import com.venafi.vcert.sdk.connectors.tpp.AuthorizeTokenResponse;
import com.venafi.vcert.sdk.connectors.tpp.RefreshTokenResponse;
import com.venafi.vcert.sdk.connectors.tpp.Tpp;
import com.venafi.vcert.sdk.connectors.tpp.VerifyTokenResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.BrowseIdentitiesRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.BrowseIdentitiesResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ClearPolicyAttributeRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.CreateDNRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.CreateDNResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.DNIsValidRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.DNIsValidResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.GetPolicyAttributeRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.GetPolicyAttributeResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.GetPolicyRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.GetPolicyResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.SetPolicyAttributeRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.SetPolicyAttributeResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ValidateIdentityRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ValidateIdentityResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCaTemplateRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCaTemplateResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCertRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCertRequestResponse;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCertRetrieveRequest;
import com.venafi.vcert.sdk.connectors.tpp.endpoint.ssh.TppSshCertRetrieveResponse;
import com.venafi.vcert.sdk.utils.FeignUtils;
import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import feign.Response;
import java.util.Map;

public interface TppToken
extends Tpp {
    @Override
    @RequestLine(value="POST /vedauth/authorize/oauth")
    @Headers(value={"Content-Type: application/json"})
    public AuthorizeTokenResponse authorizeToken(AbstractTppConnector.AuthorizeTokenRequest var1);

    @Override
    @RequestLine(value="GET /vedauth/authorize/verify")
    @Headers(value={"Authorization: {token}"})
    public VerifyTokenResponse verifyToken(@Param(value="token") String var1);

    @Override
    @RequestLine(value="POST /vedauth/authorize/token")
    @Headers(value={"Content-Type: application/json"})
    public RefreshTokenResponse refreshToken(AbstractTppConnector.RefreshTokenRequest var1);

    @Override
    @RequestLine(value="GET /vedauth/revoke/token")
    @Headers(value={"Authorization: {token}"})
    public Response revokeToken(@Param(value="token") String var1);

    @Override
    @RequestLine(value="POST /vedsdk/certificates/checkpolicy")
    @Headers(value={"Content-Type: application/json", "Authorization: {token}"})
    public AbstractTppConnector.ReadZoneConfigurationResponse readZoneConfiguration(AbstractTppConnector.ReadZoneConfigurationRequest var1, @Param(value="token") String var2);

    @Override
    @RequestLine(value="POST /vedsdk/certificates/request")
    @Headers(value={"Content-Type: application/json", "Authorization: {token}"})
    public Tpp.CertificateRequestResponse requestCertificate(AbstractTppConnector.CertificateRequestsPayload var1, @Param(value="token") String var2);

    @Override
    @RequestLine(value="GET /vedsdk/certificates/")
    @Headers(value={"Authorization: {token}"})
    public Tpp.CertificateSearchResponse searchCertificates(@QueryMap Map<String, String> var1, @Param(value="token") String var2);

    @Override
    @RequestLine(value="POST /vedsdk/certificates/retrieve")
    @Headers(value={"Content-Type: application/json", "Authorization: {token}"})
    public Tpp.CertificateRetrieveResponse certificateRetrieve(AbstractTppConnector.CertificateRetrieveRequest var1, @Param(value="token") String var2);

    @Override
    @RequestLine(value="POST /vedsdk/certificates/revoke")
    @Headers(value={"Content-Type: application/json", "Authorization: {token}"})
    public Tpp.CertificateRevokeResponse revokeCertificate(AbstractTppConnector.CertificateRevokeRequest var1, @Param(value="token") String var2);

    @Override
    @RequestLine(value="POST /vedsdk/certificates/renew")
    @Headers(value={"Content-Type: application/json", "Authorization: {token}"})
    public Tpp.CertificateRenewalResponse renewCertificate(AbstractTppConnector.CertificateRenewalRequest var1, @Param(value="token") String var2);

    @Override
    @RequestLine(value="POST /vedsdk/certificates/import")
    @Headers(value={"Content-Type: application/json", "Authorization: {token}"})
    public ImportResponse importCertificate(ImportRequest var1, @Param(value="token") String var2);

    @Override
    @RequestLine(value="GET /vedsdk")
    @Headers(value={"Authorization: {token}"})
    public Response ping(@Param(value="token") String var1);

    @Override
    @RequestLine(value="POST /vedsdk/Config/IsValid")
    @Headers(value={"Content-Type: application/json", "Authorization: {token}"})
    public DNIsValidResponse dnIsValid(DNIsValidRequest var1, @Param(value="token") String var2);

    @Override
    @RequestLine(value="POST /vedsdk/Config/Create")
    @Headers(value={"Content-Type: application/json", "Authorization: {token}"})
    public CreateDNResponse createDN(CreateDNRequest var1, @Param(value="token") String var2);

    @Override
    @RequestLine(value="POST /vedsdk/Config/WritePolicy")
    @Headers(value={"Content-Type: application/json", "Authorization: {token}"})
    public SetPolicyAttributeResponse setPolicyAttribute(SetPolicyAttributeRequest var1, @Param(value="token") String var2);

    @Override
    @RequestLine(value="POST /vedsdk/Config/ReadPolicy")
    @Headers(value={"Content-Type: application/json", "Authorization: {token}"})
    public GetPolicyAttributeResponse getPolicyAttribute(GetPolicyAttributeRequest var1, @Param(value="token") String var2);

    @Override
    @RequestLine(value="POST /vedsdk/Certificates/CheckPolicy")
    @Headers(value={"Content-Type: application/json", "Authorization: {token}"})
    public GetPolicyResponse getPolicy(GetPolicyRequest var1, @Param(value="token") String var2);

    @Override
    @RequestLine(value="POST /vedsdk/Config/ClearPolicyAttribute")
    @Headers(value={"Content-Type: application/json", "Authorization: {token}"})
    public Response clearPolicyAttribute(ClearPolicyAttributeRequest var1, @Param(value="token") String var2);

    @Override
    @RequestLine(value="POST /vedsdk/Identity/Browse")
    @Headers(value={"Content-Type: application/json", "Authorization: {token}"})
    public BrowseIdentitiesResponse browseIdentities(BrowseIdentitiesRequest var1, @Param(value="token") String var2);

    @Override
    @RequestLine(value="POST /vedsdk/Identity/Validate")
    @Headers(value={"Content-Type: application/json", "Authorization: {token}"})
    public ValidateIdentityResponse validateIdentity(ValidateIdentityRequest var1, @Param(value="token") String var2);

    @Override
    @RequestLine(value="POST /vedsdk/SSHCertificates/request")
    @Headers(value={"Content-Type: application/json", "Authorization: {token}"})
    public TppSshCertRequestResponse requestSshCertificate(TppSshCertRequest var1, @Param(value="token") String var2);

    @Override
    @RequestLine(value="POST /vedsdk/SSHCertificates/retrieve")
    @Headers(value={"Content-Type: application/json", "Authorization: {token}"})
    public TppSshCertRetrieveResponse retrieveSshCertificate(TppSshCertRetrieveRequest var1, @Param(value="token") String var2);

    @Override
    @RequestLine(value="GET /vedsdk/SSHCertificates/Template/Retrieve/PublicKeyData")
    @Headers(value={"Content-Type: text/plain"})
    public Response retrieveSshCAPublicKeyData(@QueryMap Map<String, String> var1);

    @Override
    @RequestLine(value="POST vedsdk/SSHCertificates/Template/Retrieve")
    @Headers(value={"Content-Type: application/json", "Authorization: {token}"})
    public TppSshCaTemplateResponse retrieveSshCATemplate(TppSshCaTemplateRequest var1, @Param(value="token") String var2);

    public static Tpp connect(String baseUrl) {
        return FeignUtils.client(TppToken.class, Config.builder().baseUrl(baseUrl).build());
    }

    public static Tpp connect(Config config) {
        return FeignUtils.client(TppToken.class, config);
    }
}

