/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.wsilk.codegen;

import com.wuba.wsilk.codegen.JParser;
import com.wuba.wsilk.codegen.MergeCode;
import com.wuba.wsilk.codegen.SerializeInfo;
import com.wuba.wsilk.codegen.parser.JavaUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaMergeCode
implements MergeCode {
    private static final Log log = LogFactory.getLog(JavaMergeCode.class);
    private String code;
    private JavaUnit codeUnit;

    public static Code getCustomCode(String oldCode, String javaName, String childName) {
        Code code = null;
        int start = 0;
        int startEnd = 0;
        int end = 0;
        String p = "(public|protected)(\\s+)class(\\s+)" + javaName + "(\\s+)extends(\\s+)" + childName + "(\\s?)\\{";
        Pattern pt = Pattern.compile(p);
        Matcher mt = pt.matcher(oldCode);
        if (mt.find()) {
            start = mt.start();
            startEnd = mt.end();
        }
        if (start > 0) {
            String top;
            code = new Code();
            code.top = top = oldCode.substring(0, start);
            pt = Pattern.compile("\\}(\\s+)(abstract(\\s+))?class(\\s+)" + childName);
            mt = pt.matcher(oldCode);
            if (mt.find()) {
                end = mt.start();
            }
            if (end > 0 && end > startEnd) {
                code.custom = StringUtils.trimToEmpty((String)oldCode.substring(startEnd, end));
            }
        }
        return code;
    }

    public static JavaMergeCode create(SerializeInfo serializeInfo, String javaName, String childName) {
        Code code;
        JavaMergeCode customerCode = null;
        if (StringUtils.isNotEmpty((CharSequence)serializeInfo.getJavaCode()) && childName != null && (code = JavaMergeCode.getCustomCode(serializeInfo.getJavaCode(), javaName, childName)) != null && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{code.top})) {
            JavaUnit javaUnit;
            if (log.isDebugEnabled()) {
                log.debug((Object)javaName);
            }
            if ((javaUnit = JParser.parser(code.top)) != null) {
                customerCode = new JavaMergeCode();
                customerCode.setCodeUnit(javaUnit);
                customerCode.setCode(code.custom);
            }
        }
        return customerCode;
    }

    public String getCode() {
        return this.code;
    }

    public JavaUnit getCodeUnit() {
        return this.codeUnit;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setCodeUnit(JavaUnit codeUnit) {
        this.codeUnit = codeUnit;
    }

    static class Code {
        String top;
        String custom;
    }
}

