/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.wsilk.codegen;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.wuba.wsilk.codegen.AbstractCodeWriter;
import com.wuba.wsilk.codegen.CodeWriter;
import com.wuba.wsilk.codegen.Constants;
import com.wuba.wsilk.codegen.IJavaWriter;
import com.wuba.wsilk.codegen.IMergeWriter;
import com.wuba.wsilk.codegen.JavaMergeCode;
import com.wuba.wsilk.codegen.Modifier;
import com.wuba.wsilk.codegen.Pair;
import com.wuba.wsilk.codegen.annoataion.AnnotationBean;
import com.wuba.wsilk.codegen.annoataion.AnnotationBeans;
import com.wuba.wsilk.codegen.annoataion.AnnotationUtils;
import com.wuba.wsilk.codegen.annoataion.AnnotationValue;
import com.wuba.wsilk.codegen.model.Parameter;
import com.wuba.wsilk.codegen.model.Type;
import com.wuba.wsilk.codegen.model.Types;
import com.wuba.wsilk.codegen.parser.JavaUnit;
import com.wuba.wsilk.codegen.spec.FieldElement;
import com.wuba.wsilk.codegen.spec.MethodElement;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;

public class JavaWriter
extends AbstractCodeWriter<JavaWriter>
implements IJavaWriter<JavaWriter>,
IMergeWriter<JavaMergeCode>,
CodeWriter<JavaWriter> {
    private static final String JAVA_LANG = "java.lang";
    private Set<String> classes = new HashSet<String>();
    private Set<String> packages = new HashSet<String>();
    private Set<String> statics = new HashSet<String>();
    private Stack<Type> types = new Stack();
    private final AnnotationBeans annotations = new AnnotationBeans();
    private JavaMergeCode mergeCode;
    private boolean mergeAnnotation = true;

    public JavaWriter reInit(JavaWriter javaWriter) {
        javaWriter.setClasses(this.classes);
        javaWriter.setPackages(this.packages);
        javaWriter.setTypes(this.types);
        return javaWriter;
    }

    public JavaWriter(Appendable appendable) {
        super(appendable, 4);
        this.packages.add(JAVA_LANG);
    }

    public void setMergeCode(JavaMergeCode mergeCode) {
        this.mergeCode = mergeCode;
    }

    public void mergeImport() throws IOException {
        if (this.mergeCode != null && this.mergeCode.getCodeUnit() != null) {
            JavaUnit javaUnit = this.mergeCode.getCodeUnit();
            if (javaUnit.getPackages() != null && javaUnit.getPackages().size() > 0) {
                for (String im : javaUnit.getPackages()) {
                    if (this.packages.contains(im)) continue;
                    this.packages.add(im);
                    this.line(new String[]{"import", " ", im, ".*", ";"});
                }
            }
            if (javaUnit.getClasses() != null && javaUnit.getClasses().size() > 0) {
                for (String im : javaUnit.getClasses()) {
                    if (this.classes.contains(im)) continue;
                    this.classes.add(im);
                    this.line(new String[]{"import", " ", im, ";"});
                }
            }
            if (javaUnit.getStatics() != null && javaUnit.getStatics().size() > 0) {
                for (String im : javaUnit.getStatics()) {
                    if (this.statics.contains(im)) continue;
                    this.statics.add(im);
                    this.line(new String[]{Constants.IMPORT_STATIC, im, ".*", ";"});
                }
            }
        }
    }

    public void mergeBody() throws IOException {
        if (this.mergeCode != null && StringUtils.isNotEmpty((CharSequence)this.mergeCode.getCode())) {
            this.line(new String[]{this.mergeCode.getCode()});
        }
    }

    public void mergeAnnotation() throws IOException {
        AnnotationBeans ans;
        if (this.mergeCode != null && this.mergeCode.getCodeUnit() != null && (ans = this.mergeCode.getCodeUnit().getAnnotationBeans()) != null && ans.size() > 0) {
            for (AnnotationBean anntation : ans) {
                if (this.annotations.matchPref(anntation) == null) continue;
                this.annotation(anntation);
            }
        }
        this.mergeAnnotation = false;
    }

    public JavaWriter annotation(Class<? extends Annotation> type, Pair<?> ... pairs) throws IOException {
        AnnotationBean annotationBean = AnnotationUtils.createAnnotationBean(type, this::getType, pairs);
        this.annotation(annotationBean);
        return this;
    }

    public JavaWriter annotation(AnnotationBean anntationBean) throws IOException {
        if (this.mergeAnnotation) {
            this.annotations.add(anntationBean);
        }
        this.annotations.add(anntationBean);
        boolean append = true;
        if (append) {
            this.indent();
            this.append("@");
            this.append(anntationBean.getTypeName());
            List<Pair<?>> pairs = anntationBean.getPairs();
            if (pairs != null && pairs.size() > 0) {
                if (pairs.size() == 1 && pairs.get(0).getName() == null) {
                    this.append("(");
                    this.annotationConstant(pairs.get(0).getValue());
                    this.append(")");
                } else {
                    boolean first = true;
                    for (Pair<?> pair : pairs) {
                        if (!first) {
                            this.append(", ");
                        } else {
                            this.append("(");
                        }
                        first = false;
                        ((JavaWriter)this.append(pair.getName())).append("=");
                        this.annotationConstant(pair.getValue());
                    }
                    if (!first) {
                        this.append(")");
                    }
                }
            }
            this.nl();
        }
        return this;
    }

    private void annotationConstant(Object value) throws IOException {
        if (value.getClass().isArray()) {
            this.append("{");
            boolean first = true;
            for (Object o : (Object[])value) {
                if (!first) {
                    this.append(", ");
                }
                this.annotationConstant(o);
                first = false;
            }
            this.append("}");
        } else if (value instanceof AnnotationBean) {
            AnnotationBean bean = (AnnotationBean)value;
            this.annotation(bean);
        } else {
            AnnotationValue annotationValue = (AnnotationValue)value;
            this.append(annotationValue.getSimpleValue());
        }
    }

    @Override
    public JavaWriter annotation(Annotation annotation) throws IOException {
        return this.annotation(AnnotationUtils.createAnnotationBean(annotation, this::getType));
    }

    @Override
    public JavaWriter annotation(Class<? extends Annotation> annotationType) throws IOException {
        return this.annotation(AnnotationUtils.createAnnotationBean(annotationType, this::getType, new Pair[0]));
    }

    private String getType(Class<?> type) {
        String name = this.classes.contains(type.getName()) || this.packages.contains(type.getPackage().getName()) ? type.getSimpleName() : type.getName();
        return name;
    }

    @Override
    public JavaWriter beginClass(Modifier.Class modifier, Type type) throws IOException {
        return this.beginClass(modifier, type, null, new Type[0]);
    }

    public JavaWriter beginClass(Type type) throws IOException {
        return this.beginClass(Modifier.Class.PUBLIC, type, null, new Type[0]);
    }

    @Override
    public JavaWriter beginClass(Modifier.Class modifier, Type type, Type superClass, Type ... interfaces) throws IOException {
        return this.createClass(modifier, type, superClass, interfaces);
    }

    public JavaWriter beginClass(Type type, Type superClass, Type ... interfaces) throws IOException {
        return this.createClass(Modifier.Class.PUBLIC, type, superClass, interfaces);
    }

    private JavaWriter createClass(Modifier.Class modifier, Type type, Type superClass, Type ... interfaces) throws IOException {
        this.packages.add(type.getPackageName());
        this.beginLine(new String[]{modifier.name, type.getGenericName(false, this.packages, this.classes)});
        if (superClass != null) {
            ((JavaWriter)((JavaWriter)((JavaWriter)this.append(" ")).append("extends")).append(" ")).append(superClass.getGenericName(false, this.packages, this.classes));
        }
        if (interfaces != null && interfaces.length > 0) {
            this.append(" ");
            this.append("implements");
            this.append(" ");
            for (int i = 0; i < interfaces.length; ++i) {
                if (i > 0) {
                    this.append(", ");
                }
                this.append(interfaces[i].getGenericName(false, this.packages, this.classes));
            }
        }
        ((JavaWriter)((JavaWriter)this.append("{")).nl()).nl();
        this.in();
        this.types.push(type);
        return this;
    }

    @Override
    public JavaWriter beginInterface(Modifier.Class modifier, Type type, Type ... interfaces) throws IOException {
        this.packages.add(type.getPackageName());
        this.beginLine(new String[]{modifier.name, type.getGenericName(false, this.packages, this.classes)});
        if (interfaces.length > 0) {
            this.append(" ");
            this.append("extends");
            this.append(" ");
            for (int i = 0; i < interfaces.length; ++i) {
                if (i > 0) {
                    this.append(", ");
                }
                this.append(interfaces[i].getGenericName(false, this.packages, this.classes));
            }
        }
        ((JavaWriter)((JavaWriter)this.append("{")).nl()).nl();
        this.in();
        this.types.push(type);
        return this;
    }

    public JavaWriter beginInterface(Type type, Type ... interfaces) throws IOException {
        return this.beginInterface(Modifier.Class.PUBLIC_INTERFACE, type, interfaces);
    }

    @Override
    public <T> JavaWriter beginConstructor(Modifier.Field modifier, Collection<T> parameters, Function<T, Parameter> transformer) throws IOException {
        this.types.push(this.types.peek());
        ((JavaWriter)((JavaWriter)this.beginLine(new String[]{modifier.name, this.types.peek().getSimpleName()})).params(parameters, transformer).append("{")).nl();
        return (JavaWriter)this.in();
    }

    public <T> JavaWriter beginConstructor(Collection<T> parameters, Function<T, Parameter> transformer) throws IOException {
        return this.beginConstructor(Modifier.Field.PUBLIC, (Collection)parameters, (Function)transformer);
    }

    @Override
    public JavaWriter beginConstructor(Modifier.Field modifier, Parameter ... parameters) throws IOException {
        this.types.push(this.types.peek());
        ((JavaWriter)((JavaWriter)this.beginLine(new String[]{modifier.name, this.types.peek().getSimpleName()})).params(parameters).append("{")).nl();
        return (JavaWriter)this.in();
    }

    public JavaWriter beginConstructor(Parameter ... parameters) throws IOException {
        return this.beginConstructor(Modifier.Field.PUBLIC, parameters);
    }

    @Override
    public JavaWriter beginMethod(Modifier.Field modifier, Type returnType, String methodName, Type[] exceptions, Parameter ... args) throws IOException {
        this.types.push(this.types.peek());
        ((JavaWriter)this.beginLine(new String[]{modifier.name, returnType.getGenericName(true, this.packages, this.classes), " ", methodName})).params(args);
        if (exceptions != null && exceptions.length > 0) {
            ((JavaWriter)this.append(" ")).append("throws");
            for (int i = 0; i < exceptions.length; ++i) {
                if (i > 0) {
                    this.append(", ");
                }
                this.append(exceptions[i].getSimpleName());
            }
        }
        if (modifier != Modifier.Field.PROTECTED_ABSTRACT && modifier != Modifier.Field.PUBLIC_ABSTRACT) {
            ((JavaWriter)this.append("{")).nl();
            return (JavaWriter)this.in();
        }
        return (JavaWriter)((JavaWriter)((JavaWriter)this.append(";")).nl()).nl();
    }

    @Override
    public JavaWriter beginMethod(MethodElement methodElement) throws IOException {
        return this.beginMethod(methodElement.getModifier(), methodElement.getReturnType(), methodElement.getName(), methodElement.getExceptions(), methodElement.getArgs());
    }

    public JavaWriter beginMethod(Modifier.Field modifier, Type returnType, String methodName, Parameter ... args) throws IOException {
        return this.beginMethod(MethodElement.builder(modifier, returnType, methodName, args));
    }

    public JavaWriter beginMethod(Type returnType, String methodName, Parameter ... args) throws IOException {
        return this.beginMethod(MethodElement.builder(returnType, methodName, args));
    }

    @Override
    public <T> JavaWriter beginMethod(Modifier.Field field, Type returnType, String methodName, Collection<T> parameters, Function<T, Parameter> transformer) throws IOException {
        return this.beginMethod(MethodElement.builder(field, returnType, methodName, this.transform(parameters, transformer)));
    }

    public <T> JavaWriter beginMethod(Type returnType, String methodName, Collection<T> parameters, Function<T, Parameter> transformer) throws IOException {
        return this.beginMethod(Modifier.Field.PUBLIC, returnType, methodName, parameters, transformer);
    }

    @Override
    public JavaWriter end() throws IOException {
        this.types.pop();
        this.out();
        return (JavaWriter)((JavaWriter)this.line(new String[]{"}"})).nl();
    }

    @Override
    public JavaWriter field(Type type, String name) throws IOException {
        return (JavaWriter)((JavaWriter)this.line(new String[]{type.getGenericName(true, this.packages, this.classes), " ", name, ";"})).nl();
    }

    @Override
    public JavaWriter field(Type type, String name, String value) throws IOException {
        return (JavaWriter)((JavaWriter)this.line(new String[]{type.getGenericName(true, this.packages, this.classes), " ", name, "=", value, ";"})).nl();
    }

    @Override
    public JavaWriter field(Modifier.Field modifier, Type type, String name) throws IOException {
        return (JavaWriter)((JavaWriter)this.line(new String[]{modifier.name, type.getGenericName(true, this.packages, this.classes), " ", name, ";"})).nl();
    }

    @Override
    public JavaWriter field(Modifier.Field modifier, Type type, String name, String value) throws IOException {
        return (JavaWriter)((JavaWriter)this.line(new String[]{modifier.name, type.getGenericName(true, this.packages, this.classes), " ", name, "=", value, ";"})).nl();
    }

    @Override
    public JavaWriter field(FieldElement fieldElement) throws IOException {
        return this.field(fieldElement.getModifier(), fieldElement.getType(), fieldElement.getName(), fieldElement.getValue());
    }

    @Override
    public String getClassConstant(String className) {
        return className + ".class";
    }

    @Override
    public String getGenericName(boolean asArgType, Type type) {
        return type.getGenericName(asArgType, this.packages, this.classes);
    }

    @Override
    public String getRawName(Type type) {
        return type.getRawName(this.packages, this.classes);
    }

    @Override
    public JavaWriter imports(Class<?> ... imports) throws IOException {
        for (Class<?> cl : imports) {
            this.classes.add(cl.getName());
            this.line(new String[]{"import", " ", cl.getName(), ";"});
        }
        this.nl();
        return this;
    }

    @Override
    public JavaWriter imports(Package ... imports) throws IOException {
        for (Package p : imports) {
            this.packages.add(p.getName());
            this.line(new String[]{"import", " ", p.getName(), ".*", ";"});
        }
        this.nl();
        return this;
    }

    @Override
    public JavaWriter importClasses(String ... imports) throws IOException {
        for (String cl : imports) {
            this.classes.add(cl);
            this.line(new String[]{"import", " ", cl, ";"});
        }
        this.nl();
        return this;
    }

    @Override
    public JavaWriter importPackages(String ... imports) throws IOException {
        for (String p : imports) {
            this.packages.add(p);
            this.line(new String[]{"import", " ", p, ".*", ";"});
        }
        this.nl();
        return this;
    }

    @Override
    public JavaWriter staticimports(Class<?> ... imports) throws IOException {
        for (Class<?> cl : imports) {
            this.statics.add(cl.getName());
            this.line(new String[]{Constants.IMPORT_STATIC, cl.getName(), ".*", ";"});
        }
        return this;
    }

    public JavaWriter staticimports(Type ... types) throws IOException {
        for (Type type : types) {
            this.statics.add(type.getFullName());
            this.line(new String[]{Constants.IMPORT_STATIC, type.getFullName(), ".*", ";"});
        }
        return this;
    }

    @Override
    public JavaWriter javadoc(String ... lines) throws IOException {
        this.line(new String[]{"/**"});
        for (String line : lines) {
            this.line(new String[]{" * ", line});
        }
        return (JavaWriter)this.line(new String[]{" */"});
    }

    @Override
    public JavaWriter packageDecl(String packageName) throws IOException {
        this.packages.add(packageName);
        return (JavaWriter)((JavaWriter)this.line(new String[]{"package", " ", packageName, ";"})).nl();
    }

    private <T> JavaWriter params(Collection<T> parameters, Function<T, Parameter> transformer) throws IOException {
        this.append("(");
        boolean first = true;
        for (T param : parameters) {
            if (!first) {
                this.append(", ");
            }
            this.param((Parameter)transformer.apply(param));
            first = false;
        }
        this.append(")");
        return this;
    }

    private JavaWriter params(Parameter ... params) throws IOException {
        this.append("(");
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    this.append(", ");
                }
                this.param(params[i]);
            }
        }
        this.append(")");
        return this;
    }

    private JavaWriter param(Parameter parameter) throws IOException {
        this.append(parameter.getType().getGenericName(true, this.packages, this.classes));
        this.append(" ");
        this.append(parameter.getName());
        return this;
    }

    @Override
    public JavaWriter suppressWarnings(String type) throws IOException {
        return (JavaWriter)this.line(new String[]{"@SuppressWarnings(\"", type, "\")"});
    }

    @Override
    public JavaWriter suppressWarnings(String ... types) throws IOException {
        return (JavaWriter)this.line(new String[]{"@SuppressWarnings(\"", Joiner.on((String)",").join((Object[])types), ",\")"});
    }

    private <T> Parameter[] transform(Collection<T> parameters, Function<T, Parameter> transformer) {
        Parameter[] rv = new Parameter[parameters.size()];
        int i = 0;
        for (T value : parameters) {
            rv[i++] = (Parameter)transformer.apply(value);
        }
        return rv;
    }

    public JavaWriter addStatement(String format, Object ... args) throws IOException {
        this.line(new String[]{Strings.lenientFormat((String)format, (Object[])args)});
        return (JavaWriter)this.nl();
    }

    public JavaWriter returns(String name, boolean thisPrefix) throws IOException {
        if (thisPrefix) {
            return (JavaWriter)this.line(new String[]{"return ", "this", ".", name, ";"});
        }
        return (JavaWriter)this.line(new String[]{"return ", name, ";"});
    }

    public JavaWriter returns(String name) throws IOException {
        return this.returns(name, false);
    }

    public JavaWriter returns() throws IOException {
        return this.returns("this");
    }

    public JavaWriter returnsNull() throws IOException {
        return this.returns("null");
    }

    public JavaWriter assign(String name) throws IOException {
        return this.assign(name, name);
    }

    public JavaWriter assign(String key, String name) throws IOException {
        return (JavaWriter)this.line(new String[]{"this", ".", key, "=", name, ";"});
    }

    public JavaWriter set(Type type, String name) throws IOException {
        return this.set(type, name, StringUtils.capitalize((String)name));
    }

    public JavaWriter set(Type type, String name, String methodName) throws IOException {
        this.beginMethod(MethodElement.builder(Modifier.Field.PUBLIC, (Type)Types.VOID, "set" + methodName, new Parameter(name, type)));
        this.line(new String[]{"this", ".", name, "=", name, ";"});
        this.end();
        return this;
    }

    public JavaWriter get(Type type, String name) throws IOException {
        return this.get(type, name, StringUtils.capitalize((String)name));
    }

    public JavaWriter get(Type type, String name, String methodName) throws IOException {
        this.beginMethod(MethodElement.builder(Modifier.Field.PUBLIC, type, "get" + methodName, new Parameter[0]));
        this.returns(name, true);
        this.end();
        return this;
    }

    public JavaWriter ifExp(String express, String action) throws IOException {
        return this.ifelse(express, action, "if");
    }

    public JavaWriter elseExp(String action) throws IOException {
        return (JavaWriter)this.ifelse(null, action, "else").nl();
    }

    public JavaWriter elseIfExp(String express, String action) throws IOException {
        return this.ifelse(express, action, "else if");
    }

    public JavaWriter ifelse(String express, String action, String token) throws IOException {
        if (express != null) {
            this.indent();
        }
        this.append(token);
        if (express != null) {
            ((JavaWriter)((JavaWriter)this.append("(")).append(express)).append(")");
        }
        ((JavaWriter)this.append("{")).nl();
        this.in();
        this.indent();
        ((JavaWriter)((JavaWriter)this.append(action)).append(";")).nl();
        this.out();
        this.indent();
        this.append("}");
        return this;
    }

    public JavaWriter superInvoke(String name, Parameter ... args) throws IOException {
        return (JavaWriter)this.line(new String[]{"super", ".", name, this.packMethod(args), ";"});
    }

    public JavaWriter superInvokeReturn(String name, Parameter ... args) throws IOException {
        return (JavaWriter)this.line(new String[]{"return ", "super", ".", name, this.packMethod(args), ";"});
    }

    public String packMethod(Parameter ... args) {
        String packMethod = "()";
        if (args != null && args.length > 0) {
            StringBuilder builder = new StringBuilder();
            builder.append("(");
            int length = args.length;
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                Parameter p = args[i];
                builder.append(p.getName());
            }
            builder.append(")");
            packMethod = builder.toString();
        }
        return packMethod;
    }

    public void setClasses(Set<String> classes) {
        this.classes = classes;
    }

    public void setPackages(Set<String> packages) {
        this.packages = packages;
    }

    public void setStatics(Set<String> statics) {
        this.statics = statics;
    }

    public void setTypes(Stack<Type> types) {
        this.types = types;
    }
}

