/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.wsilk.codegen.annoataion;

import com.google.common.collect.Lists;
import com.wuba.wsilk.codegen.Pair;
import com.wuba.wsilk.codegen.annoataion.AnnotationBean;
import com.wuba.wsilk.codegen.annoataion.AnnotationValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public class AnnotationUtils {
    public static AnnotationBean createAnnotationBean(Annotation annotation, Function<Class<?>, String> getType) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        Method[] methods = annotationType.getDeclaredMethods();
        ArrayList pairs = Lists.newArrayList();
        for (Method method : methods) {
            try {
                Object value = method.invoke((Object)annotation, new Object[0]);
                Pair<?> valuePair = Pair.createPair(method.getName(), AnnotationUtils.annotationConstant(value, getType));
                pairs.add(valuePair);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return AnnotationUtils.createAnnotationBean(annotationType, getType, pairs);
    }

    private static Object annotationConstant(Object value, Function<Class<?>, String> getType) {
        Object pairValue = null;
        if (value instanceof Annotation) {
            pairValue = AnnotationUtils.createAnnotationBean((Annotation)value, getType);
        } else {
            Class<?> valueClass = value.getClass();
            if (valueClass.isArray()) {
                Object[] array = (Object[])value;
                for (int i = 0; i < array.length; ++i) {
                    array[i] = AnnotationUtils.annotationConstant(array[i], getType);
                }
                pairValue = new AnnotationValue(array);
            } else {
                pairValue = new AnnotationValue(value);
            }
        }
        return pairValue;
    }

    public static AnnotationBean createAnnotationBean(Class<? extends Annotation> type, Function<Class<?>, String> getType, Pair<?> ... value) {
        return AnnotationUtils.createAnnotationBean(type, getType, Arrays.asList(value));
    }

    private static AnnotationBean createAnnotationBean(Class<? extends Annotation> type, Function<Class<?>, String> getType, List<Pair<?>> pairs) {
        AnnotationBean annotationBean = AnnotationUtils.createAnnotationBean(getType.apply(type));
        annotationBean.setPairs(pairs);
        return annotationBean;
    }

    private static AnnotationBean createAnnotationBean(String type) {
        return new AnnotationBean(type);
    }
}

