/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.wsilk.codegen.annoataion;

import java.lang.annotation.Annotation;
import org.apache.commons.text.StringEscapeUtils;

public class AnnotationValue {
    private Object value;
    private ValueType type;

    public AnnotationValue(Object value) {
        if (value instanceof String) {
            this.type = ValueType.STRING;
            String escaped = StringEscapeUtils.escapeJava((String)String.valueOf(value));
            this.value = "\"" + escaped.replace("\\/", "/") + "\"";
        } else if (value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof Float) {
            this.type = ValueType.SIMPLE;
            this.value = String.valueOf(value);
        } else if (value instanceof Character) {
            this.type = ValueType.CHARACTER;
            this.value = '\'' + String.valueOf(value) + '\'';
        } else if (value instanceof Class) {
            this.type = ValueType.CLASS;
            this.value = String.valueOf(value);
        } else if (value instanceof Enum) {
            this.type = ValueType.EUNM_OR_ANNOTATION;
            Enum enumValue = (Enum)value;
            this.value = enumValue.name();
        } else if (value instanceof Annotation) {
            this.type = ValueType.EUNM_OR_ANNOTATION;
            this.value = String.valueOf(value);
        }
    }

    public AnnotationValue(Object value, ValueType type) {
        this.value = value;
        this.type = type;
    }

    public boolean isArray() {
        return this.type == ValueType.ARRAY;
    }

    public boolean isClass() {
        return this.type == ValueType.CLASS;
    }

    public boolean isType() {
        return this.type == ValueType.EUNM_OR_ANNOTATION;
    }

    public boolean isSimple() {
        return this.type == ValueType.SIMPLE;
    }

    public boolean isChar() {
        return this.type == ValueType.CHARACTER;
    }

    public boolean isString() {
        return this.type == ValueType.STRING;
    }

    public String getSimpleValue() {
        String v = String.valueOf(this.value);
        if (this.type == ValueType.CLASS) {
            v = v + ".class";
        }
        return v;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnnotationValue)) {
            return false;
        }
        AnnotationValue other = (AnnotationValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        ValueType this$type = this.type;
        ValueType other$type = other.type;
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnnotationValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        ValueType $type = this.type;
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public Object getValue() {
        return this.value;
    }

    public static enum ValueType {
        STRING,
        CHARACTER,
        CLASS,
        EUNM_OR_ANNOTATION,
        ARRAY,
        SIMPLE;

    }
}

