/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.wsilk.codegen.parser;

import com.google.common.collect.Lists;
import com.wuba.wsilk.codegen.annoataion.AnnotationBean;
import com.wuba.wsilk.codegen.annoataion.AnnotationBeans;
import com.wuba.wsilk.codegen.parser.ImportLine;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class JavaUnit {
    private List<String> classes = Lists.newArrayList();
    private List<String> packages = Lists.newArrayList();
    private List<String> statics = Lists.newArrayList();
    private AnnotationBeans annotationBeans;

    void addImport(String imp) {
        if (StringUtils.isNotEmpty((CharSequence)imp)) {
            if (imp.startsWith("static")) {
                this.statics.add(imp.substring(7, imp.length() - 2));
            } else if (imp.endsWith(".*")) {
                this.packages.add(imp.substring(0, imp.length() - 2));
            } else {
                this.classes.add(imp);
            }
        }
    }

    public void setImports(List<ImportLine> importLines) {
        for (ImportLine importLine : importLines) {
            this.addImport(importLine.toImport());
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String c : this.classes) {
            builder.append(c).append("\n");
        }
        for (String c : this.packages) {
            builder.append(c).append("\n");
        }
        for (String c : this.statics) {
            builder.append(c).append("\n");
        }
        for (AnnotationBean annotationBean : this.annotationBeans) {
            builder.append(annotationBean.toString()).append("\n");
        }
        return builder.toString();
    }

    public List<String> getClasses() {
        return this.classes;
    }

    public List<String> getPackages() {
        return this.packages;
    }

    public List<String> getStatics() {
        return this.statics;
    }

    public AnnotationBeans getAnnotationBeans() {
        return this.annotationBeans;
    }

    public void setClasses(List<String> classes) {
        this.classes = classes;
    }

    public void setPackages(List<String> packages) {
        this.packages = packages;
    }

    public void setStatics(List<String> statics) {
        this.statics = statics;
    }

    public void setAnnotationBeans(AnnotationBeans annotationBeans) {
        this.annotationBeans = annotationBeans;
    }
}

