/*
 * Decompiled with CFR 0.152.
 */
package io.github.zero88.repl;

import io.github.zero88.exceptions.ReflectionException;
import io.github.zero88.repl.ReflectionClass;
import io.github.zero88.repl.ReflectionMember;
import io.github.zero88.repl.Reflections;
import io.github.zero88.utils.Functions;
import io.github.zero88.utils.Strings;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class ReflectionField
implements ReflectionMember {
    private ReflectionField() {
    }

    public static Stream<Field> stream(@NotNull Class<?> clazz, Predicate<Field> predicate) {
        return Reflections.loadScanner().fieldStream(clazz, predicate);
    }

    public static List<Field> find(@NotNull Class<?> clazz, Predicate<Field> predicate) {
        return ReflectionField.stream(clazz, predicate).collect(Collectors.toList());
    }

    public static <T> T constantByName(@NotNull Class<?> clazz, String name) {
        Predicate<Field> filter = Functions.and(ReflectionMember.constantPredicate(), f -> f.getName().equals(Strings.requireNotBlank(name)));
        return ReflectionField.stream(clazz, filter).map(field -> ReflectionField.getConstant(clazz, field)).findFirst().orElse(null);
    }

    public static <T> List<T> getConstants(@NotNull Class<?> clazz, @NotNull Class<T> fieldClass) {
        return ReflectionField.streamConstants(clazz, fieldClass).collect(Collectors.toList());
    }

    public static <T> List<T> getConstants(@NotNull Class<?> clazz, @NotNull Class<T> fieldClass, Predicate<Field> predicate) {
        return ReflectionField.streamConstants(clazz, fieldClass, predicate).collect(Collectors.toList());
    }

    public static <T> Stream<T> streamConstants(@NotNull Class<T> clazz) {
        return ReflectionField.streamConstants(clazz, clazz, null);
    }

    public static <T> Stream<T> streamConstants(@NotNull Class<?> clazz, @NotNull Class<T> fieldClass) {
        return ReflectionField.streamConstants(clazz, fieldClass, null);
    }

    public static <T> Stream<T> streamConstants(@NotNull Class<?> clazz, @NotNull Class<T> fieldClass, Predicate<Field> predicate) {
        Predicate<Field> filter = Functions.and(ReflectionMember.constantPredicate(), f -> ReflectionClass.assertDataType(fieldClass, f.getType()));
        if (Objects.nonNull(predicate)) {
            filter = filter.and(predicate);
        }
        return ReflectionField.stream(clazz, filter).map(field -> ReflectionField.getConstant(clazz, field));
    }

    public static <T> T getConstant(@NotNull Class<?> clazz, Field field) {
        try {
            return (T)field.get(null);
        }
        catch (ClassCastException | IllegalAccessException e) {
            throw new ReflectionException(Strings.format("Failed to get field constant {0} of {1}", field.getName(), clazz.getName()), (Throwable)e);
        }
    }

    public static <T> T getConstant(@NotNull Class<?> clazz, Field field, T fallback) {
        try {
            return (T)field.get(null);
        }
        catch (ClassCastException | IllegalAccessException e) {
            if (Reflections.LOGGER.isTraceEnabled()) {
                Reflections.LOGGER.trace("Failed to get field constant {} of {}", new Object[]{field.getName(), clazz.getName(), e});
            }
            return fallback;
        }
    }

    public static <T> List<T> getFieldValuesByType(@NotNull Object obj, @NotNull Class<T> searchType) {
        Predicate<Field> predicate = Functions.and(ReflectionMember.notModifiers(8), f -> ReflectionClass.assertDataType(f.getType(), searchType));
        return ReflectionField.stream(obj.getClass(), predicate).map(f -> ReflectionField.getFieldValue(obj, f, searchType)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T> T getFieldValue(@NotNull Object obj, @NotNull Field f, @NotNull Class<T> type) {
        try {
            f.setAccessible(true);
            return type.cast(f.get(obj));
        }
        catch (ClassCastException | IllegalAccessException e) {
            Reflections.LOGGER.trace("Cannot get data of field " + f.getName(), (Throwable)e);
            return null;
        }
    }
}

