/*
 * Decompiled with CFR 0.152.
 */
package io.codigo.dtos;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.codigo.dtos.AutoValue_SplitChange;
import io.codigo.dtos.Split;
import java.util.Collections;
import java.util.List;

@JsonDeserialize(builder=AutoValue_SplitChange.Builder.class)
public abstract class SplitChange {
    public static Builder builder() {
        return new AutoValue_SplitChange.Builder().splits(Collections.emptyList());
    }

    public static SplitChange noChanges(long since) {
        return new AutoValue_SplitChange.Builder().splits(Collections.emptyList()).since(since).till(since).build();
    }

    SplitChange() {
    }

    @JsonProperty
    public abstract ImmutableList<Split> splits();

    @JsonProperty
    public abstract long since();

    @JsonProperty
    public abstract long till();

    @JsonPOJOBuilder(withPrefix="")
    public static abstract class Builder {
        public abstract Builder splits(List<Split> var1);

        public abstract Builder since(long var1);

        public abstract Builder till(long var1);

        abstract SplitChange autobuild();

        public final SplitChange build() {
            SplitChange result = this.autobuild();
            if (result.since() >= 0L) {
                Preconditions.checkArgument(result.till() >= result.since(), "ExperimentChange.till() MUST BE greater than or equal to ExperimentChange.since()");
            }
            if (result.till() == result.since() && result.till() >= 0L) {
                Preconditions.checkArgument(result.splits().isEmpty(), "When ExperimentChange.till() == ExperimentChange.since(), then ExperimentChange.splits()MUST be empty. They were not: " + result);
            }
            if (result.till() < 0L) {
                Preconditions.checkArgument(result.splits().isEmpty(), "When ExperimentChange.till() is less than zero, then ExperimentChange should be empty. It was not: " + result);
            }
            return result;
        }
    }
}

