/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.experiments;

import com.google.common.collect.ImmutableList;
import io.split.engine.experiments.ParsedCondition;
import java.util.List;

public class ParsedSplit {
    private final String _type;
    private final String _feature;
    private final int _seed;
    private final ImmutableList<ParsedCondition> _matcherAndSplits;

    public ParsedSplit(String type, String feature, int seed, List<ParsedCondition> matcherAndSplits) {
        this._type = type;
        this._feature = feature;
        this._seed = seed;
        this._matcherAndSplits = ImmutableList.copyOf(matcherAndSplits);
    }

    public String type() {
        return this._type;
    }

    public String feature() {
        return this._feature;
    }

    public int seed() {
        return this._seed;
    }

    public List<ParsedCondition> matcherAndSplits() {
        return this._matcherAndSplits;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._type.hashCode();
        result = 31 * result + this._feature.hashCode();
        result = 31 * result + Long.hashCode(this._seed);
        result = 31 * result + this._matcherAndSplits.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ParsedSplit)) {
            return false;
        }
        ParsedSplit other = (ParsedSplit)obj;
        return this._type.equals(other._type) && this._feature.equals(other._feature) && this._seed == other._seed && this._matcherAndSplits.equals(other._matcherAndSplits);
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("type: ");
        bldr.append(this._type);
        bldr.append(", name:");
        bldr.append(this._feature);
        bldr.append(", seed:");
        bldr.append(this._seed);
        bldr.append(", matcherAndSplits:");
        bldr.append(this._matcherAndSplits);
        return bldr.toString();
    }
}

