/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.matchers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.codigo.dtos.MatcherCombiner;
import io.split.engine.matchers.Matcher;
import java.util.List;

public class CombiningMatcher
implements Matcher {
    private final ImmutableList<Matcher> _delegates;
    private final MatcherCombiner _combiner;

    public CombiningMatcher(MatcherCombiner combiner, List<Matcher> delegates) {
        this._delegates = ImmutableList.copyOf(delegates);
        this._combiner = combiner;
        Preconditions.checkArgument(this._delegates.size() > 1);
    }

    @Override
    public boolean match(String key) {
        if (this._delegates.isEmpty()) {
            return false;
        }
        switch (this._combiner) {
            case AND: {
                return this.and(key);
            }
        }
        throw new IllegalArgumentException("Unknown combiner: " + (Object)((Object)this._combiner));
    }

    private boolean and(String key) {
        boolean result = true;
        for (Matcher delegate : this._delegates) {
            result &= delegate.match(key);
        }
        return result;
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        boolean first = true;
        for (Matcher matcher : this._delegates) {
            if (!first) {
                bldr.append(" " + (Object)((Object)this._combiner));
            }
            bldr.append(matcher);
            first = false;
        }
        return bldr.toString();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._combiner.hashCode();
        result = 31 * result + this._delegates.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CombiningMatcher)) {
            return false;
        }
        CombiningMatcher other = (CombiningMatcher)obj;
        return this._combiner.equals((Object)other._combiner) && this._delegates.equals(other._delegates);
    }
}

