/*
 * Decompiled with CFR 0.152.
 */
package io.codigo.dtos;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Preconditions;
import io.codigo.dtos.AutoValue_Partition;

@JsonDeserialize(builder=AutoValue_Partition.Builder.class)
public abstract class Partition {
    public static Builder builder(Partition p) {
        return new AutoValue_Partition.Builder(p);
    }

    public static Builder builder() {
        return new AutoValue_Partition.Builder();
    }

    Partition() {
    }

    @JsonProperty
    public abstract String treatment();

    @JsonProperty
    public abstract int size();

    public final String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append(this.size());
        bldr.append("%:");
        bldr.append(this.treatment());
        return bldr.toString();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static abstract class Builder {
        public abstract Builder treatment(String var1);

        public abstract Builder size(int var1);

        abstract Partition autobuild();

        public final Partition build() {
            Partition result = this.autobuild();
            Preconditions.checkArgument(result.size() <= 100, "Partition.size() MUST BE less than 100: " + result.size());
            Preconditions.checkArgument(result.size() >= 0, "Partition.size() MUST BE >= 0: " + result.size());
            return result;
        }
    }
}

