/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.experiments;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.codigo.dtos.Split;
import io.codigo.dtos.SplitChange;
import io.codigo.models.Status;
import io.split.engine.experiments.ParsedSplit;
import io.split.engine.experiments.SplitChangeFetcher;
import io.split.engine.experiments.SplitFetcher;
import io.split.engine.experiments.SplitParser;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshableSplitFetcher
implements SplitFetcher,
Runnable {
    private static final Logger _log = LoggerFactory.getLogger(RefreshableSplitFetcher.class);
    private final SplitParser _parser;
    private final SplitChangeFetcher _splitChangeFetcher;
    private final AtomicLong _changeNumber;
    private Map<String, ParsedSplit> _concurrentMap = Maps.newConcurrentMap();
    private final Object _lock = new Object();

    public RefreshableSplitFetcher(SplitChangeFetcher splitChangeFetcher, SplitParser parser) {
        this(splitChangeFetcher, parser, -1L);
    }

    RefreshableSplitFetcher(SplitChangeFetcher splitChangeFetcher, SplitParser parser, long startingChangeNumber) {
        this._splitChangeFetcher = splitChangeFetcher;
        this._parser = parser;
        this._changeNumber = new AtomicLong(startingChangeNumber);
        Preconditions.checkNotNull(this._parser);
        Preconditions.checkNotNull(this._splitChangeFetcher);
    }

    @Override
    public void forceRefresh() {
        this.run();
    }

    public long changeNumber() {
        return this._changeNumber.get();
    }

    @Override
    public ParsedSplit fetch(String test) {
        return this._concurrentMap.get(test);
    }

    @Override
    public List<ParsedSplit> fetchAll() {
        return Lists.newArrayList(this._concurrentMap.values());
    }

    public Collection<ParsedSplit> fetch() {
        return this._concurrentMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long start = this._changeNumber.get();
        try {
            this.runWithoutExceptionHandling();
        }
        catch (Throwable t) {
            _log.error("RefreshableExperimentFetcher failed", t);
        }
        finally {
            _log.info("split fetch before: " + start + ", after: " + this._changeNumber.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithoutExceptionHandling() {
        SplitChange change = this._splitChangeFetcher.fetch(this._changeNumber.get());
        if (change.till() == this._changeNumber.get()) {
            return;
        }
        if (change.since() != this._changeNumber.get() || change.till() < this._changeNumber.get()) {
            return;
        }
        if (change.splits().isEmpty()) {
            this._changeNumber.set(change.till());
            return;
        }
        Object object = this._lock;
        synchronized (object) {
            if (change.since() != this._changeNumber.get() || change.till() < this._changeNumber.get()) {
                return;
            }
            HashSet<String> toRemove = Sets.newHashSet();
            HashMap<String, ParsedSplit> toAdd = Maps.newHashMap();
            for (Split split : change.splits()) {
                if (split.status() != Status.ACTIVE) {
                    toRemove.add(split.name());
                    continue;
                }
                ParsedSplit parsedSplit = this._parser.parse(split);
                if (parsedSplit == null) {
                    _log.info("We could not parse the experiment definition for: " + split.name() + " so we are removing it completely to be careful");
                    toRemove.add(split.name());
                    continue;
                }
                toAdd.put(split.name(), parsedSplit);
            }
            this._concurrentMap.putAll(toAdd);
            for (String remove : toRemove) {
                this._concurrentMap.remove(remove);
            }
            if (!toAdd.isEmpty()) {
                _log.info("Updated features: " + toAdd.keySet());
            }
            if (!toRemove.isEmpty()) {
                _log.info("Deleted features: " + toRemove);
            }
            this._changeNumber.set(change.till());
        }
    }
}

