/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.matchers;

import io.split.engine.matchers.Matcher;
import io.split.engine.matchers.Transformers;

public class BetweenMatcher
implements Matcher {
    private final long _start;
    private final long _end;

    public BetweenMatcher(long start, long end) {
        this._start = start;
        this._end = end;
    }

    @Override
    public boolean match(Object key) {
        Long keyAsLong = Transformers.asLong(key);
        if (keyAsLong == null) {
            return false;
        }
        return keyAsLong >= this._start && keyAsLong <= this._end;
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("between ");
        bldr.append(this._start);
        bldr.append(" and ");
        bldr.append(this._end);
        return bldr.toString();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Long.hashCode(this._start);
        result = 31 * result + Long.hashCode(this._end);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BetweenMatcher)) {
            return false;
        }
        BetweenMatcher other = (BetweenMatcher)obj;
        return this._start == other._start && this._end == other._end;
    }
}

