/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.split.client.SplitClient;
import io.split.client.api.Key;
import java.util.Map;

public final class LocalhostSplitClient
implements SplitClient {
    private final ImmutableMap<String, String> _featureToTreatmentMap;

    public LocalhostSplitClient(Map<String, String> featureToTreatmentMap) {
        Preconditions.checkNotNull(featureToTreatmentMap, (Object)"featureToTreatmentMap must not be null");
        this._featureToTreatmentMap = ImmutableMap.copyOf(featureToTreatmentMap);
    }

    @Override
    public String getTreatment(String key, String feature) {
        if (key == null || feature == null) {
            return "control";
        }
        String treatment = (String)this._featureToTreatmentMap.get((Object)feature);
        if (treatment == null) {
            return "control";
        }
        return treatment;
    }

    @Override
    public String getTreatment(String key, String feature, Map<String, Object> attributes) {
        return this.getTreatment(key, feature);
    }

    @Override
    public String getTreatment(Key key, String feature, Map<String, Object> attributes) {
        return this.getTreatment(key.matchingKey(), feature, attributes);
    }

    public ImmutableMap<String, String> featureToTreatmentMap() {
        return this._featureToTreatmentMap;
    }
}

