/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import com.google.common.base.Preconditions;
import io.split.client.SplitClient;
import io.split.client.api.Key;
import io.split.engine.experiments.ParsedCondition;
import io.split.engine.experiments.ParsedSplit;
import io.split.engine.experiments.SplitFetcher;
import io.split.engine.impressions.TreatmentLog;
import io.split.engine.metrics.Metrics;
import io.split.engine.splitter.Splitter;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SplitClientImpl
implements SplitClient {
    private static final Logger _log = LoggerFactory.getLogger(SplitClientImpl.class);
    private final SplitFetcher _splitFetcher;
    private final TreatmentLog _treatmentLog;
    private final Metrics _metrics;

    public SplitClientImpl(SplitFetcher splitFetcher, TreatmentLog treatmentLog, Metrics metrics) {
        this._splitFetcher = splitFetcher;
        this._treatmentLog = treatmentLog;
        this._metrics = metrics;
        Preconditions.checkNotNull((Object)this._splitFetcher);
        Preconditions.checkNotNull((Object)this._treatmentLog);
    }

    @Override
    public String getTreatment(String key, String feature) {
        return this.getTreatment(key, feature, Collections.emptyMap());
    }

    @Override
    public String getTreatment(String key, String feature, Map<String, Object> attributes) {
        return this.getTreatment(key, key, feature, attributes);
    }

    @Override
    public String getTreatment(Key key, String feature, Map<String, Object> attributes) {
        if (key == null) {
            _log.warn("key object was null for feature: " + feature);
            return "control";
        }
        return this.getTreatment(key.matchingKey(), key.bucketingKey(), feature, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTreatment(String matchingKey, String bucketingKey, String feature, Map<String, Object> attributes) {
        try {
            if (matchingKey == null) {
                _log.warn("matchingKey was null for feature: " + feature);
                return "control";
            }
            if (bucketingKey == null) {
                _log.warn("bucketingKey was null for feature: " + feature);
                return "control";
            }
            if (feature == null) {
                _log.warn("feature was null for key: " + matchingKey);
                return "control";
            }
            long start = System.currentTimeMillis();
            TreatmentAndLabel result = null;
            try {
                result = this.getTreatmentWithoutExceptionHandling(matchingKey, bucketingKey, feature, attributes);
            }
            catch (Exception e) {
                result = new TreatmentAndLabel("control", "exception");
                _log.error("Exception", (Throwable)e);
            }
            finally {
                this.recordStats(matchingKey, bucketingKey, feature, start, result._treatment, "sdk.getTreatment", result._label);
            }
            return result._treatment;
        }
        catch (Exception e) {
            try {
                _log.error("CatchAll Exception", (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "control";
        }
    }

    private void recordStats(String matchingKey, String bucketingKey, String feature, long start, String result, String operation, String label) {
        try {
            this._treatmentLog.log(matchingKey, bucketingKey, feature, result, System.currentTimeMillis(), label);
            this._metrics.time(operation, System.currentTimeMillis() - start);
        }
        catch (Throwable t) {
            _log.error("Exception", t);
        }
    }

    private TreatmentAndLabel getTreatmentWithoutExceptionHandling(String matchingKey, String bucketingKey, String feature, Map<String, Object> attributes) {
        ParsedSplit parsedSplit = this._splitFetcher.fetch(feature);
        if (parsedSplit == null) {
            if (_log.isDebugEnabled()) {
                _log.debug("Returning control because no split was found for: " + feature);
            }
            return new TreatmentAndLabel("control", "split not found");
        }
        return this.getTreatment(matchingKey, bucketingKey, parsedSplit, attributes);
    }

    private TreatmentAndLabel getTreatment(String matchingKey, String bucketingKey, ParsedSplit parsedSplit, Map<String, Object> attributes) {
        if (parsedSplit.killed()) {
            return new TreatmentAndLabel(parsedSplit.defaultTreatment(), "killed");
        }
        for (ParsedCondition parsedCondition : parsedSplit.parsedConditions()) {
            if (!parsedCondition.matcher().match(matchingKey, attributes)) continue;
            String treatment = Splitter.getTreatment(bucketingKey, parsedSplit.seed(), parsedCondition.partitions());
            return new TreatmentAndLabel(treatment, parsedCondition.label());
        }
        return new TreatmentAndLabel(parsedSplit.defaultTreatment(), "no condition matched");
    }

    private static final class TreatmentAndLabel {
        private final String _treatment;
        private final String _label;

        public TreatmentAndLabel(String treatment, String label) {
            this._treatment = treatment;
            this._label = label;
        }
    }
}

