/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.SplitManager;
import io.split.client.api.SplitView;
import io.split.client.dtos.Partition;
import io.split.engine.experiments.ParsedCondition;
import io.split.engine.experiments.ParsedSplit;
import io.split.engine.experiments.SplitFetcher;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class SplitManagerImpl
implements SplitManager {
    private final SplitFetcher _splitFetcher;

    public SplitManagerImpl(SplitFetcher splitFetcher) {
        this._splitFetcher = splitFetcher;
    }

    @Override
    public List<SplitView> splits() {
        ArrayList<SplitView> result = new ArrayList<SplitView>();
        List<ParsedSplit> parsedSplits = this._splitFetcher.fetchAll();
        for (ParsedSplit split : parsedSplits) {
            result.add(this.toSplitView(split));
        }
        return result;
    }

    @Override
    public SplitView split(String featureName) {
        ParsedSplit parsedSplit = this._splitFetcher.fetch(featureName);
        return parsedSplit == null ? null : this.toSplitView(parsedSplit);
    }

    private SplitView toSplitView(ParsedSplit parsedSplit) {
        SplitView splitView = new SplitView();
        splitView.name = parsedSplit.feature();
        splitView.trafficType = parsedSplit.trafficTypeName();
        splitView.killed = parsedSplit.killed();
        splitView.changeNumber = parsedSplit.changeNumber();
        HashSet<String> treatments = new HashSet<String>();
        for (ParsedCondition condition : parsedSplit.parsedConditions()) {
            for (Partition partition : condition.partitions()) {
                treatments.add(partition.treatment);
            }
        }
        treatments.add(parsedSplit.defaultTreatment());
        splitView.treatments = new ArrayList<String>(treatments);
        return splitView;
    }
}

