/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.experiments;

import com.google.common.collect.ImmutableList;
import io.split.engine.experiments.ParsedCondition;
import java.util.List;

public class ParsedSplit {
    private final String _feature;
    private final int _seed;
    private final boolean _killed;
    private final String _defaultTreatment;
    private final ImmutableList<ParsedCondition> _parsedCondition;
    private final String _trafficTypeName;
    private final long _changeNumber;

    public ParsedSplit(String feature, int seed, boolean killed, String defaultTreatment, List<ParsedCondition> matcherAndSplits, String trafficTypeName, long changeNumber) {
        this._feature = feature;
        this._seed = seed;
        this._killed = killed;
        this._defaultTreatment = defaultTreatment;
        this._parsedCondition = ImmutableList.copyOf(matcherAndSplits);
        this._trafficTypeName = trafficTypeName;
        this._changeNumber = changeNumber;
        if (this._defaultTreatment == null) {
            throw new IllegalArgumentException("DefaultTreatment is null");
        }
    }

    public String feature() {
        return this._feature;
    }

    public int seed() {
        return this._seed;
    }

    public boolean killed() {
        return this._killed;
    }

    public String defaultTreatment() {
        return this._defaultTreatment;
    }

    public List<ParsedCondition> parsedConditions() {
        return this._parsedCondition;
    }

    public String trafficTypeName() {
        return this._trafficTypeName;
    }

    public long changeNumber() {
        return this._changeNumber;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._feature.hashCode();
        result = 31 * result + Long.hashCode(this._seed);
        result = 31 * result + Boolean.hashCode(this._killed);
        result = 31 * result + this._defaultTreatment.hashCode();
        result = 31 * result + this._parsedCondition.hashCode();
        result = 31 * result + (this._trafficTypeName == null ? 0 : this._trafficTypeName.hashCode());
        result = 31 * result + (int)(this._changeNumber ^ this._changeNumber >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ParsedSplit)) {
            return false;
        }
        ParsedSplit other = (ParsedSplit)obj;
        return this._feature.equals(other._feature) && this._seed == other._seed && this._killed == other._killed && this._defaultTreatment.equals(other._defaultTreatment) && this._parsedCondition.equals(other._parsedCondition) && this._trafficTypeName == null ? other._trafficTypeName == null : this._trafficTypeName.equals(other._trafficTypeName) && this._changeNumber == other._changeNumber;
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("name:");
        bldr.append(this._feature);
        bldr.append(", seed:");
        bldr.append(this._seed);
        bldr.append(", killed:");
        bldr.append(this._killed);
        bldr.append(", default treatment:");
        bldr.append(this._defaultTreatment);
        bldr.append(", parsedConditions:");
        bldr.append(this._parsedCondition);
        bldr.append(", trafficTypeName:");
        bldr.append(this._trafficTypeName);
        bldr.append(", changeNumber:");
        bldr.append(this._changeNumber);
        return bldr.toString();
    }
}

