/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.matchers.strings;

import io.split.engine.matchers.Matcher;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class EndsWithAnyOfMatcher
implements Matcher {
    private final Set<String> _compareTo = new HashSet<String>();

    public EndsWithAnyOfMatcher(Collection<String> compareTo) {
        if (compareTo == null) {
            throw new IllegalArgumentException("Null whitelist");
        }
        this._compareTo.addAll(compareTo);
    }

    @Override
    public boolean match(Object key) {
        if (key == null) {
            return false;
        }
        if (!(key instanceof String)) {
            return false;
        }
        if (this._compareTo.isEmpty()) {
            return false;
        }
        String keyAsString = (String)key;
        for (String s : this._compareTo) {
            if (s.isEmpty() || !keyAsString.endsWith(s)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("ends with ");
        bldr.append(this._compareTo);
        return bldr.toString();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._compareTo.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EndsWithAnyOfMatcher)) {
            return false;
        }
        EndsWithAnyOfMatcher other = (EndsWithAnyOfMatcher)obj;
        return this._compareTo.equals(other._compareTo);
    }
}

