/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.impressions.ImpressionListener;
import java.io.IOException;
import java.util.Properties;
import split.org.apache.http.HttpHost;

public class SplitClientConfig {
    private final String _endpoint;
    private final String _eventsEndpoint;
    private final int _featuresRefreshRate;
    private final int _segmentsRefreshRate;
    private final int _impressionsRefreshRate;
    private final int _impressionsQueueSize;
    private final int _metricsRefreshRate;
    private final int _connectionTimeout;
    private final int _readTimeout;
    private final int _numThreadsForSegmentFetch;
    private final boolean _debugEnabled;
    private final boolean _labelsEnabled;
    private final int _ready;
    private final ImpressionListener _impressionListener;
    private final int _impressionListenerCapacity;
    private final int _waitBeforeShutdown;
    private final HttpHost _proxy;
    private final String _proxyUsername;
    private final String _proxyPassword;
    public static String splitSdkVersion;

    public static Builder builder() {
        return new Builder();
    }

    private SplitClientConfig(String endpoint, String eventsEndpoint, int pollForFeatureChangesEveryNSeconds, int segmentsRefreshRate, int impressionsRefreshRate, int impressionsQueueSize, int metricsRefreshRate, int connectionTimeout, int readTimeout, int numThreadsForSegmentFetch, int ready, boolean debugEnabled, boolean labelsEnabled, ImpressionListener impressionListener, int impressionListenerCapacity, int waitBeforeShutdown, HttpHost proxy, String proxyUsername, String proxyPassword) {
        this._endpoint = endpoint;
        this._eventsEndpoint = eventsEndpoint;
        this._featuresRefreshRate = pollForFeatureChangesEveryNSeconds;
        this._segmentsRefreshRate = segmentsRefreshRate;
        this._impressionsRefreshRate = impressionsRefreshRate;
        this._impressionsQueueSize = impressionsQueueSize;
        this._metricsRefreshRate = metricsRefreshRate;
        this._connectionTimeout = connectionTimeout;
        this._readTimeout = readTimeout;
        this._numThreadsForSegmentFetch = numThreadsForSegmentFetch;
        this._ready = ready;
        this._debugEnabled = debugEnabled;
        this._labelsEnabled = labelsEnabled;
        this._impressionListener = impressionListener;
        this._impressionListenerCapacity = impressionListenerCapacity;
        this._waitBeforeShutdown = waitBeforeShutdown;
        this._proxy = proxy;
        this._proxyUsername = proxyUsername;
        this._proxyPassword = proxyPassword;
        Properties props = new Properties();
        try {
            props.load(this.getClass().getClassLoader().getResourceAsStream("version.properties"));
        }
        catch (IOException e) {
            throw new IllegalStateException("cannot find client version in classpath", e);
        }
        splitSdkVersion = "undefined";
        if (props.getProperty("sdk.version") != null) {
            splitSdkVersion = "java-" + props.getProperty("sdk.version");
        }
    }

    public String endpoint() {
        return this._endpoint;
    }

    public String eventsEndpoint() {
        return this._eventsEndpoint;
    }

    public int featuresRefreshRate() {
        return this._featuresRefreshRate;
    }

    public int segmentsRefreshRate() {
        return this._segmentsRefreshRate;
    }

    public int numThreadsForSegmentFetch() {
        return this._numThreadsForSegmentFetch;
    }

    public int impressionsRefreshRate() {
        return this._impressionsRefreshRate;
    }

    public int impressionsQueueSize() {
        return this._impressionsQueueSize;
    }

    public int metricsRefreshRate() {
        return this._metricsRefreshRate;
    }

    public int connectionTimeout() {
        return this._connectionTimeout;
    }

    public int readTimeout() {
        return this._readTimeout;
    }

    public boolean debugEnabled() {
        return this._debugEnabled;
    }

    public boolean labelsEnabled() {
        return this._labelsEnabled;
    }

    public int blockUntilReady() {
        return this._ready;
    }

    public ImpressionListener impressionListener() {
        return this._impressionListener;
    }

    public int impressionListenerCapactity() {
        return this._impressionListenerCapacity;
    }

    public int waitBeforeShutdown() {
        return this._waitBeforeShutdown;
    }

    public HttpHost proxy() {
        return this._proxy;
    }

    public String proxyUsername() {
        return this._proxyUsername;
    }

    public String proxyPassword() {
        return this._proxyPassword;
    }

    public static final class Builder {
        private String _endpoint = "https://sdk.split.io";
        private boolean _endpointSet = false;
        private String _eventsEndpoint = "https://events.split.io";
        private boolean _eventsEndpointSet = false;
        private int _featuresRefreshRate = 60;
        private int _segmentsRefreshRate = 60;
        private int _impressionsRefreshRate = 30;
        private int _impressionsQueueSize = 30000;
        private int _connectionTimeout = 15000;
        private int _readTimeout = 15000;
        private int _numThreadsForSegmentFetch = 2;
        private boolean _debugEnabled = false;
        private int _ready = -1;
        private int _metricsRefreshRate = 60;
        private boolean _labelsEnabled = true;
        private ImpressionListener _impressionListener;
        private int _impressionListenerCapacity;
        private int _waitBeforeShutdown = 5000;
        private String _proxyHost = "localhost";
        private int _proxyPort = -1;
        private String _proxyUsername;
        private String _proxyPassword;

        public Builder endpoint(String endpoint, String eventsEndpoint) {
            this._endpoint = endpoint;
            this._eventsEndpoint = eventsEndpoint;
            return this;
        }

        public Builder featuresRefreshRate(int seconds) {
            this._featuresRefreshRate = seconds;
            return this;
        }

        public Builder segmentsRefreshRate(int seconds) {
            this._segmentsRefreshRate = seconds;
            return this;
        }

        public Builder impressionsRefreshRate(int seconds) {
            this._impressionsRefreshRate = seconds;
            return this;
        }

        public Builder impressionsQueueSize(int impressionsQueueSize) {
            this._impressionsQueueSize = impressionsQueueSize;
            return this;
        }

        public Builder impressionListener(ImpressionListener impressionListener, int queueSize) {
            this._impressionListener = impressionListener;
            this._impressionListenerCapacity = queueSize;
            return this;
        }

        public Builder metricsRefreshRate(int seconds) {
            this._metricsRefreshRate = seconds;
            return this;
        }

        public Builder connectionTimeout(int ms) {
            this._connectionTimeout = ms;
            return this;
        }

        public Builder readTimeout(int ms) {
            this._readTimeout = ms;
            return this;
        }

        public Builder enableDebug() {
            this._debugEnabled = true;
            return this;
        }

        public Builder disableLabels() {
            this._labelsEnabled = false;
            return this;
        }

        public Builder ready(int milliseconds) {
            this._ready = milliseconds;
            return this;
        }

        public Builder waitBeforeShutdown(int waitTime) {
            this._waitBeforeShutdown = waitTime;
            return this;
        }

        public Builder proxyHost(String proxyHost) {
            this._proxyHost = proxyHost;
            return this;
        }

        public Builder proxyPort(int proxyPort) {
            this._proxyPort = proxyPort;
            return this;
        }

        public Builder proxyUsername(String proxyUsername) {
            this._proxyUsername = proxyUsername;
            return this;
        }

        public Builder proxyPassword(String proxyPassword) {
            this._proxyPassword = proxyPassword;
            return this;
        }

        HttpHost proxy() {
            if (this._proxyPort != -1) {
                return new HttpHost(this._proxyHost, this._proxyPort);
            }
            return null;
        }

        public SplitClientConfig build() {
            if (this._featuresRefreshRate < 30) {
                throw new IllegalArgumentException("featuresRefreshRate must be >= 30: " + this._featuresRefreshRate);
            }
            if (this._segmentsRefreshRate < 30) {
                throw new IllegalArgumentException("segmentsRefreshRate must be >= 30: " + this._segmentsRefreshRate);
            }
            if (this._impressionsRefreshRate < 30) {
                throw new IllegalArgumentException("impressionsRefreshRate must be >= 30: " + this._impressionsRefreshRate);
            }
            if (this._metricsRefreshRate < 30) {
                throw new IllegalArgumentException("metricsRefreshRate must be >= 30: " + this._metricsRefreshRate);
            }
            if (this._impressionsQueueSize <= 0) {
                throw new IllegalArgumentException("impressionsQueueSize must be > 0: " + this._impressionsQueueSize);
            }
            if (this._connectionTimeout <= 0) {
                throw new IllegalArgumentException("connectionTimeOutInMs must be > 0: " + this._connectionTimeout);
            }
            if (this._readTimeout <= 0) {
                throw new IllegalArgumentException("readTimeout must be > 0: " + this._readTimeout);
            }
            if (this._endpoint == null) {
                throw new IllegalArgumentException("endpoint must not be null");
            }
            if (this._eventsEndpoint == null) {
                throw new IllegalArgumentException("events endpoint must not be null");
            }
            if (this._endpointSet && !this._eventsEndpointSet) {
                throw new IllegalArgumentException("If endpoint is set, you must also set the events endpoint");
            }
            if (this._numThreadsForSegmentFetch <= 0) {
                throw new IllegalArgumentException("Number of threads for fetching segments MUST be greater than zero");
            }
            if (this._impressionListener != null && this._impressionListenerCapacity <= 0) {
                throw new IllegalArgumentException("An ImpressionListener was provided, but its capacity was non-positive: " + this._impressionListenerCapacity);
            }
            return new SplitClientConfig(this._endpoint, this._eventsEndpoint, this._featuresRefreshRate, this._segmentsRefreshRate, this._impressionsRefreshRate, this._impressionsQueueSize, this._metricsRefreshRate, this._connectionTimeout, this._readTimeout, this._numThreadsForSegmentFetch, this._ready, this._debugEnabled, this._labelsEnabled, this._impressionListener, this._impressionListenerCapacity, this._waitBeforeShutdown, this.proxy(), this._proxyUsername, this._proxyPassword);
        }
    }
}

