/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.jmx;

import java.lang.management.ManagementFactory;
import java.net.URL;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxMonitor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
    private static JmxMonitor monitorInstance;

    private JmxMonitor() {
    }

    public static JmxMonitor getInstance() {
        if (monitorInstance == null) {
            monitorInstance = new JmxMonitor();
        }
        return monitorInstance;
    }

    public void registerMonitor(String name, String monitorType, Object monitoringInterface) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        String monitorName = this.generateMonitorName(name, monitorType);
        this.log.info("Registering JMX {}", (Object)monitorName);
        ObjectName oName = new ObjectName(monitorName);
        if (this.mbs.isRegistered(oName)) {
            this.log.info("Monitor already registered: {}", (Object)oName);
            return;
        }
        this.mbs.registerMBean(monitoringInterface, oName);
    }

    public void unregisterMonitor(String name, String monitorType) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        String monitorName = this.generateMonitorName(name, monitorType);
        this.log.info("Unregistering JMX {}", (Object)monitorName);
        ObjectName oName = new ObjectName(monitorName);
        if (!this.mbs.isRegistered(oName)) {
            this.log.info("Monitor is not registered: {}", (Object)oName);
            return;
        }
        try {
            this.mbs.unregisterMBean(oName);
        }
        catch (InstanceNotFoundException e) {
            this.log.warn("Failed to unregister monitor: {}" + oName.toString(), (Throwable)e);
        }
    }

    private String generateMonitorName(String className, String monitorType) {
        StringBuilder sb = new StringBuilder();
        sb.append(className);
        sb.append(":");
        sb.append(this.getUniqueClassloaderIdentifier());
        if (null != monitorType && monitorType.length() > 0) {
            sb.append("Type=" + monitorType);
        }
        return sb.toString();
    }

    private String getUniqueClassloaderIdentifier() {
        String contextPath = this.getContextPath();
        if (contextPath != null) {
            return contextPath;
        }
        return "split";
    }

    private String getContextPath() {
        ClassLoader loader = this.getClass().getClassLoader();
        if (loader == null) {
            return null;
        }
        URL url = loader.getResource("/");
        if (url != null) {
            String[] elements = url.toString().split("/");
            for (int i = elements.length - 1; i > 0; --i) {
                if (!"WEB-INF".equals(elements[i])) continue;
                return elements[i - 1];
            }
        }
        return null;
    }
}

