/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import com.google.common.base.Preconditions;
import io.split.client.LocalhostSplitClient;
import io.split.client.LocalhostSplitFactory;
import io.split.client.SplitAndKey;
import io.split.client.SplitClient;
import io.split.client.api.Key;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalhostSplitClientAndFactory
implements SplitClient {
    private static final Logger _log = LoggerFactory.getLogger(LocalhostSplitClientAndFactory.class);
    private LocalhostSplitFactory _factory;
    private LocalhostSplitClient _splitClient;

    public LocalhostSplitClientAndFactory(LocalhostSplitFactory container, LocalhostSplitClient client) {
        this._factory = container;
        this._splitClient = client;
        Preconditions.checkNotNull((Object)this._factory);
        Preconditions.checkNotNull((Object)this._splitClient);
    }

    @Override
    public String getTreatment(String key, String split) {
        return this._splitClient.getTreatment(key, split);
    }

    @Override
    public String getTreatment(String key, String split, Map<String, Object> attributes) {
        return this._splitClient.getTreatment(key, split, attributes);
    }

    @Override
    public String getTreatment(Key key, String split, Map<String, Object> attributes) {
        return this._splitClient.getTreatment(key.matchingKey(), split, attributes);
    }

    public void updateFeatureToTreatmentMap(Map<SplitAndKey, String> map) {
        if (map == null) {
            _log.warn("A null map was passed as an update. Ignoring this update.");
            return;
        }
        this._splitClient.updateFeatureToTreatmentMap(map);
    }

    @Override
    public void destroy() {
        this._factory.destroy();
        this._splitClient.destroy();
    }

    @Override
    public boolean track(String key, String trafficType, String eventType) {
        return this._splitClient.track(key, trafficType, eventType);
    }

    @Override
    public boolean track(String key, String trafficType, String eventType, double value) {
        return this._splitClient.track(key, trafficType, eventType, value);
    }

    @Override
    public void blockUntilReady() throws TimeoutException, InterruptedException {
        this._splitClient.blockUntilReady();
    }
}

