/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import com.google.common.base.Preconditions;
import io.split.client.LocalhostSplit;
import io.split.client.SplitAndKey;
import io.split.client.SplitClient;
import io.split.client.api.Key;
import io.split.client.api.SplitResult;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalhostSplitClient
implements SplitClient {
    private static final Logger _log = LoggerFactory.getLogger(LocalhostSplitClient.class);
    private static SplitResult SPLIT_RESULT_CONTROL = new SplitResult("control", null);
    private Map<SplitAndKey, LocalhostSplit> _map;

    public LocalhostSplitClient(Map<SplitAndKey, LocalhostSplit> map) {
        Preconditions.checkNotNull(map, (Object)"map must not be null");
        this._map = map;
    }

    @Override
    public String getTreatment(String key, String split) {
        return this.getTreatmentAndConfigInternal(key, split).treatment();
    }

    @Override
    public String getTreatment(String key, String split, Map<String, Object> attributes) {
        return this.getTreatmentAndConfigInternal(key, split).treatment();
    }

    @Override
    public String getTreatment(Key key, String split, Map<String, Object> attributes) {
        return this.getTreatmentAndConfigInternal(key.matchingKey(), split, attributes).treatment();
    }

    @Override
    public SplitResult getTreatmentWithConfig(String key, String split) {
        return this.getTreatmentAndConfigInternal(key, split);
    }

    @Override
    public SplitResult getTreatmentWithConfig(String key, String split, Map<String, Object> attributes) {
        return this.getTreatmentAndConfigInternal(key, split, attributes);
    }

    @Override
    public SplitResult getTreatmentWithConfig(Key key, String split, Map<String, Object> attributes) {
        return this.getTreatmentAndConfigInternal(key.matchingKey(), split, attributes);
    }

    private SplitResult getTreatmentAndConfigInternal(String key, String split) {
        return this.getTreatmentAndConfigInternal(key, split, null);
    }

    private SplitResult getTreatmentAndConfigInternal(String key, String split, Map<String, Object> attributes) {
        if (key == null || split == null) {
            return SPLIT_RESULT_CONTROL;
        }
        SplitAndKey override = SplitAndKey.of(split, key);
        if (this._map.containsKey(override)) {
            return this.toSplitResult(this._map.get(override));
        }
        SplitAndKey splitDefaultTreatment = SplitAndKey.of(split);
        LocalhostSplit localhostSplit = this._map.get(splitDefaultTreatment);
        if (localhostSplit == null) {
            return SPLIT_RESULT_CONTROL;
        }
        return this.toSplitResult(localhostSplit);
    }

    private SplitResult toSplitResult(LocalhostSplit localhostSplit) {
        return new SplitResult(localhostSplit.treatment, localhostSplit.config);
    }

    public void updateFeatureToTreatmentMap(Map<SplitAndKey, LocalhostSplit> map) {
        if (map == null) {
            _log.warn("A null map was passed as an update. Ignoring this update.");
            return;
        }
        this._map = map;
    }

    @Override
    public void destroy() {
        this._map.clear();
    }

    @Override
    public boolean track(String key, String trafficType, String eventType) {
        return false;
    }

    @Override
    public boolean track(String key, String trafficType, String eventType, double value) {
        return false;
    }

    @Override
    public void blockUntilReady() throws TimeoutException, InterruptedException {
    }
}

