/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.segments;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.split.engine.SDKReadinessGates;
import io.split.engine.segments.RefreshableSegment;
import io.split.engine.segments.SegmentChangeFetcher;
import io.split.engine.segments.SegmentFetcher;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshableSegmentFetcher
implements Closeable,
SegmentFetcher {
    private static final Logger _log = LoggerFactory.getLogger(RefreshableSegmentFetcher.class);
    private final SegmentChangeFetcher _segmentChangeFetcher;
    private final AtomicLong _refreshEveryNSeconds;
    private final Object _lock = new Object();
    private final ConcurrentMap<String, RefreshableSegment> _segmentFetchers = Maps.newConcurrentMap();
    private final ScheduledExecutorService _scheduledExecutorService;
    private final SDKReadinessGates _gates;

    public RefreshableSegmentFetcher(SegmentChangeFetcher segmentChangeFetcher, long refreshEveryNSeconds, int numThreads, SDKReadinessGates gates) {
        this._segmentChangeFetcher = segmentChangeFetcher;
        Preconditions.checkNotNull((Object)this._segmentChangeFetcher);
        Preconditions.checkArgument((refreshEveryNSeconds >= 0L ? 1 : 0) != 0);
        this._refreshEveryNSeconds = new AtomicLong(refreshEveryNSeconds);
        ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder();
        threadFactoryBuilder.setDaemon(true);
        threadFactoryBuilder.setNameFormat("split-segmentFetcher-%d");
        this._scheduledExecutorService = Executors.newScheduledThreadPool(numThreads, threadFactoryBuilder.build());
        this._gates = gates;
        Preconditions.checkNotNull((Object)this._gates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RefreshableSegment segment(String segmentName) {
        RefreshableSegment segment = (RefreshableSegment)this._segmentFetchers.get(segmentName);
        if (segment != null) {
            return segment;
        }
        Object object = this._lock;
        synchronized (object) {
            segment = (RefreshableSegment)this._segmentFetchers.get(segmentName);
            if (segment != null) {
                return segment;
            }
            try {
                this._gates.registerSegment(segmentName);
            }
            catch (InterruptedException e) {
                _log.error("Unable to register segment " + segmentName);
            }
            segment = RefreshableSegment.create(segmentName, this._segmentChangeFetcher, this._gates);
            this._scheduledExecutorService.scheduleWithFixedDelay(segment, 0L, this._refreshEveryNSeconds.get(), TimeUnit.SECONDS);
            this._segmentFetchers.putIfAbsent(segmentName, segment);
            return segment;
        }
    }

    @Override
    public void close() {
        if (this._scheduledExecutorService == null || this._scheduledExecutorService.isShutdown()) {
            return;
        }
        this._scheduledExecutorService.shutdown();
        try {
            if (!this._scheduledExecutorService.awaitTermination(2L, TimeUnit.SECONDS)) {
                _log.info("Executor did not terminate in the specified time.");
                List<Runnable> droppedTasks = this._scheduledExecutorService.shutdownNow();
                _log.info("Executor was abruptly shut down. These tasks will not be executed: " + droppedTasks);
            }
        }
        catch (InterruptedException e) {
            _log.error("Shutdown of SegmentFetchers was interrupted");
            Thread.currentThread().interrupt();
        }
    }
}

