/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.metrics;

import io.split.client.metrics.ILatencyTracker;

public class LogarithmicSearchLatencyTracker
implements ILatencyTracker {
    static final int BUCKETS = 23;
    private static final double LOG_10_1000_MICROS = Math.log10(1000.0);
    private static final double LOG_10_1_5_MICROS = Math.log10(Double.valueOf("1.5"));
    long[] latencies = new long[23];

    @Override
    public void addLatencyMillis(long millis) {
        int index;
        int n = index = this.findIndex(millis * 1000L);
        this.latencies[n] = this.latencies[n] + 1L;
    }

    @Override
    public void addLatencyMicros(long micros) {
        int index;
        int n = index = this.findIndex(micros);
        this.latencies[n] = this.latencies[n] + 1L;
    }

    @Override
    public long[] getLatencies() {
        return this.latencies;
    }

    @Override
    public long getLatency(int index) {
        return this.latencies[index];
    }

    @Override
    public void clear() {
        this.latencies = new long[23];
    }

    @Override
    public long getBucketForLatencyMillis(long latency) {
        return this.latencies[this.findIndex(latency * 1000L)];
    }

    @Override
    public long getBucketForLatencyMicros(long latency) {
        return this.latencies[this.findIndex(latency)];
    }

    private int findIndex(long micros) {
        if (micros <= 1000L) {
            return 0;
        }
        if (micros > 4987885L) {
            return 22;
        }
        double raw = (Math.log10(micros) - LOG_10_1000_MICROS) / LOG_10_1_5_MICROS;
        double rounded = (double)Math.round(raw * 1000000.0) / 1000000.0;
        return (int)Math.ceil(rounded);
    }
}

