/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.matchers;

import io.split.client.SplitClientImpl;
import io.split.client.dtos.DataType;
import io.split.engine.matchers.Matcher;
import io.split.engine.matchers.Transformers;
import java.util.Map;

public class BetweenMatcher
implements Matcher {
    private final long _start;
    private final long _end;
    private final long _normalizedStart;
    private final long _normalizedEnd;
    private final DataType _dataType;

    public BetweenMatcher(long start, long end, DataType dataType) {
        this._start = start;
        this._end = end;
        this._dataType = dataType;
        if (this._dataType == DataType.DATETIME) {
            this._normalizedStart = Transformers.asDateHourMinute(this._start);
            this._normalizedEnd = Transformers.asDateHourMinute(this._end);
        } else {
            this._normalizedStart = this._start;
            this._normalizedEnd = this._end;
        }
    }

    @Override
    public boolean match(Object matchValue, String bucketingKey, Map<String, Object> attributes, SplitClientImpl splitClient) {
        Long keyAsLong = this._dataType == DataType.DATETIME ? Transformers.asDateHourMinute(matchValue) : Transformers.asLong(matchValue);
        if (keyAsLong == null) {
            return false;
        }
        return keyAsLong >= this._normalizedStart && keyAsLong <= this._normalizedEnd;
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("between ");
        bldr.append(this._start);
        bldr.append(" and ");
        bldr.append(this._end);
        return bldr.toString();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (int)(this._start ^ this._start >>> 32);
        result = 31 * result + (int)(this._end ^ this._end >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BetweenMatcher)) {
            return false;
        }
        BetweenMatcher other = (BetweenMatcher)obj;
        return this._start == other._start && this._end == other._end;
    }
}

