/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import com.google.common.annotations.VisibleForTesting;
import io.split.client.EventClient;
import io.split.client.dtos.Event;
import io.split.client.utils.GenericClientUtil;
import io.split.client.utils.Utils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.org.apache.http.impl.client.CloseableHttpClient;

public class EventClientImpl
implements EventClient {
    public static final Long MAX_SIZE_BYTES = 0x500000L;
    private final BlockingQueue<WrappedEvent> _eventQueue;
    private final int _maxQueueSize;
    private final long _flushIntervalMillis;
    private final ExecutorService _senderExecutor;
    private final ExecutorService _consumerExecutor;
    private final ScheduledExecutorService _flushScheduler;
    static final Event CENTINEL = new Event();
    private static final Logger _log = LoggerFactory.getLogger(EventClientImpl.class);
    private final CloseableHttpClient _httpclient;
    private final URI _target;
    private final int _waitBeforeShutdown;

    ThreadFactory eventClientThreadFactory(final String name) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(final Runnable r) {
                return new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Thread.currentThread().setPriority(1);
                        r.run();
                    }
                }, name);
            }
        };
    }

    public static EventClientImpl create(CloseableHttpClient httpclient, URI eventsRootTarget, int maxQueueSize, long flushIntervalMillis, int waitBeforeShutdown) throws URISyntaxException {
        return new EventClientImpl(new LinkedBlockingQueue<WrappedEvent>(), httpclient, Utils.appendPath(eventsRootTarget, "api/events/bulk"), maxQueueSize, flushIntervalMillis, waitBeforeShutdown);
    }

    EventClientImpl(BlockingQueue<WrappedEvent> eventQueue, CloseableHttpClient httpclient, URI target, int maxQueueSize, long flushIntervalMillis, int waitBeforeShutdown) throws URISyntaxException {
        this._httpclient = httpclient;
        this._target = target;
        this._eventQueue = eventQueue;
        this._waitBeforeShutdown = waitBeforeShutdown;
        this._maxQueueSize = maxQueueSize;
        this._flushIntervalMillis = flushIntervalMillis;
        this._senderExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(50), this.eventClientThreadFactory("eventclient-sender"), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                _log.warn("Executor queue full. Dropping events.");
            }
        });
        this._consumerExecutor = Executors.newSingleThreadExecutor(this.eventClientThreadFactory("eventclient-consumer"));
        this._consumerExecutor.submit(new Consumer());
        this._flushScheduler = Executors.newScheduledThreadPool(1, this.eventClientThreadFactory("eventclient-flush"));
        this._flushScheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                EventClientImpl.this.flush();
            }
        }, this._flushIntervalMillis, this._flushIntervalMillis, TimeUnit.MILLISECONDS);
    }

    public void flush() {
        this.track(CENTINEL, 0);
    }

    @Override
    public boolean track(Event event, int eventSize) {
        try {
            if (event == null) {
                return false;
            }
            this._eventQueue.put(new WrappedEvent(event, eventSize));
        }
        catch (InterruptedException e) {
            _log.warn("Interruption when adding event withed while adding message %s.", (Object)event);
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        try {
            this._consumerExecutor.shutdownNow();
            this._flushScheduler.shutdownNow();
            this._senderExecutor.awaitTermination(this._waitBeforeShutdown, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            _log.warn("Error when shutting down EventClientImpl", (Throwable)e);
        }
    }

    @VisibleForTesting
    URI getTarget() {
        return this._target;
    }

    static class EventSenderTask
    implements Runnable {
        private final List<Event> _data;
        private final URI _endpoint;
        private final CloseableHttpClient _client;

        static EventSenderTask create(CloseableHttpClient httpclient, URI eventsTarget, List<Event> events) {
            return new EventSenderTask(httpclient, eventsTarget, events);
        }

        EventSenderTask(CloseableHttpClient httpclient, URI eventsTarget, List<Event> events) {
            this._client = httpclient;
            this._data = events;
            this._endpoint = eventsTarget;
        }

        @Override
        public void run() {
            GenericClientUtil.process(this._data, this._endpoint, this._client);
        }
    }

    static class WrappedEvent {
        private final Event _event;
        private final long _size;

        public WrappedEvent(Event event, long size) {
            this._event = event;
            this._size = size;
        }

        public Event event() {
            return this._event;
        }

        public long size() {
            return this._size;
        }
    }

    class Consumer
    implements Runnable {
        Consumer() {
        }

        @Override
        public void run() {
            ArrayList<Event> events = new ArrayList<Event>();
            long accumulated = 0L;
            try {
                while (true) {
                    WrappedEvent data = (WrappedEvent)EventClientImpl.this._eventQueue.take();
                    Event event = data.event();
                    Long size = data.size();
                    if (event != CENTINEL) {
                        events.add(event);
                        accumulated += size.longValue();
                    } else if (events.size() < 1) {
                        if (!_log.isDebugEnabled()) continue;
                        _log.debug("No messages to publish.");
                        continue;
                    }
                    if (events.size() < EventClientImpl.this._maxQueueSize && accumulated < MAX_SIZE_BYTES && event != CENTINEL) continue;
                    if (_log.isDebugEnabled()) {
                        _log.debug(String.format("Sending %d events", events.size()));
                    }
                    EventClientImpl.this._senderExecutor.submit(EventSenderTask.create(EventClientImpl.this._httpclient, EventClientImpl.this._target, events));
                    events = new ArrayList();
                    accumulated = 0L;
                }
            }
            catch (InterruptedException e) {
                _log.debug("Consumer thread was interrupted. Exiting...");
                return;
            }
        }
    }
}

