/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.metrics;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.primitives.Longs;
import io.split.client.dtos.Counter;
import io.split.client.dtos.Latency;
import io.split.client.metrics.BinarySearchLatencyTracker;
import io.split.client.metrics.DTOMetrics;
import io.split.client.metrics.ILatencyTracker;
import io.split.engine.metrics.Metrics;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class CachedMetrics
implements Metrics {
    private final DTOMetrics _metrics;
    private final Map<String, ILatencyTracker> _latencyMap;
    private final Map<String, SumAndCount> _countMap;
    private final Object _latencyLock = new Object();
    private AtomicLong _latencyLastUpdateTimeMillis = new AtomicLong(System.currentTimeMillis());
    private final Object _counterLock = new Object();
    private AtomicLong _counterLastUpdateTimeMillis = new AtomicLong(System.currentTimeMillis());
    private long _refreshPeriodInMillis;
    private final int _queueForTheseManyCalls;

    CachedMetrics(DTOMetrics httpMetrics, int queueForTheseManyCalls) {
        this(httpMetrics, queueForTheseManyCalls, TimeUnit.MINUTES.toMillis(1L));
    }

    public CachedMetrics(DTOMetrics httpMetrics, long refreshPeriodInMillis) {
        this(httpMetrics, 100, refreshPeriodInMillis);
    }

    private CachedMetrics(DTOMetrics metrics, int queueForTheseManyCalls, long refreshPeriodInMillis) {
        this._metrics = metrics;
        this._latencyMap = Maps.newHashMap();
        this._countMap = Maps.newHashMap();
        Preconditions.checkArgument((queueForTheseManyCalls > 0 ? 1 : 0) != 0, (Object)"queue for cache should be greater than zero");
        this._queueForTheseManyCalls = queueForTheseManyCalls;
        this._refreshPeriodInMillis = refreshPeriodInMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void count(String counter, long delta) {
        if (delta <= 0L) {
            return;
        }
        if (counter == null || counter.trim().isEmpty()) {
            return;
        }
        Object object = this._counterLock;
        synchronized (object) {
            SumAndCount sumAndCount = this._countMap.get(counter);
            if (sumAndCount == null) {
                sumAndCount = new SumAndCount();
                this._countMap.put(counter, sumAndCount);
            }
            sumAndCount.addDelta(delta);
            if (sumAndCount._count >= this._queueForTheseManyCalls || this.hasTimeElapsed(this._counterLastUpdateTimeMillis)) {
                Counter dto = new Counter();
                dto.name = counter;
                dto.delta = sumAndCount._sum;
                sumAndCount.clear();
                this._counterLastUpdateTimeMillis.set(System.currentTimeMillis());
                this._metrics.count(dto);
            }
        }
    }

    private boolean hasTimeElapsed(AtomicLong lastRefreshTime) {
        return System.currentTimeMillis() - lastRefreshTime.get() > this._refreshPeriodInMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void time(String operation, long timeInMs) {
        if (operation == null || operation.trim().isEmpty() || timeInMs < 0L) {
            return;
        }
        Object object = this._latencyLock;
        synchronized (object) {
            if (!this._latencyMap.containsKey(operation)) {
                BinarySearchLatencyTracker latencies = new BinarySearchLatencyTracker();
                this._latencyMap.put(operation, latencies);
            }
            ILatencyTracker tracker = this._latencyMap.get(operation);
            tracker.addLatencyMillis((int)timeInMs);
            if (this.hasTimeElapsed(this._latencyLastUpdateTimeMillis)) {
                Latency dto = new Latency();
                dto.name = operation;
                dto.latencies = Longs.asList((long[])tracker.getLatencies());
                tracker.clear();
                this._latencyLastUpdateTimeMillis.set(System.currentTimeMillis());
                this._metrics.time(dto);
            }
        }
    }

    private static final class SumAndCount {
        private int _count = 0;
        private long _sum = 0L;

        private SumAndCount() {
        }

        public void addDelta(long delta) {
            ++this._count;
            this._sum += delta;
        }

        public void clear() {
            this._count = 0;
            this._sum = 0L;
        }
    }
}

