/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.sse;

import io.split.client.utils.Json;
import io.split.engine.sse.AuthApiClient;
import io.split.engine.sse.dtos.AuthenticationResponse;
import io.split.engine.sse.dtos.RawAuthResponse;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;
import split.com.google.gson.JsonObject;
import split.org.apache.http.client.methods.CloseableHttpResponse;
import split.org.apache.http.client.methods.HttpGet;
import split.org.apache.http.client.utils.URIBuilder;
import split.org.apache.http.impl.client.CloseableHttpClient;
import split.org.apache.http.util.EntityUtils;

public class AuthApiClientImp
implements AuthApiClient {
    private static final Logger _log = LoggerFactory.getLogger(AuthApiClient.class);
    private final CloseableHttpClient _httpClient;
    private final String _target;

    public AuthApiClientImp(String url, CloseableHttpClient httpClient) {
        this._httpClient = Preconditions.checkNotNull(httpClient);
        this._target = Preconditions.checkNotNull(url);
    }

    @Override
    public AuthenticationResponse Authenticate() {
        try {
            URI uri = new URIBuilder(this._target).build();
            HttpGet request = new HttpGet(uri);
            CloseableHttpResponse response = this._httpClient.execute(request);
            Integer statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                _log.debug(String.format("Success connection to: %s", this._target));
                String jsonContent = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
                return this.getSuccessResponse(jsonContent);
            }
            _log.warn(String.format("Problem to connect to : %s. Response status: %s", this._target, statusCode));
            if (statusCode >= 400 && statusCode < 500) {
                return new AuthenticationResponse(false, false);
            }
            return new AuthenticationResponse(false, true);
        }
        catch (Exception ex) {
            _log.error(ex.getMessage());
            return new AuthenticationResponse(false, true);
        }
    }

    private AuthenticationResponse getSuccessResponse(String jsonContent) {
        JsonObject jsonObject = Json.fromJson(jsonContent, JsonObject.class);
        String token = jsonObject.get("token") != null ? jsonObject.get("token").getAsString() : "";
        RawAuthResponse response = new RawAuthResponse(jsonObject.get("pushEnabled").getAsBoolean(), token);
        String channels = "";
        long expiration = 0L;
        if (response.isPushEnabled()) {
            channels = response.getChannels();
            expiration = response.getExpiration();
        }
        return new AuthenticationResponse(response.isPushEnabled(), response.getToken(), channels, 3000L, false);
    }
}

