/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.sse;

import io.split.engine.common.PushManager;
import io.split.engine.sse.PushStatusTracker;
import io.split.engine.sse.SseStatus;
import io.split.engine.sse.dtos.ControlNotification;
import io.split.engine.sse.dtos.ControlType;
import io.split.engine.sse.dtos.ErrorNotification;
import io.split.engine.sse.dtos.OccupancyNotification;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushStatusTrackerImp
implements PushStatusTracker {
    private static final Logger _log = LoggerFactory.getLogger(PushStatusTracker.class);
    private final AtomicBoolean _publishersOnline = new AtomicBoolean(true);
    private final AtomicReference<SseStatus> _sseStatus = new AtomicReference<SseStatus>(SseStatus.DISCONNECTED);
    private final AtomicReference<ControlType> _backendStatus = new AtomicReference<ControlType>(ControlType.STREAMING_RESUMED);
    private final LinkedBlockingQueue<PushManager.Status> _statusMessages;

    public PushStatusTrackerImp(LinkedBlockingQueue<PushManager.Status> statusMessages) {
        this._statusMessages = statusMessages;
    }

    public synchronized void reset() {
        this._publishersOnline.set(true);
        this._sseStatus.set(SseStatus.DISCONNECTED);
        this._backendStatus.set(ControlType.STREAMING_RESUMED);
    }

    @Override
    public void handleSseStatus(SseStatus newStatus) {
        _log.debug(String.format("handleSseStatus new status: %s", newStatus.toString()));
        _log.debug(String.format("handleSseStatus current status: %s", this._sseStatus.get().toString()));
        switch (newStatus) {
            case CONNECTED: {
                if (!this._sseStatus.compareAndSet(SseStatus.DISCONNECTED, SseStatus.CONNECTED) && !this._sseStatus.compareAndSet(SseStatus.RETRYABLE_ERROR, SseStatus.CONNECTED)) break;
                this._statusMessages.offer(PushManager.Status.STREAMING_READY);
                break;
            }
            case RETRYABLE_ERROR: {
                if (!this._sseStatus.compareAndSet(SseStatus.CONNECTED, SseStatus.RETRYABLE_ERROR)) break;
                this._statusMessages.offer(PushManager.Status.STREAMING_BACKOFF);
                break;
            }
            case NONRETRYABLE_ERROR: {
                if (!this._sseStatus.compareAndSet(SseStatus.CONNECTED, SseStatus.NONRETRYABLE_ERROR) && !this._sseStatus.compareAndSet(SseStatus.RETRYABLE_ERROR, SseStatus.NONRETRYABLE_ERROR)) break;
                this._statusMessages.offer(PushManager.Status.STREAMING_OFF);
                break;
            }
            case DISCONNECTED: {
                this.reset();
            }
        }
    }

    @Override
    public void handleIncomingControlEvent(ControlNotification controlNotification) {
        _log.debug(String.format("handleIncomingOccupancyEvent: %s", new Object[]{controlNotification.getControlType()}));
        if (this._backendStatus.get().equals((Object)ControlType.STREAMING_DISABLED)) {
            return;
        }
        switch (controlNotification.getControlType()) {
            case STREAMING_RESUMED: {
                if (!this._backendStatus.compareAndSet(ControlType.STREAMING_PAUSED, ControlType.STREAMING_RESUMED) || !this._publishersOnline.get()) break;
                this._statusMessages.offer(PushManager.Status.STREAMING_READY);
                break;
            }
            case STREAMING_PAUSED: {
                if (!this._backendStatus.compareAndSet(ControlType.STREAMING_RESUMED, ControlType.STREAMING_PAUSED) || !this._publishersOnline.get()) break;
                this._statusMessages.offer(PushManager.Status.STREAMING_DOWN);
                break;
            }
            case STREAMING_DISABLED: {
                this._backendStatus.set(ControlType.STREAMING_DISABLED);
                this._statusMessages.offer(PushManager.Status.STREAMING_OFF);
            }
        }
    }

    @Override
    public void handleIncomingOccupancyEvent(OccupancyNotification occupancyNotification) {
        _log.debug(String.format("handleIncomingOccupancyEvent: publishers=%d", occupancyNotification.getMetrics().getPublishers()));
        int publishers = occupancyNotification.getMetrics().getPublishers();
        if (publishers <= 0 && this._publishersOnline.compareAndSet(true, false) && this._backendStatus.get().equals((Object)ControlType.STREAMING_RESUMED)) {
            this._statusMessages.offer(PushManager.Status.STREAMING_DOWN);
        } else if (publishers >= 1 && this._publishersOnline.compareAndSet(false, true) && this._backendStatus.get().equals((Object)ControlType.STREAMING_RESUMED)) {
            this._statusMessages.offer(PushManager.Status.STREAMING_READY);
        }
    }

    @Override
    public void handleIncomingAblyError(ErrorNotification notification) {
        _log.debug(String.format("handleIncomingAblyError: %s", notification.getMessage()));
        if (this._backendStatus.get().equals((Object)ControlType.STREAMING_DISABLED)) {
            return;
        }
        if (notification.getCode() >= 40140 && notification.getCode() <= 40149) {
            this._statusMessages.offer(PushManager.Status.STREAMING_BACKOFF);
        }
        if (notification.getCode() >= 40000 && notification.getCode() <= 49999) {
            this._statusMessages.offer(PushManager.Status.STREAMING_OFF);
        }
    }

    @Override
    public synchronized void forcePushDisable() {
        _log.debug("forcePushDisable");
        this._publishersOnline.set(false);
        this._sseStatus.set(SseStatus.DISCONNECTED);
        this._backendStatus.set(ControlType.STREAMING_DISABLED);
        this._statusMessages.offer(PushManager.Status.STREAMING_OFF);
    }
}

