/*
 * Decompiled with CFR 0.152.
 */
package io.split.cache;

import io.split.cache.SplitCache;
import io.split.engine.experiments.ParsedSplit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.collect.ConcurrentHashMultiset;
import split.com.google.common.collect.Maps;
import split.com.google.common.collect.Multiset;
import split.com.google.common.collect.Sets;

public class InMemoryCacheImp
implements SplitCache {
    private static final Logger _log = LoggerFactory.getLogger(InMemoryCacheImp.class);
    private final ConcurrentMap<String, ParsedSplit> _concurrentMap = Maps.newConcurrentMap();
    private final Multiset<String> _concurrentTrafficTypeNameSet;
    private AtomicLong _changeNumber;

    public InMemoryCacheImp() {
        this(-1L);
    }

    public InMemoryCacheImp(long startingChangeNumber) {
        this._changeNumber = new AtomicLong(startingChangeNumber);
        this._concurrentTrafficTypeNameSet = ConcurrentHashMultiset.create();
    }

    @Override
    public void put(ParsedSplit split) {
        this._concurrentMap.put(split.feature(), split);
        if (split.trafficTypeName() != null) {
            this._concurrentTrafficTypeNameSet.add(split.trafficTypeName());
        }
    }

    @Override
    public boolean remove(String name) {
        ParsedSplit removed = (ParsedSplit)this._concurrentMap.remove(name);
        if (removed != null && removed.trafficTypeName() != null) {
            this._concurrentTrafficTypeNameSet.remove(removed.trafficTypeName());
        }
        return removed != null;
    }

    @Override
    public ParsedSplit get(String name) {
        return (ParsedSplit)this._concurrentMap.get(name);
    }

    @Override
    public Collection<ParsedSplit> getAll() {
        return this._concurrentMap.values();
    }

    @Override
    public Collection<ParsedSplit> getMany(List<String> names) {
        ArrayList<ParsedSplit> splits = new ArrayList<ParsedSplit>();
        for (String name : names) {
            ParsedSplit split = (ParsedSplit)this._concurrentMap.get(name);
            if (split == null) continue;
            splits.add(split);
        }
        return splits;
    }

    @Override
    public long getChangeNumber() {
        return this._changeNumber.get();
    }

    @Override
    public void setChangeNumber(long changeNumber) {
        if (changeNumber < this._changeNumber.get()) {
            _log.error("ChangeNumber for splits cache is less than previous");
        }
        this._changeNumber.set(changeNumber);
    }

    @Override
    public boolean trafficTypeExists(String trafficTypeName) {
        return Sets.newHashSet(this._concurrentTrafficTypeNameSet.elementSet()).contains(trafficTypeName);
    }

    @Override
    public void kill(String splitName, String defaultTreatment, long changeNumber) {
        ParsedSplit parsedSplit = (ParsedSplit)this._concurrentMap.get(splitName);
        ParsedSplit updatedSplit = new ParsedSplit(parsedSplit.feature(), parsedSplit.seed(), true, defaultTreatment, parsedSplit.parsedConditions(), parsedSplit.trafficTypeName(), changeNumber, parsedSplit.trafficAllocation(), parsedSplit.trafficAllocationSeed(), parsedSplit.algo(), parsedSplit.configurations());
        this._concurrentMap.put(splitName, updatedSplit);
    }

    @Override
    public void clear() {
        this._concurrentMap.clear();
        this._concurrentTrafficTypeNameSet.clear();
    }
}

