/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.common;

import io.split.cache.SegmentCache;
import io.split.cache.SplitCache;
import io.split.engine.common.Synchronizer;
import io.split.engine.experiments.SplitFetcher;
import io.split.engine.experiments.SplitSynchronizationTask;
import io.split.engine.segments.SegmentFetcher;
import io.split.engine.segments.SegmentSynchronizationTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;
import split.com.google.common.util.concurrent.ThreadFactoryBuilder;

public class SynchronizerImp
implements Synchronizer {
    private static final Logger _log = LoggerFactory.getLogger(Synchronizer.class);
    private final SplitSynchronizationTask _splitSynchronizationTask;
    private final SplitFetcher _splitFetcher;
    private final SegmentSynchronizationTask _segmentSynchronizationTaskImp;
    private final ScheduledExecutorService _syncAllScheduledExecutorService;
    private final SplitCache _splitCache;
    private final SegmentCache _segmentCache;

    public SynchronizerImp(SplitSynchronizationTask splitSynchronizationTask, SplitFetcher splitFetcher, SegmentSynchronizationTask segmentSynchronizationTaskImp, SplitCache splitCache, SegmentCache segmentCache) {
        this._splitSynchronizationTask = Preconditions.checkNotNull(splitSynchronizationTask);
        this._splitFetcher = Preconditions.checkNotNull(splitFetcher);
        this._segmentSynchronizationTaskImp = Preconditions.checkNotNull(segmentSynchronizationTaskImp);
        this._splitCache = Preconditions.checkNotNull(splitCache);
        this._segmentCache = Preconditions.checkNotNull(segmentCache);
        ThreadFactory splitsThreadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Split-SyncAll-%d").build();
        this._syncAllScheduledExecutorService = Executors.newSingleThreadScheduledExecutor(splitsThreadFactory);
    }

    @Override
    public void syncAll() {
        this._syncAllScheduledExecutorService.schedule(() -> {
            this._splitFetcher.fetchAll(true);
            this._segmentSynchronizationTaskImp.fetchAll(true);
        }, 0L, TimeUnit.SECONDS);
    }

    @Override
    public void startPeriodicFetching() {
        _log.debug("Starting Periodic Fetching ...");
        this._splitSynchronizationTask.startPeriodicFetching();
        this._segmentSynchronizationTaskImp.startPeriodicFetching();
    }

    @Override
    public void stopPeriodicFetching() {
        _log.debug("Stop Periodic Fetching ...");
        this._splitSynchronizationTask.stop();
        this._segmentSynchronizationTaskImp.stop();
    }

    @Override
    public void refreshSplits(long targetChangeNumber) {
        if (targetChangeNumber > this._splitCache.getChangeNumber()) {
            this._splitFetcher.forceRefresh(true);
        }
    }

    @Override
    public void localKillSplit(String splitName, String defaultTreatment, long newChangeNumber) {
        if (newChangeNumber > this._splitCache.getChangeNumber()) {
            this._splitCache.kill(splitName, defaultTreatment, newChangeNumber);
            this.refreshSplits(newChangeNumber);
        }
    }

    @Override
    public void refreshSegment(String segmentName, long changeNumber) {
        if (changeNumber > this._segmentCache.getChangeNumber(segmentName)) {
            SegmentFetcher fetcher = this._segmentSynchronizationTaskImp.getFetcher(segmentName);
            try {
                fetcher.fetch(true);
            }
            catch (NullPointerException np) {
                throw new NullPointerException();
            }
        }
    }
}

