/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.segments;

import io.split.cache.SegmentCache;
import io.split.client.dtos.SegmentChange;
import io.split.engine.SDKReadinessGates;
import io.split.engine.segments.SegmentChangeFetcher;
import io.split.engine.segments.SegmentFetcher;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;

public class SegmentFetcherImp
implements SegmentFetcher {
    private static final Logger _log = LoggerFactory.getLogger(SegmentFetcherImp.class);
    private final String _segmentName;
    private final SegmentChangeFetcher _segmentChangeFetcher;
    private final SegmentCache _segmentCache;
    private final SDKReadinessGates _gates;
    private final Object _lock = new Object();

    public SegmentFetcherImp(String segmentName, SegmentChangeFetcher segmentChangeFetcher, SDKReadinessGates gates, SegmentCache segmentCache) {
        this._segmentName = Preconditions.checkNotNull(segmentName);
        this._segmentChangeFetcher = Preconditions.checkNotNull(segmentChangeFetcher);
        this._segmentCache = Preconditions.checkNotNull(segmentCache);
        this._gates = Preconditions.checkNotNull(gates);
        this._segmentCache.updateSegment(segmentName, new ArrayList<String>(), new ArrayList<String>());
    }

    @Override
    public void fetch(boolean addCacheHeader) {
        block2: {
            try {
                this.callLoopRun(false, addCacheHeader);
            }
            catch (Throwable t) {
                _log.error("RefreshableSegmentFetcher failed: " + t.getMessage());
                if (!_log.isDebugEnabled()) break block2;
                _log.debug("Reason:", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithoutExceptionHandling(boolean addCacheHeader) {
        SegmentChange change = this._segmentChangeFetcher.fetch(this._segmentName, this._segmentCache.getChangeNumber(this._segmentName), addCacheHeader);
        if (change == null) {
            throw new IllegalStateException("SegmentChange was null");
        }
        if (change.till == this._segmentCache.getChangeNumber(this._segmentName)) {
            return;
        }
        if (change.since != this._segmentCache.getChangeNumber(this._segmentName) || change.since < this._segmentCache.getChangeNumber(this._segmentName)) {
            return;
        }
        if (change.added.isEmpty() && change.removed.isEmpty()) {
            this._segmentCache.setChangeNumber(this._segmentName, change.till);
            return;
        }
        Object object = this._lock;
        synchronized (object) {
            if (change.since != this._segmentCache.getChangeNumber(this._segmentName) || change.till < this._segmentCache.getChangeNumber(this._segmentName)) {
                return;
            }
            this._segmentCache.updateSegment(this._segmentName, change.added, change.removed);
            if (!change.added.isEmpty()) {
                _log.info(this._segmentName + " added keys: " + this.summarize(change.added));
            }
            if (!change.removed.isEmpty()) {
                _log.info(this._segmentName + " removed keys: " + this.summarize(change.removed));
            }
            this._segmentCache.setChangeNumber(this._segmentName, change.till);
        }
    }

    private String summarize(List<String> changes) {
        StringBuilder bldr = new StringBuilder();
        bldr.append("[");
        for (int i = 0; i < Math.min(3, changes.size()); ++i) {
            if (i != 0) {
                bldr.append(", ");
            }
            bldr.append(changes.get(i));
        }
        if (changes.size() > 3) {
            bldr.append("... ");
            bldr.append(changes.size() - 3);
            bldr.append(" others");
        }
        bldr.append("]");
        return bldr.toString();
    }

    private void callLoopRun(boolean isFetch, boolean addCacheHeader) {
        long end;
        long start;
        do {
            start = this._segmentCache.getChangeNumber(this._segmentName);
            this.runWithoutExceptionHandling(addCacheHeader);
            end = this._segmentCache.getChangeNumber(this._segmentName);
            if (!isFetch || !_log.isDebugEnabled()) continue;
            _log.debug(this._segmentName + " segment fetch before: " + start + ", after: " + this._segmentCache.getChangeNumber(this._segmentName));
        } while (start < end);
    }

    @Override
    public void runWhitCacheHeader() {
        this.fetchAndUpdate(true);
    }

    private void fetchAndUpdate(boolean addCacheHeader) {
        block2: {
            try {
                this._gates.registerSegment(this._segmentName);
                this.callLoopRun(true, addCacheHeader);
                this._gates.segmentIsReady(this._segmentName);
            }
            catch (Throwable t) {
                _log.error("RefreshableSegmentFetcher failed: " + t.getMessage());
                if (!_log.isDebugEnabled()) break block2;
                _log.debug("Reason:", t);
            }
        }
    }

    @Override
    public void fetchAll() {
        this.fetchAndUpdate(false);
    }
}

