/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.dtos.SplitChange;
import io.split.client.utils.Json;
import io.split.client.utils.Utils;
import io.split.engine.experiments.SplitChangeFetcher;
import io.split.engine.metrics.Metrics;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.net.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.common.base.Preconditions;

public final class HttpSplitChangeFetcher
implements SplitChangeFetcher {
    private static final Logger _log = LoggerFactory.getLogger(HttpSplitChangeFetcher.class);
    private static final String SINCE = "since";
    private static final String PREFIX = "splitChangeFetcher";
    private static final String NAME_CACHE = "Cache-Control";
    private static final String VALUE_CACHE = "no-cache";
    private final CloseableHttpClient _client;
    private final URI _target;
    private final Metrics _metrics;

    public static HttpSplitChangeFetcher create(CloseableHttpClient client, URI root) throws URISyntaxException {
        return HttpSplitChangeFetcher.create(client, root, new Metrics.NoopMetrics());
    }

    public static HttpSplitChangeFetcher create(CloseableHttpClient client, URI root, Metrics metrics) throws URISyntaxException {
        return new HttpSplitChangeFetcher(client, Utils.appendPath(root, "api/splitChanges"), metrics);
    }

    private HttpSplitChangeFetcher(CloseableHttpClient client, URI uri, Metrics metrics) {
        this._client = client;
        this._target = uri;
        this._metrics = metrics;
        Preconditions.checkNotNull(this._target);
    }

    @Override
    public SplitChange fetch(long since, boolean addCacheHeader) {
        SplitChange splitChange;
        long start = System.currentTimeMillis();
        CloseableHttpResponse response = null;
        try {
            int statusCode;
            URI uri = new URIBuilder(this._target).addParameter(SINCE, "" + since).build();
            HttpGet request = new HttpGet(uri);
            if (addCacheHeader) {
                request.setHeader(NAME_CACHE, (Object)VALUE_CACHE);
            }
            if ((statusCode = (response = this._client.execute((ClassicHttpRequest)request)).getCode()) < 200 || statusCode >= 300) {
                this._metrics.count("splitChangeFetcher.status." + statusCode, 1L);
                throw new IllegalStateException("Could not retrieve splitChanges; http return code " + statusCode);
            }
            String json = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            if (_log.isDebugEnabled()) {
                _log.debug("Received json: " + json);
            }
            splitChange = Json.fromJson(json, SplitChange.class);
        }
        catch (Throwable t) {
            try {
                this._metrics.count("splitChangeFetcher.exception", 1L);
                throw new IllegalStateException("Problem fetching splitChanges: " + t.getMessage(), t);
            }
            catch (Throwable throwable) {
                Utils.forceClose(response);
                this._metrics.time("splitChangeFetcher.time", System.currentTimeMillis() - start);
                throw throwable;
            }
        }
        Utils.forceClose(response);
        this._metrics.time("splitChangeFetcher.time", System.currentTimeMillis() - start);
        return splitChange;
    }

    @VisibleForTesting
    URI getTarget() {
        return this._target;
    }
}

