/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.impressions;

import io.split.client.dtos.KeyImpression;
import io.split.client.impressions.ImpressionsStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryImpressionsStorage
implements ImpressionsStorage {
    private static final Logger _log = LoggerFactory.getLogger(InMemoryImpressionsStorage.class);
    private final BlockingQueue<KeyImpression> _queue;

    public InMemoryImpressionsStorage(int queueSize) {
        this._queue = new LinkedBlockingQueue<KeyImpression>(queueSize);
    }

    @Override
    public List<KeyImpression> pop(int count) {
        ArrayList<KeyImpression> popped = new ArrayList<KeyImpression>();
        this._queue.drainTo(popped, count);
        return popped;
    }

    @Override
    public List<KeyImpression> pop() {
        ArrayList<KeyImpression> popped = new ArrayList<KeyImpression>();
        this._queue.drainTo(popped);
        return popped;
    }

    @Override
    public boolean isFull() {
        return this._queue.remainingCapacity() == 0;
    }

    @Override
    public boolean put(KeyImpression imp) {
        try {
            return this._queue.offer(imp);
        }
        catch (ClassCastException | IllegalArgumentException | NullPointerException e) {
            _log.warn("Unable to send impression to ImpressionsManager", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean put(List<KeyImpression> imps) {
        return false;
    }
}

