/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.matchers.strings;

import io.split.engine.evaluator.Evaluator;
import io.split.engine.matchers.Matcher;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WhitelistMatcher
implements Matcher {
    private final Set<String> _whitelist = new HashSet<String>();

    public WhitelistMatcher(Collection<String> whitelist) {
        if (whitelist == null) {
            throw new IllegalArgumentException("Null whitelist parameter");
        }
        this._whitelist.addAll(whitelist);
    }

    @Override
    public boolean match(Object matchValue, String bucketingKey, Map<String, Object> attributes, Evaluator evaluator) {
        return this._whitelist.contains(matchValue);
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("in segment [");
        boolean first = true;
        for (String item : this._whitelist) {
            if (!first) {
                bldr.append(',');
            }
            bldr.append('\"');
            bldr.append(item);
            bldr.append('\"');
            first = false;
        }
        bldr.append("]");
        return bldr.toString();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._whitelist.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WhitelistMatcher)) {
            return false;
        }
        WhitelistMatcher other = (WhitelistMatcher)obj;
        return this._whitelist.equals(other._whitelist);
    }
}

