/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.dtos.ChangeDto;
import io.split.client.dtos.Condition;
import io.split.client.dtos.ConditionType;
import io.split.client.dtos.Split;
import io.split.client.dtos.SplitChange;
import io.split.client.dtos.Status;
import io.split.client.utils.InputStreamProvider;
import io.split.client.utils.LocalhostConstants;
import io.split.client.utils.LocalhostSanitizer;
import io.split.engine.common.FetchOptions;
import io.split.engine.experiments.SplitChangeFetcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.org.yaml.snakeyaml.Yaml;

public class YamlLocalhostSplitChangeFetcher
implements SplitChangeFetcher {
    private static final Logger _log = LoggerFactory.getLogger(YamlLocalhostSplitChangeFetcher.class);
    private final InputStreamProvider _inputStreamProvider;

    public YamlLocalhostSplitChangeFetcher(InputStreamProvider inputStreamProvider) {
        this._inputStreamProvider = inputStreamProvider;
    }

    @Override
    public SplitChange fetch(long since, long sinceRBS, FetchOptions options) {
        try {
            Yaml yaml = new Yaml();
            List yamlSplits = (List)yaml.load(this._inputStreamProvider.get());
            SplitChange splitChange = new SplitChange();
            splitChange.featureFlags = new ChangeDto();
            splitChange.featureFlags.d = new ArrayList();
            for (Map aSplit : yamlSplits) {
                Map.Entry splitAndValues = aSplit.entrySet().iterator().next();
                Optional<Split> splitOptional = splitChange.featureFlags.d.stream().filter(split -> split.name.equals(splitAndValues.getKey())).findFirst();
                Split split2 = splitOptional.orElse(null);
                if (split2 == null) {
                    split2 = new Split();
                    split2.name = (String)splitAndValues.getKey();
                    split2.configurations = new HashMap<String, String>();
                    split2.conditions = new ArrayList<Condition>();
                } else {
                    splitChange.featureFlags.d.remove(split2);
                }
                String treatment = (String)((Map)splitAndValues.getValue()).get("treatment");
                String configurations = ((Map)splitAndValues.getValue()).get("config") != null ? (String)((Map)splitAndValues.getValue()).get("config") : null;
                Object keyOrKeys = ((Map)splitAndValues.getValue()).get("keys");
                split2.configurations.put(treatment, configurations);
                Condition condition = LocalhostSanitizer.createCondition(keyOrKeys, treatment);
                if (condition.conditionType != ConditionType.ROLLOUT) {
                    split2.conditions.add(0, condition);
                } else {
                    split2.conditions.add(condition);
                }
                split2.status = Status.ACTIVE;
                split2.defaultTreatment = "control";
                split2.trafficTypeName = "user";
                split2.trafficAllocation = LocalhostConstants.SIZE_100;
                split2.trafficAllocationSeed = LocalhostConstants.SIZE_1;
                splitChange.featureFlags.d.add(split2);
            }
            splitChange.featureFlags.t = since;
            splitChange.featureFlags.s = since;
            splitChange.ruleBasedSegments = new ChangeDto();
            splitChange.ruleBasedSegments.s = -1L;
            splitChange.ruleBasedSegments.t = -1L;
            splitChange.ruleBasedSegments.d = new ArrayList();
            return splitChange;
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem fetching splitChanges using a yaml file: " + e.getMessage(), e);
        }
    }
}

