/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.matchers;

import io.split.engine.evaluator.EvaluationContext;
import io.split.engine.matchers.Matcher;
import io.split.engine.matchers.Semver;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class InListSemverMatcher
implements Matcher {
    private final Set<Semver> _semverlist = new HashSet<Semver>();

    public InListSemverMatcher(Collection<String> whitelist) {
        for (String item : whitelist) {
            Semver semver = Semver.build(item);
            if (semver == null) continue;
            this._semverlist.add(semver);
        }
    }

    @Override
    public boolean match(Object matchValue, String bucketingKey, Map<String, Object> attributes, EvaluationContext evaluationContext) {
        if (!(matchValue instanceof String) || this._semverlist.isEmpty()) {
            return false;
        }
        Semver matchSemver = Semver.build(matchValue.toString());
        if (matchSemver == null) {
            return false;
        }
        for (Semver semverItem : this._semverlist) {
            if (!semverItem.version().equals(matchSemver.version())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("in semver list [");
        boolean first = true;
        for (Semver item : this._semverlist) {
            if (!first) {
                bldr.append(',');
            }
            bldr.append('\"');
            bldr.append(item.version());
            bldr.append('\"');
            first = false;
        }
        bldr.append("]");
        return bldr.toString();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._semverlist.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InListSemverMatcher)) {
            return false;
        }
        InListSemverMatcher other = (InListSemverMatcher)obj;
        return this._semverlist == other._semverlist;
    }
}

