/*
 * Decompiled with CFR 0.152.
 */
package io.split.storages.memory;

import io.split.engine.experiments.ParsedRuleBasedSegment;
import io.split.storages.RuleBasedSegmentCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.collect.Maps;

public class RuleBasedSegmentCacheInMemoryImp
implements RuleBasedSegmentCache {
    private static final Logger _log = LoggerFactory.getLogger(RuleBasedSegmentCacheInMemoryImp.class);
    private final ConcurrentMap<String, ParsedRuleBasedSegment> _concurrentMap = Maps.newConcurrentMap();
    private AtomicLong _changeNumber;

    public RuleBasedSegmentCacheInMemoryImp() {
        this(-1L);
    }

    public RuleBasedSegmentCacheInMemoryImp(long startingChangeNumber) {
        this._changeNumber = new AtomicLong(startingChangeNumber);
    }

    @Override
    public boolean remove(String name) {
        ParsedRuleBasedSegment removed = (ParsedRuleBasedSegment)this._concurrentMap.remove(name);
        return removed != null;
    }

    @Override
    public ParsedRuleBasedSegment get(String name) {
        return (ParsedRuleBasedSegment)this._concurrentMap.get(name);
    }

    @Override
    public Collection<ParsedRuleBasedSegment> getAll() {
        return this._concurrentMap.values();
    }

    @Override
    public long getChangeNumber() {
        return this._changeNumber.get();
    }

    @Override
    public void setChangeNumber(long changeNumber) {
        if (changeNumber < this._changeNumber.get()) {
            _log.error("ChangeNumber for feature flags cache is less than previous");
        }
        this._changeNumber.set(changeNumber);
    }

    @Override
    public List<String> ruleBasedSegmentNames() {
        ArrayList<String> ruleBasedSegmentNamesList = new ArrayList<String>();
        for (Map.Entry key : this._concurrentMap.entrySet()) {
            ruleBasedSegmentNamesList.add(((ParsedRuleBasedSegment)key.getValue()).ruleBasedSegment());
        }
        return ruleBasedSegmentNamesList;
    }

    @Override
    public void clear() {
        this._changeNumber.set(-1L);
        this._concurrentMap.clear();
    }

    private void putMany(List<ParsedRuleBasedSegment> ruleBasedSegments) {
        for (ParsedRuleBasedSegment ruleBasedSegment : ruleBasedSegments) {
            this._concurrentMap.put(ruleBasedSegment.ruleBasedSegment(), ruleBasedSegment);
        }
    }

    @Override
    public void update(List<ParsedRuleBasedSegment> toAdd, List<String> toRemove, long changeNumber) {
        if (toAdd != null) {
            this.putMany(toAdd);
        }
        if (toRemove != null) {
            for (String ruleBasedSegment : toRemove) {
                this.remove(ruleBasedSegment);
            }
        }
        this.setChangeNumber(changeNumber);
    }

    @Override
    public Set<String> getSegments() {
        return this._concurrentMap.values().stream().flatMap(parsedRuleBasedSegment -> parsedRuleBasedSegment.getSegmentsNames().stream()).collect(Collectors.toSet());
    }

    @Override
    public boolean contains(Set<String> ruleBasedSegmentNames) {
        return this.getSegments().containsAll(ruleBasedSegmentNames);
    }
}

