/*
 * Decompiled with CFR 0.152.
 */
package io.split.storages.pluggable.adapters;

import io.split.client.dtos.RuleBasedSegment;
import io.split.client.utils.Json;
import io.split.engine.experiments.ParsedRuleBasedSegment;
import io.split.engine.experiments.RuleBasedSegmentParser;
import io.split.storages.RuleBasedSegmentCacheConsumer;
import io.split.storages.pluggable.domain.PrefixAdapter;
import io.split.storages.pluggable.domain.UserStorageWrapper;
import io.split.storages.pluggable.utils.Helper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluggable.CustomStorageWrapper;
import split.com.google.common.base.Preconditions;

public class UserCustomRuleBasedSegmentAdapterConsumer
implements RuleBasedSegmentCacheConsumer {
    private static final Logger _log = LoggerFactory.getLogger(UserCustomRuleBasedSegmentAdapterConsumer.class);
    private final RuleBasedSegmentParser _ruleBasedSegmentParser = new RuleBasedSegmentParser();
    private final UserStorageWrapper _userStorageWrapper;

    public UserCustomRuleBasedSegmentAdapterConsumer(CustomStorageWrapper customStorageWrapper) {
        this._userStorageWrapper = new UserStorageWrapper(Preconditions.checkNotNull(customStorageWrapper));
    }

    @Override
    public long getChangeNumber() {
        String wrapperResponse = this._userStorageWrapper.get(PrefixAdapter.buildRuleBasedSegmentChangeNumber());
        return Helper.responseToLong(wrapperResponse, -1L);
    }

    @Override
    public ParsedRuleBasedSegment get(String name) {
        String wrapperResponse = this._userStorageWrapper.get(PrefixAdapter.buildRuleBasedSegmentKey(name));
        if (wrapperResponse == null) {
            return null;
        }
        RuleBasedSegment ruleBasedSegment = Json.fromJson(wrapperResponse, RuleBasedSegment.class);
        if (ruleBasedSegment == null) {
            _log.warn("Could not parse RuleBasedSegment.");
            return null;
        }
        return this._ruleBasedSegmentParser.parse(ruleBasedSegment);
    }

    @Override
    public Collection<ParsedRuleBasedSegment> getAll() {
        Set<String> keys = this._userStorageWrapper.getKeysByPrefix(PrefixAdapter.buildGetAllRuleBasedSegment());
        if (keys == null) {
            return new ArrayList<ParsedRuleBasedSegment>();
        }
        List<String> wrapperResponse = this._userStorageWrapper.getMany(new ArrayList<String>(keys));
        if (wrapperResponse == null) {
            return new ArrayList<ParsedRuleBasedSegment>();
        }
        return this.stringsToParsedRuleBasedSegments(wrapperResponse);
    }

    @Override
    public List<String> ruleBasedSegmentNames() {
        Set<String> ruleBasedSegmentNamesWithPrefix = this._userStorageWrapper.getKeysByPrefix(PrefixAdapter.buildGetAllRuleBasedSegment());
        ruleBasedSegmentNamesWithPrefix = ruleBasedSegmentNamesWithPrefix.stream().map(key -> key.replace(PrefixAdapter.buildRuleBasedSegmentsPrefix(), "")).collect(Collectors.toSet());
        return new ArrayList<String>(ruleBasedSegmentNamesWithPrefix);
    }

    @Override
    public Set<String> getSegments() {
        return this.getAll().stream().flatMap(parsedRuleBasedSegment -> parsedRuleBasedSegment.getSegmentsNames().stream()).collect(Collectors.toSet());
    }

    private List<ParsedRuleBasedSegment> stringsToParsedRuleBasedSegments(List<String> elements) {
        ArrayList<ParsedRuleBasedSegment> result = new ArrayList<ParsedRuleBasedSegment>();
        for (String s2 : elements) {
            if (s2 != null) {
                result.add(this._ruleBasedSegmentParser.parse(Json.fromJson(s2, RuleBasedSegment.class)));
                continue;
            }
            result.add(null);
        }
        return result;
    }

    @Override
    public boolean contains(Set<String> ruleBasedSegmentNames) {
        return this.getSegments().containsAll(ruleBasedSegmentNames);
    }
}

